package ai.digital.deploy.sql.model;


import com.xebialabs.deployit.engine.api.dto.AbstractDto;
import com.xebialabs.xlplatform.documentation.PublicApiRef;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.stream.Stream;

/**
 * Contains the banner contents and its kind (MAINTENANCE or INFORMATION)
 */
@XmlRootElement(name = "banner-info")
@PublicApiRef
public class BannerInfo extends AbstractDto {

    @PublicApiRef
    public enum BannerKind {
        MAINTENANCE, INFORMATION;

        public static BannerKind fromValue(String value) {
            return Stream.of(values())
                    .filter(kind -> kind.name().equalsIgnoreCase(value)).findAny().orElseThrow(() ->
                            new IllegalArgumentException("Unknown value " + value));
        }
    }

    private BannerKind kind;
    private String content;

    public BannerInfo() {
        // Don't remove, it's used implicitly
    }

    public BannerInfo(BannerKind kind, String content) {
        this.kind = kind;
        this.content = content;
    }

    /**
     * Gets the banner kind
     * @return the banner kind
     */
    @XmlElement(name = "kind")
    public BannerKind getKind() {
        return kind;
    }

    /**
     * Sets the banner kind
     * @param kind - MAINTENANCE or INFORMATION
     */
    public void setKind(BannerKind kind) {
        this.kind = kind;
    }

    /**
     * Gets the message to be displayed in the banner
     * @return the banner contents
     */
    @XmlElement(name = "content")
    public String getContent() {
        return content;
    }

    /**
     * Sets the message to display in the banner
     * @param message - the message to display
     */
    public void setContent(String message) {
        this.content = message;
    }
}
