package ai.digital.deploy.sql.model

import javax.xml.bind.annotation.XmlRootElement


/**
  * Summary of active sessions
  */
@XmlRootElement class UserSessionsOverview() // Don't remove, it's used implicitly
{
  private var totalActiveUsers = 0
  private var totalControlTasks = 0
  private var totalDeploymentTasks = 0

  def this(totalActiveUsers: Int, totalControlTasks: Int, totalDeploymentTasks: Int) {
    this()
    this.totalActiveUsers = totalActiveUsers
    this.totalControlTasks = totalControlTasks
    this.totalDeploymentTasks = totalDeploymentTasks
  }

  def getTotalActiveUsers: Int = totalActiveUsers

  def setTotalActiveUsers(totalActiveUsers: Int): Unit = {
    this.totalActiveUsers = totalActiveUsers
  }

  def getTotalControlTasks: Int = totalControlTasks

  def setTotalControlTasks(totalControlTasks: Int): Unit = {
    this.totalControlTasks = totalControlTasks
  }

  def getTotalDeploymentTasks: Int = totalDeploymentTasks

  def setTotalDeploymentTasks(totalDeploymentTasks: Int): Unit = {
    this.totalDeploymentTasks = totalDeploymentTasks
  }

  override def toString: String = "UserSessionsOverview{" + "totalActiveUsers=" + totalActiveUsers + ", totalControlTasks='" + totalControlTasks + ", totalDeploymentTasks='" + totalDeploymentTasks + '}'
}
