package ai.digital.deploy.sql.model

import java.util

import com.fasterxml.jackson.annotation.JsonAnyGetter
import com.xebialabs.deployit.core.api.jaxb.MapAdapter
import com.xebialabs.deployit.engine.api.xml.OmitXmlPreamble
import com.xebialabs.xltype.serialization.util.DateUtil
import jakarta.xml.bind.annotation.XmlRootElement
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter
import org.joda.time.DateTime


@XmlRootElement(name = "lines")
@OmitXmlPreamble object ReportLine {
  def fromMap(map: util.Map[String, AnyRef]): ReportLine = {
    val reportLine = new ReportLine
    reportLine.setValues(convertValuesToString(map))
    reportLine
  }

  private def convertValuesToString(map: util.Map[String, AnyRef]): util.Map[String, AnyRef] = {
    map.replaceAll((key: String, value: Any) => {
      def foo(key: String, value: Any): String = if (value.isInstanceOf[DateTime]) DateUtil.toString(value.asInstanceOf[DateTime])
      else if (value != null) value.toString
      else null

      foo(key, value)
    })
    map
  }
}

@XmlRootElement(name = "lines")
@OmitXmlPreamble class ReportLine {
  private var values: util.Map[String, AnyRef] = _

  @JsonAnyGetter
  @XmlJavaTypeAdapter(classOf[MapAdapter]) def getValues: util.Map[String, AnyRef] = values

  def setValues(values: util.Map[String, AnyRef]): Unit = {
    this.values = values
  }

  def addValue(key: String, value: AnyRef): Unit = {
    if (values == null) values = new util.HashMap[String, AnyRef]
    values.put(key, value)
  }
}
