package ai.digital.deploy.sql.model

import com.xebialabs.xlplatform.documentation.PublicApiRef
import jakarta.xml.bind.annotation.XmlRootElement


/**
  * Information about placeholders: its key, on which Configuration Item (ID and Type) it is defined, and whether the user is
  * allowed to read its value
  */
@XmlRootElement
@PublicApiRef class DefinedPlaceholderView() {
  private var key: String = _
  private var ciId: String = _
  private var ciType: String = _
  private var canRead: Boolean = false

  def this(key: String, ciId: String, ciType: String, canRead: Boolean) {
    this()
    this.key = key
    this.ciId = ciId
    this.ciType = ciType
    this.canRead = canRead
  }

  def getKey: String = key

  def setKey(key: String): Unit = {
    this.key = key
  }

  def getCiId: String = ciId

  def setCiId(ciId: String): Unit = {
    this.ciId = ciId
  }

  def getCiType: String = ciType

  def setCiType(ciType: String): Unit = {
    this.ciType = ciType
  }

  def getCanRead: Boolean = canRead

  def setCanRead(canRead: Boolean): Unit = {
    this.canRead = canRead
  }

  override def toString: String = "DefinedPlaceholderView{" + "key='" + key + '\'' + ", ciId='" + ciId + '\'' + ", ciType='" + ciType + '\'' + ", canRead=" + canRead + '}'
}
