package com.xebialabs.deployit.repository

import com.xebialabs.deployit.plugin.api.udm.ExternalProperty
import com.xebialabs.deployit.plugin.api.udm.lookup.{LookupValueKey, LookupValueProvider}
import com.xebialabs.deployit.service.externalproperties.ExternalValueProvider
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

@Component
class ExternalPropertyLookupValueProvider(@Autowired repositoryService: RepositoryService) extends ExternalValueProvider {

  override def supports(externalProperty: ExternalProperty): Boolean = externalProperty.isInstanceOf[LookupValueKey]

  override def resolve(externalProperty: ExternalProperty, password: Boolean): String = {
    val lookupValueKey = externalProperty.asInstanceOf[LookupValueKey]
    val lookupValueProvider: LookupValueProvider = getLookupValueProvider(lookupValueKey)
    lookupValueProvider.lookup(lookupValueKey.getKey, password)
  }

  override def isProviderAvailable(externalProperty: ExternalProperty): Boolean = {
    val lookupValueKey = externalProperty.asInstanceOf[LookupValueKey]
    val lookupValueProvider: LookupValueProvider = getLookupValueProvider(lookupValueKey)
    lookupValueProvider.isHealthy
  }

  private def getLookupValueProvider(lookupValueKey: LookupValueKey) = {
    repositoryService.read(lookupValueKey.getProviderId).asInstanceOf[LookupValueProvider]
  }
}
