package com.xebialabs.deployit.repository.sql.artifacts

import java.io.{File, InputStream}
import com.xebialabs.deployit.core.sql.SchemaInfo
import com.xebialabs.deployit.repository.sql.base.CiPKType
import org.springframework.jdbc.core.JdbcTemplate

trait FileArtifactDataRepository extends ArtifactDataRepository {

  val jdbcTemplate: JdbcTemplate
  val root: File
  implicit val schemaInfo: SchemaInfo

  def remove(artifactId: Number): Int

  def insert(location: String): Int

  def insertUsage(id: Number, pk: CiPKType): Unit

  def storeToTemp(inputStream: InputStream): File

  def getLocation(id: Number): File

  def fileFromRelativePath(path: String): File

}
