package com.xebialabs.deployit.repository.sql.specific.columns

import com.xebialabs.deployit.core.sql._
import com.xebialabs.deployit.core.sql.spring.Setter
import com.xebialabs.deployit.repository.sql.base.CiPKType
import org.springframework.jdbc.core.JdbcTemplate

import scala.collection.mutable

class PropertyColumnsUpdater(val table: TableName, val idColumn: ColumnName, val columns: Map[String, ColumnName] = Map())
                            (implicit val jdbcTemplate: JdbcTemplate, implicit val schemaInfo: SchemaInfo)
  extends Queries {
  def column(propertyName: String): Option[ColumnName] = columns.get(propertyName)
  def setValues(pk: CiPKType, values: mutable.Map[ColumnName, Any]): Unit = {
    if (values.nonEmpty) {
      val entries = values.toList
      val statement = sqlb"update $table set ${entries.map(_._1.build(None)).mkString("", " = ?,", " = ?")} where $idColumn = ?"
      jdbcTemplate.update(statement, Setter(entries.map(_._2) :+ pk))
    }
  }
}
