package com.xebialabs.deployit.repository.sql.cache.queue

import com.xebialabs.deployit.repository.sql.base.CiPKType
import com.xebialabs.deployit.repository.sql.cache.CisCacheDataProcessor
import grizzled.slf4j.Logging
import org.springframework.context.annotation.DependsOn
import org.springframework.jms.annotation.JmsListener
import org.springframework.jms.support.converter.MessageConverter
import org.springframework.stereotype.Component
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty

import javax.jms.TextMessage

@Component
@ConditionalOnProperty(prefix = "deploy.caches", name = Array("enabled"), havingValue = "true")
@DependsOn(value = Array("cacheMode"))
class CacheEvictionListener(jacksonJmsMessageConverter: MessageConverter, cisCacheDataProcessor: CisCacheDataProcessor) extends Logging {
  @JmsListener(
    destination = "#{@cacheEvictionTopicNameResolver.getCacheEvictionTopicName()}",
    containerFactory = "xlJmsListenerContainerFactory"
  )
  def receiveTextMessage(message: TextMessage): Unit = {
    logger.trace("Received eviction message")
    jacksonJmsMessageConverter.fromMessage(message) match {
      case event: Map[CiPKType, String] =>
        cisCacheDataProcessor.removeCaches(event)
      case _ =>
        logger.error(s"Received unknown ${message.getJMSMessageID} timestamp: ${message.getJMSTimestamp} [$message]")
    }
  }
}
