package com.xebialabs.deployit.repository.sql.cache

import com.xebialabs.deployit.engine.spi.event._
import com.xebialabs.deployit.repository.sql.cache.events.{ConsolidatedCiMovedEvent, ConsolidatedCiRenamedEvent, ConsolidatedCiUpdateEvent}
import grizzled.slf4j.Logging
import nl.javadude.t2bus.Subscribe

import scala.jdk.CollectionConverters._

@DeployitEventListener
class CisEventListener extends Logging {

  @Subscribe
  def onUpdate(event: ConsolidatedCiUpdateEvent): Unit = {
    val cis = event.updatedCisInfos
    logger.trace(s"Clearing Ci data for updated $cis.")
    CiCacheDataServicesHolder
      .getCiCacheDataServiceFacade
      .removeAll(cis.map(ci => ci.pk -> ci.id).toMap)
  }

  @Subscribe
  def onDelete(event: CisDeletedEvent): Unit = {
    val cis = event.getCis.asScala
    logger.trace(s"Clearing Ci data for deleted (${cis.map(ci => (ci.getId, ci.get$internalId()))}).")
    CiCacheDataServicesHolder
      .getCiCacheDataServiceFacade
      .removeAll(cis.map(ci => ci.get$internalId() -> ci.getId).toMap)
  }

  @Subscribe
  def onRename(event: ConsolidatedCiRenamedEvent): Unit = {
    val cis = event.pathModifiedCisInfo
    logger.trace(s"Clearing Ci data for renamed $cis.")
    CiCacheDataServicesHolder
      .getCiCacheDataServiceFacade
      .removeAll(cis.map(ci => ci.pk -> ci.oldId).toMap)
  }

  @Subscribe
  def onMove(event: ConsolidatedCiMovedEvent): Unit = {
    val cis = event.pathModifiedCisInfo
    logger.trace(s"Clearing Ci data for moved $cis.")
    CiCacheDataServicesHolder
      .getCiCacheDataServiceFacade
      .removeAll(cis.map(ci => ci.pk -> ci.oldId).toMap)
  }

}
