package com.xebialabs.deployit.repository.sql.cache.events

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import com.xebialabs.deployit.repository.sql.base.CiPKType
import org.joda.time.DateTime

case class ConsolidatedCiRenamedEvent(baseModifiedCi: ConfigurationItem,
                                      pathModifiedCisInfo: List[CiPathModifiedInfo]) {
}

case class ConsolidatedCiMovedEvent(baseModifiedCi: ConfigurationItem,
                                    newSecuredCiPk: CiPKType,
                                    newSecuredDirRef: String,
                                    newDirectoryRef: String,
                                    pathModifiedCisInfo: List[CiPathModifiedInfo]) {
}

case class CiPathModifiedInfo(pk: CiPKType,
                              oldId: String,
                              oldPath: String,
                              oldName: String,
                              newId: String,
                              newPath: String,
                              newName: String)

case class ConsolidatedCiUpdateEvent(updatedCisInfos: List[CiUpdateInfo])

case class CiUpdateInfo(token: String,
                        id: String,
                        lastModifiedAt: DateTime,
                        lastModifiedBy: String,
                        scmTraceabilityDataId: Integer,
                        pk: CiPKType,
                        previousToken: String)
