package com.xebialabs.deployit.repository.sql.cache

import com.xebialabs.deployit.engine.spi.event.CisDeletedEvent
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import com.xebialabs.deployit.repository.sql.base.CiPKType
import org.joda.time.DateTime

import java.util

case class ConsolidatedCiRenamedInfo(baseModifiedCi: ConfigurationItem,
                                     pathModifiedCisInfo: List[CiPathModifiedInfo]) {
}

case class ConsolidatedCiMovedInfo(baseModifiedCi: ConfigurationItem,
                                   newSecuredCiPk: CiPKType,
                                   newSecuredDirRef: String,
                                   newDirectoryRef: String,
                                   pathModifiedCisInfo: List[CiPathModifiedInfo]) {
}

case class CiPathModifiedInfo(pk: CiPKType,
                              oldId: String,
                              oldPath: String,
                              oldName: String,
                              newId: String,
                              newPath: String,
                              newName: String)

case class ConsolidatedCiUpdateInfo(updatedCisInfos: List[CiUpdateInfo])

case class CiUpdateInfo(token: String,
                        id: String,
                        lastModifiedAt: DateTime,
                        lastModifiedBy: String,
                        scmTraceabilityDataId: Integer,
                        pk: CiPKType,
                        previousToken: String)

case class ConsolidatedCiDeletedInfo(cis: util.List[ConfigurationItem]) extends CisDeletedEvent(cis)
