package com.xebialabs.deployit.repository.sql.cache

case class CiAppCacheContext(useCache: Boolean) {
}

object CiAppCacheContext {

  private val CI_CACHE_CONTEXT_HOLDER = new ThreadLocal[CiAppCacheContext]()

  def init(useCache: Boolean): Unit = CI_CACHE_CONTEXT_HOLDER.set(new CiAppCacheContext(useCache))

  def clear(): Unit = CI_CACHE_CONTEXT_HOLDER.remove()

  def useCache: Boolean = Option(CI_CACHE_CONTEXT_HOLDER.get)
    .getOrElse(new CiAppCacheContext(false))
    .useCache
}