package com.xebialabs.deployit.repository.sql.base

import com.xebialabs.deployit.core.sql.Queries
import SCMTraceabilityDBData._
import com.xebialabs.deployit.sql.base.schema.CIS

trait SCMTraceabilityDataQueries extends Queries {
  lazy val SCM_TRACEABILITY_DATA_SELECT_BY_ID: String = sqlb"select * from $tableName where $ID = ?"

  lazy val SCM_TRACEABILITY_DATA_INSERT: String =
    sqlb"insert into $tableName ($kind, $commit, $author, $date, $message, $remote, $file_name) values (?, ?, ?, ?, ?, ?, ?)"

  lazy val SCM_TRACEABILITY_DATA_UPDATE: String =
    sqlb"update $tableName set $kind = ?, $commit = ?, $author = ?, $date = ?, $message = ?, $remote = ?, $file_name = ? where $ID = ?"

  lazy val SCM_TRACEABILITY_DATA_DELETE = sqlb"delete from $tableName where $ID = ?"

  lazy val SCM_TRACEABILITY_DELETE_WHERE_CI_PATH_LIKE = sqlb"delete from $tableName where $ID IN (SELECT ${CIS.scm_traceability_data_id} from ${CIS.tableName} where (${CIS.path} = ? or ${CIS.path} like ?) and ${CIS.scm_traceability_data_id} is not null)"
}
