package com.xebialabs.deployit.security.service.impl

import com.xebialabs.deployit.exception.NotFoundException
import com.xebialabs.deployit.security.model.XldUserProfile
import com.xebialabs.deployit.security.repository.XldUserProfileRepository
import com.xebialabs.deployit.security.service.UserProfileService
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service

@Service
class UserProfileServiceImpl(@Autowired xldUserProfileRepository: XldUserProfileRepository) extends UserProfileService{
  override def findOne(username: String, loadCredentials: Boolean): XldUserProfile =
    xldUserProfileRepository.findOne(username, loadCredentials)
    .getOrElse(throw new NotFoundException(s"No user profile found for user: $username"))

  override def findOne(username: String): XldUserProfile = findOne(username, loadCredentials = false)

  override def createOrUpdate(username: String, analyticsEnabled: Boolean): Unit = {
    xldUserProfileRepository.findOne(username) match {
      case Some(_) => xldUserProfileRepository.updateProfile(username, analyticsEnabled)
      case None => xldUserProfileRepository.createProfile(username, analyticsEnabled)
    }
  }
}
