package com.xebialabs.deployit.security.service.impl

import com.xebialabs.deployit.exception.NotFoundException
import com.xebialabs.deployit.security.RoleService
import com.xebialabs.deployit.security.model.XldUserProfile
import com.xebialabs.deployit.security.repository.XldUserProfileRepository
import com.xebialabs.deployit.security.service.UserProfileService
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.security.core.context.SecurityContextHolder
import org.springframework.stereotype.Service

import scala.util.{Failure, Success, Try}

@Service
class UserProfileServiceImpl(@Autowired xldUserProfileRepository: XldUserProfileRepository,
                             @Autowired roleService: RoleService) extends UserProfileService{
  override def findOne(username: String, loadCredentials: Boolean): XldUserProfile = {

    // Handling external user profile's
    xldUserProfileRepository.findOne(username) match {
      case Some(_) => identity()
      case None =>
        Try(roleService.getRolesFor(SecurityContextHolder.getContext.getAuthentication)) match {
            case Success(_) => xldUserProfileRepository.createProfile(username, loadCredentials)
            case Failure(_) => throw new NotFoundException(s"No user profile found for user: $username")
      }
    }
    xldUserProfileRepository.findOne(username, loadCredentials)
      .getOrElse(throw new NotFoundException(s"No user profile found for user: $username"))
  }

  override def findOne(username: String): XldUserProfile = findOne(username, loadCredentials = false)

  override def createOrUpdate(username: String, analyticsEnabled: Boolean): Unit = {
    xldUserProfileRepository.findOne(username) match {
      case Some(_) => xldUserProfileRepository.updateProfile(username, analyticsEnabled)
      case None => xldUserProfileRepository.createProfile(username, analyticsEnabled)
    }
  }
}
