package com.xebialabs.deployit.security.sql

import com.xebialabs.deployit.ServerConfiguration
import com.xebialabs.deployit.security.{User, UserService}
import com.xebialabs.deployit.server.api.upgrade.{ApplicableRepoTypes, RepoType, RepositoryInitialization}
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired

@ApplicableRepoTypes(Array(RepoType.SQL))
class SqlSecurityInitializer (@Autowired val userService: UserService,
                              @Autowired val serverConfiguration: ServerConfiguration)
  extends RepositoryInitialization with Logging {

  override def doInitialize() = createAdminUsersIfNeeded()

  private def createAdminUsersIfNeeded(): User = createUserIfNeeded("admin", serverConfiguration.getAdminPassword)

  private def createUserIfNeeded(userId: String, password: String): User = {
    try {
      userService.read(userId)
    } catch {
      case _: Exception =>
        userService.create(userId, password)
        userService.read(userId)
    }
  }

  override def getComponent = "deployit"
}
