package com.xebialabs.deployit.security.sql

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.deployit.security.GLOBAL_ID

sealed trait CiResolvedType {
  val pk: Number
}

object GlobalResolvedCi extends CiResolvedType {
  override val pk: Number = GLOBAL_ID
}

case class ResolvedCi(pk: Number,
                      path: String,
                      ciType: Type,
                      parentPk: Option[Number],
                      securedCiPk: Option[Number],
                      directoryUuid: Option[String],
                      directoryRef: Option[String],
                      securedDirectoryRef: Option[String])
  extends CiResolvedType

trait CiResolver {

  def getPkFromId(id: String): Number

  def getPksFromIds(id: Iterable[String]): Map[String, Integer]

  def getResolvedCiFromId(id: String): ResolvedCi

  def getIdFromPk(pk: Number): String

  def getIdsFromPks(pks: Iterable[Number]): Map[Integer, String]

  def getSecuredCiId(id: String): Option[Number]

  def getSecuredCiId(pk: Number): Option[Number]

  def setSecuredCiId(resolvedCi: ResolvedCi): Unit

  def removeSecuredCi(resolvedCi: ResolvedCi, parentSecuredCiPk: Option[Number]): Unit

  def getResolvedCiFromReferences(references: List[String]): List[ResolvedCi]

  def getResolvedCiFromReferences(references: List[String], ciTypes: Option[List[Type]] = None, securedDirOnly: Boolean = false): List[ResolvedCi]

  def resolveDirectoryReference(id: String): String

  def resolveDirectoryReference(pk: Number): String

  def getDirectoryUuid(id: String): Option[String]

  def getDirectoryUuid(pk: Number): Option[String]

  def getDirectoryReference(id: String): Option[String]

  def getSecuredDirectoryReference(pk: Number): Option[String]

  def setSecuredDirectoryReference(resolvedCi: ResolvedCi): Unit

  def removeSecuredDirectoryReference(resolvedCi: ResolvedCi, parentSecuredDirRef: Option[String]): Unit
}
