package com.xebialabs.deployit.security.sql

import com.xebialabs.deployit.ServerConfiguration
import com.xebialabs.deployit.security.model.{XldUserProfile}
import com.xebialabs.deployit.security.repository.XldUserProfileRepository
import com.xebialabs.deployit.security.{User, UserService}
import com.xebialabs.deployit.server.api.upgrade.{ApplicableRepoTypes, RepoType, RepositoryInitialization}
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired

@ApplicableRepoTypes(Array(RepoType.SQL))
class SqlSecurityInitializer (@Autowired val userService: UserService,
                              @Autowired val serverConfiguration: ServerConfiguration,
                              @Autowired val userProfileRepository: XldUserProfileRepository)
  extends RepositoryInitialization with Logging {

  override def doInitialize() = createAdminUsersIfNeeded()

  private def createAdminUsersIfNeeded(): User = createUserIfNeeded("admin", serverConfiguration.getAdminPassword)

  private def createUserIfNeeded(userId: String, password: String): User = {
    try {
      userService.read(userId)
    } catch {
      case _: Exception =>
        userService.create(userId, password)
        val userProfile = XldUserProfile(userId, true, s"Deploy Administrator", null,true,null, true, userId)
        userProfileRepository.createUserProfile(userProfile)
        userService.read(userId)
    }
  }

  override def getComponent = "deployit"
}
