/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security.service.impl;

import com.xebialabs.deployit.engine.api.dto.Ordering;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.model.XldUserProfile;
import com.xebialabs.deployit.security.model.XldUserProfile$;
import com.xebialabs.deployit.security.repository.XldUserProfileRepository;
import com.xebialabs.deployit.security.service.UserProfileService;
import com.xebialabs.license.LicenseProperty;
import com.xebialabs.license.service.LicenseService;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.reflect.ScalaSignature;

@Service
@ScalaSignature(bytes="\u0006\u0005\u00055f\u0001\u0002\t\u0012\u0001yA\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005\u0001\"AQ\t\u0001B\u0001B\u0003%a\tC\u0003O\u0001\u0011\u0005q\nC\u0003Y\u0001\u0011\u0005\u0013\fC\u0003Y\u0001\u0011\u0005#\u000fC\u0003u\u0001\u0011\u0005S\u000fC\u0003}\u0001\u0011\u0005S\u0010C\u0004\u0002\u0002\u0001!I!a\u0001\t\u0013\u0005-\u0001!%A\u0005\n\u00055\u0001bBA\u0011\u0001\u0011%\u00111\u0005\u0005\b\u0003s\u0001A\u0011IA\u001e\u0011\u001d\t\u0019\u0005\u0001C!\u0003\u000bBq!!\u0017\u0001\t\u0003\nY\u0006C\u0004\u0002n\u0001!\t%a\u001c\u0003-U\u001bXM\u001d)s_\u001aLG.Z*feZL7-Z%na2T!AE\n\u0002\t%l\u0007\u000f\u001c\u0006\u0003)U\tqa]3sm&\u001cWM\u0003\u0002\u0017/\u0005A1/Z2ve&$\u0018P\u0003\u0002\u00193\u0005AA-\u001a9m_fLGO\u0003\u0002\u001b7\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u00029\u0005\u00191m\\7\u0004\u0001M\u0019\u0001aH\u0013\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0003\t\nQa]2bY\u0006L!\u0001J\u0011\u0003\r\u0005s\u0017PU3g!\t1s%D\u0001\u0014\u0013\tA3C\u0001\nVg\u0016\u0014\bK]8gS2,7+\u001a:wS\u000e,\u0017\u0001\u0007=mIV\u001bXM\u001d)s_\u001aLG.\u001a*fa>\u001c\u0018\u000e^8ssB\u00111FL\u0007\u0002Y)\u0011Q&F\u0001\u000be\u0016\u0004xn]5u_JL\u0018BA\u0018-\u0005aAF\u000eZ+tKJ\u0004&o\u001c4jY\u0016\u0014V\r]8tSR|'/\u001f\u0015\u0003\u0003E\u0002\"AM\u001f\u000e\u0003MR!\u0001N\u001b\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u00027o\u00059a-Y2u_JL(B\u0001\u001d:\u0003\u0015\u0011W-\u00198t\u0015\tQ4(A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005a\u0014aA8sO&\u0011ah\r\u0002\n\u0003V$xn^5sK\u0012\f1B]8mKN+'O^5dKB\u0011\u0011IQ\u0007\u0002+%\u00111)\u0006\u0002\f%>dWmU3sm&\u001cW\r\u000b\u0002\u0003c\u0005qA.[2f]N,7+\u001a:wS\u000e,\u0007CA$L\u001b\u0005A%B\u0001\u000bJ\u0015\tQ\u0015$A\u0004mS\u000e,gn]3\n\u00051C%A\u0004'jG\u0016t7/Z*feZL7-\u001a\u0015\u0003\u0007E\na\u0001P5oSRtD\u0003\u0002)S)Z\u0003\"!\u0015\u0001\u000e\u0003EAQ!\u000b\u0003A\u0002)B#AU\u0019\t\u000b}\"\u0001\u0019\u0001!)\u0005Q\u000b\u0004\"B#\u0005\u0001\u00041\u0005F\u0001,2\u0003\u001d1\u0017N\u001c3P]\u0016$2A\u00171n!\tYf,D\u0001]\u0015\tiV#A\u0003n_\u0012,G.\u0003\u0002`9\nq\u0001\f\u001c3Vg\u0016\u0014\bK]8gS2,\u0007\"B1\u0006\u0001\u0004\u0011\u0017\u0001C;tKJt\u0017-\\3\u0011\u0005\rTgB\u00013i!\t)\u0017%D\u0001g\u0015\t9W$\u0001\u0004=e>|GOP\u0005\u0003S\u0006\na\u0001\u0015:fI\u00164\u0017BA6m\u0005\u0019\u0019FO]5oO*\u0011\u0011.\t\u0005\u0006]\u0016\u0001\ra\\\u0001\u0010Y>\fGm\u0011:fI\u0016tG/[1mgB\u0011\u0001\u0005]\u0005\u0003c\u0006\u0012qAQ8pY\u0016\fg\u000e\u0006\u0002[g\")\u0011M\u0002a\u0001E\u0006q1M]3bi\u0016|%/\u00169eCR,Gc\u0001<zuB\u0011\u0001e^\u0005\u0003q\u0006\u0012A!\u00168ji\")\u0011m\u0002a\u0001E\"91p\u0002I\u0001\u0002\u0004y\u0017\u0001E1oC2LH/[2t\u000b:\f'\r\\3e\u0003e\u0019'/Z1uK>\u0013X\u000b\u001d3bi\u0016,6/\u001a:Qe>4\u0017\u000e\\3\u0015\u0005Yt\b\"B@\t\u0001\u0004Q\u0016a\u00029s_\u001aLG.Z\u0001\u001ee\u00164xn[3M_\u001eLg.\u00117m_^,G-Q2d_J$\u0017N\\4U_R)!,!\u0002\u0002\b!)q0\u0003a\u00015\"A\u0011\u0011B\u0005\u0011\u0002\u0003\u0007!,\u0001\u0006eE~\u0003(o\u001c4jY\u0016\fqE]3w_.,Gj\\4j]\u0006cGn\\<fI\u0006\u001b7m\u001c:eS:<Gk\u001c\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011q\u0002\u0016\u00045\u0006E1FAA\n!\u0011\t)\"!\b\u000e\u0005\u0005]!\u0002BA\r\u00037\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005Q\n\u0013\u0002BA\u0010\u0003/\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003eA\u0017m\u001d'jG\u0016t7/\u001a+p\u0007J,\u0017\r^3OK^,6/\u001a:\u0015\u0007=\f)\u0003C\u0004\u0002(-\u0001\r!!\u000b\u0002\u000b\r|WO\u001c;\u0011\t\u0005-\u0012QG\u0007\u0003\u0003[QA!a\f\u00022\u0005!A.\u00198h\u0015\t\t\u0019$\u0001\u0003kCZ\f\u0017\u0002BA\u001c\u0003[\u0011q!\u00138uK\u001e,'/A\rd_VtG/V:fe^KG\u000f\u001b'pO&t\u0017\t\u001c7po\u0016$GCAA\u001f!\r\u0001\u0013qH\u0005\u0004\u0003\u0003\n#aA%oi\u0006\u0001R\u000f\u001d3bi\u0016d\u0015m\u001d;BGRLg/\u001a\u000b\u0007\u0003{\t9%!\u0013\t\u000b\u0005l\u0001\u0019\u00012\t\u000f\u0005-S\u00021\u0001\u0002N\u0005!A-\u0019;f!\u0011\ty%!\u0016\u000e\u0005\u0005E#\u0002BA*\u0003c\tA!\u001e;jY&!\u0011qKA)\u0005\u0011!\u0015\r^3\u0002\u0015\r|WO\u001c;Vg\u0016\u00148\u000f\u0006\u0005\u0002^\u0005\r\u0014QMA5!\r\u0001\u0013qL\u0005\u0004\u0003C\n#\u0001\u0002'p]\u001eDQ!\u0019\bA\u0002\tDa!a\u001a\u000f\u0001\u0004\u0011\u0017\u0001\u00034vY2t\u0015-\\3\t\r\u0005-d\u00021\u0001c\u0003\u0015)W.Y5m\u0003Ma\u0017n\u001d;BY2,6/\u001a:Qe>4\u0017\u000e\\3t)1\t\t(a\u001e\u0002z\u0005m\u0014QPAK!\u0015\ty%a\u001d[\u0013\u0011\t)(!\u0015\u0003\t1K7\u000f\u001e\u0005\u0006C>\u0001\rA\u0019\u0005\u0007\u0003Oz\u0001\u0019\u00012\t\r\u0005-t\u00021\u0001c\u0011\u001d\tyh\u0004a\u0001\u0003\u0003\u000ba\u0001]1hS:<\u0007\u0003BAB\u0003#k!!!\"\u000b\t\u0005\u001d\u0015\u0011R\u0001\u0004IR|'\u0002BAF\u0003\u001b\u000b1!\u00199j\u0015\r\tyiF\u0001\u0007K:<\u0017N\\3\n\t\u0005M\u0015Q\u0011\u0002\u0007!\u0006<\u0017N\\4\t\u000f\u0005]u\u00021\u0001\u0002\u001a\u0006)qN\u001d3feB!\u00111QAN\u0013\u0011\ti*!\"\u0003\u0011=\u0013H-\u001a:j]\u001eD3\u0001AAQ!\u0011\t\u0019+!+\u000e\u0005\u0005\u0015&bAATs\u0005Q1\u000f^3sK>$\u0018\u0010]3\n\t\u0005-\u0016Q\u0015\u0002\b'\u0016\u0014h/[2f\u0001")
public class UserProfileServiceImpl
implements UserProfileService {
    @Autowired
    private final XldUserProfileRepository xldUserProfileRepository;
    @Autowired
    private final LicenseService licenseService;

    @Override
    public boolean createOrUpdate$default$2() {
        return UserProfileService.createOrUpdate$default$2$(this);
    }

    @Override
    public XldUserProfile findOne(String username, boolean loadCredentials) {
        return (XldUserProfile)this.xldUserProfileRepository.findOne(username, loadCredentials).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("No user profile found for user: " + username, new Object[0]);
        });
    }

    @Override
    public XldUserProfile findOne(String username) {
        return this.findOne(username, false);
    }

    @Override
    public void createOrUpdate(String username, boolean analyticsEnabled) {
        Option<XldUserProfile> option = this.xldUserProfileRepository.findOne(username, this.xldUserProfileRepository.findOne$default$2());
        if (option instanceof Some) {
            this.xldUserProfileRepository.updateProfile(username, analyticsEnabled);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            this.xldUserProfileRepository.createProfile(username, analyticsEnabled);
            return;
        }
        throw new MatchError(option);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void createOrUpdateUserProfile(XldUserProfile profile) {
        existingProfile = this.xldUserProfileRepository.findOne(profile.username(), this.xldUserProfileRepository.findOne$default$2());
        var5_3 = false;
        var6_4 = null;
        var7_5 = existingProfile;
        if (!(var7_5 instanceof Some)) ** GOTO lbl-1000
        var5_3 = true;
        var6_4 = (Some)var7_5;
        db_profile = (XldUserProfile)var6_4.value();
        if (profile.loginAllowed() && !profile.username().toLowerCase().equals("admin")) {
            v0 = this.revokeLoginAllowedAccordingTo(profile, db_profile);
        } else if (var5_3) {
            v0 = profile;
        } else if (None$.MODULE$.equals(var7_5)) {
            v0 = this.revokeLoginAllowedAccordingTo(profile, this.revokeLoginAllowedAccordingTo$default$2());
        } else {
            throw new MatchError(var7_5);
        }
        updatedProfile = v0;
        if (existingProfile.isDefined()) {
            this.xldUserProfileRepository.updateUserProfile(updatedProfile);
            return;
        }
        this.xldUserProfileRepository.createUserProfile(updatedProfile);
    }

    private XldUserProfile revokeLoginAllowedAccordingTo(XldUserProfile profile, XldUserProfile db_profile) {
        int count;
        if (!profile.loginAllowed()) {
            return profile;
        }
        int n = count = db_profile != null && db_profile.loginAllowed() ? 1 : 0;
        if (!this.hasLicenseToCreateNewUser(Predef$.MODULE$.int2Integer(count))) {
            return XldUserProfile$.MODULE$.apply(profile.username(), profile.analyticsEnabled(), profile.fullName(), profile.email(), false, profile.lastActive(), profile.isInternal());
        }
        return profile;
    }

    private XldUserProfile revokeLoginAllowedAccordingTo$default$2() {
        return null;
    }

    private boolean hasLicenseToCreateNewUser(Integer count) {
        String maxNumberOfUsers = this.licenseService.getLicense().getStringValue(LicenseProperty.MAX_NUMBER_OF_USERS);
        if (maxNumberOfUsers != null) {
            int countUserWithLoginAllowed = this.xldUserProfileRepository.countUserWithLoginAllowed() - Predef$.MODULE$.Integer2int(count);
            return Integer.parseInt(maxNumberOfUsers) > countUserWithLoginAllowed;
        }
        return true;
    }

    @Override
    public int countUserWithLoginAllowed() {
        return this.xldUserProfileRepository.countUserWithLoginAllowed();
    }

    @Override
    public int updateLastActive(String username, Date date) {
        return this.xldUserProfileRepository.updateLastActive(username, date);
    }

    @Override
    public long countUsers(String username, String fullName, String email) {
        return this.xldUserProfileRepository.countUsers(username, fullName, email);
    }

    @Override
    public List<XldUserProfile> listAllUserProfiles(String username, String fullName, String email, Paging paging, Ordering order) {
        return this.xldUserProfileRepository.listAllUserProfiles(username, fullName, email, paging, order);
    }

    public UserProfileServiceImpl(@Autowired XldUserProfileRepository xldUserProfileRepository, @Autowired RoleService roleService, @Autowired LicenseService licenseService) {
        this.xldUserProfileRepository = xldUserProfileRepository;
        this.licenseService = licenseService;
    }
}

