package com.xebialabs.deployit.security.model

import java.util.Date

case class Tokens(createdDate: Date,
                  lastUsedDate: Date,
                  expiryDate: Date,
                  tokenNote : String,
                  tokenHash: String,
                  ciId: Integer)

object Tokens {
  def apply(createdDate: Date,
            lastUsedDate: Date,
            expiryDate: Date,
            tokenNote : String,
            tokenHash: String,
            ciId: Integer): Tokens = {
    new Tokens(createdDate, lastUsedDate, expiryDate, tokenNote, tokenHash, ciId)
  }
  def apply(createdDate: Date, expiryDate: Date, tokenNote: String, tokenHash: String): Tokens = {
    new Tokens(createdDate, null, expiryDate, tokenNote, tokenHash, null)
  }
}

case class XldUserToken(username: String, tokens: List[Tokens])
object XldUserToken {
  def apply(username: String,
            tokens: Tokens*): XldUserToken = XldUserToken(username, tokens.toList)
  def apply(username: String,
           ): XldUserToken = XldUserToken(username,List.empty[Tokens])
}
