/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security.service.impl;

import com.xebialabs.deployit.core.util.TokenGenerator$;
import com.xebialabs.deployit.engine.api.dto.Ordering;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.security.model.Tokens;
import com.xebialabs.deployit.security.model.Tokens$;
import com.xebialabs.deployit.security.model.XldUserToken;
import com.xebialabs.deployit.security.repository.XldUserTokenRespository;
import com.xebialabs.deployit.security.service.UserTokenService;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Predef$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ScalaSignature;

@Service
@ScalaSignature(bytes="\u0006\u0005\u00055a\u0001\u0002\u0004\b\u0001QA\u0001b\b\u0001\u0003\u0002\u0003\u0006I\u0001\t\u0005\u0006k\u0001!\tA\u000e\u0005\u0006w\u0001!\t\u0005\u0010\u0005\u0006G\u0002!\t\u0005\u001a\u0005\u0006c\u0002!\tE\u001d\u0002\u0015+N,'\u000fV8lK:\u001cVM\u001d<jG\u0016LU\u000e\u001d7\u000b\u0005!I\u0011\u0001B5na2T!AC\u0006\u0002\u000fM,'O^5dK*\u0011A\"D\u0001\tg\u0016\u001cWO]5us*\u0011abD\u0001\tI\u0016\u0004Hn\\=ji*\u0011\u0001#E\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011AE\u0001\u0004G>l7\u0001A\n\u0004\u0001UY\u0002C\u0001\f\u001a\u001b\u00059\"\"\u0001\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005i9\"AB!osJ+g\r\u0005\u0002\u001d;5\t\u0011\"\u0003\u0002\u001f\u0013\t\u0001Rk]3s)>\\WM\\*feZL7-Z\u0001\u0017q2$Wk]3s)>\\WM\u001c*fa>\u001c\u0018\u000e^8ssB\u0011\u0011\u0005J\u0007\u0002E)\u00111eC\u0001\u000be\u0016\u0004xn]5u_JL\u0018BA\u0013#\u0005]AF\u000eZ+tKJ$vn[3o%\u0016\u001c\bo\\:ji>\u0014\u0018\u0010\u000b\u0002\u0002OA\u0011\u0001fM\u0007\u0002S)\u0011!fK\u0001\u000bC:tw\u000e^1uS>t'B\u0001\u0017.\u0003\u001d1\u0017m\u0019;pefT!AL\u0018\u0002\u000b\t,\u0017M\\:\u000b\u0005A\n\u0014aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003I\n1a\u001c:h\u0013\t!\u0014FA\u0005BkR|w/\u001b:fI\u00061A(\u001b8jiz\"\"aN\u001d\u0011\u0005a\u0002Q\"A\u0004\t\u000b}\u0011\u0001\u0019\u0001\u0011)\u0005e:\u0013a\u00067jgR,6/\u001a:U_.,gNQ=Vg\u0016\u0014h*Y7f)\u0015i4\t\u0015/b!\tq\u0014)D\u0001@\u0015\t\u00015\"A\u0003n_\u0012,G.\u0003\u0002C\u007f\ta\u0001\f\u001c3Vg\u0016\u0014Hk\\6f]\")Ai\u0001a\u0001\u000b\u0006AQo]3s]\u0006lW\r\u0005\u0002G\u001b:\u0011qi\u0013\t\u0003\u0011^i\u0011!\u0013\u0006\u0003\u0015N\ta\u0001\u0010:p_Rt\u0014B\u0001'\u0018\u0003\u0019\u0001&/\u001a3fM&\u0011aj\u0014\u0002\u0007'R\u0014\u0018N\\4\u000b\u00051;\u0002\"B)\u0004\u0001\u0004\u0011\u0016A\u00029bO&tw\r\u0005\u0002T56\tAK\u0003\u0002V-\u0006\u0019A\r^8\u000b\u0005]C\u0016aA1qS*\u0011\u0011,D\u0001\u0007K:<\u0017N\\3\n\u0005m#&A\u0002)bO&tw\rC\u0003^\u0007\u0001\u0007a,A\u0003pe\u0012,'\u000f\u0005\u0002T?&\u0011\u0001\r\u0016\u0002\t\u001fJ$WM]5oO\")!m\u0001a\u0001\u000b\u0006IAo\\6f]:{G/Z\u0001\u0010GJ,\u0017\r^3Vg\u0016\u0014Hk\\6f]R!Q(\u001a4h\u0011\u0015!E\u00011\u0001F\u0011\u0015\u0011G\u00011\u0001F\u0011\u0015AG\u00011\u0001j\u0003))\u0007\u0010]5ss\u0012\u000bG/\u001a\t\u0003U>l\u0011a\u001b\u0006\u0003Y6\fA!\u001e;jY*\ta.\u0001\u0003kCZ\f\u0017B\u00019l\u0005\u0011!\u0015\r^3\u0002\u001f\u0011,G.\u001a;f+N,'\u000fV8lK:$2a\u001d<x!\t1B/\u0003\u0002v/\t!QK\\5u\u0011\u0015!U\u00011\u0001F\u0011\u0015AX\u00011\u0001z\u0003\u0011\u0019\u0017.\u00133\u0011\u0005ilX\"A>\u000b\u0005ql\u0017\u0001\u00027b]\u001eL!A`>\u0003\u000f%sG/Z4fe\"\u001a\u0001!!\u0001\u0011\t\u0005\r\u0011\u0011B\u0007\u0003\u0003\u000bQ1!a\u00020\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0003\u0017\t)AA\u0004TKJ4\u0018nY3")
public class UserTokenServiceImpl
implements UserTokenService {
    @Autowired
    private final XldUserTokenRespository xldUserTokenRepository;

    @Override
    public XldUserToken listUserTokenByUserName(String username, Paging paging, Ordering order, String tokenNote) {
        java.util.List<XldUserToken> tokenList = this.xldUserTokenRepository.listUserTokenByUserName(username, paging, order, tokenNote);
        if (tokenList.isEmpty()) {
            return new XldUserToken(username, (List<Tokens>)package$.MODULE$.List().empty());
        }
        return tokenList.get(0);
    }

    @Override
    public XldUserToken createUserToken(String username, String tokenNote, Date expiryDate) {
        Date date;
        String token = TokenGenerator$.MODULE$.generate("dpa_");
        if (expiryDate == null) {
            date = expiryDate;
        } else {
            LocalDateTime localExpiryDate = expiryDate.toInstant().atZone(ZoneId.of("UTC")).toLocalDate().atTime(LocalTime.MAX);
            date = Date.from(localExpiryDate.toInstant(ZoneOffset.MAX));
        }
        Date revisedExpiryDate = date;
        int ciId = this.xldUserTokenRepository.createUserToken(username, new Date(), revisedExpiryDate, tokenNote, TokenGenerator$.MODULE$.hash(token));
        Tokens userToken = Tokens$.MODULE$.apply(new Date(), null, revisedExpiryDate, tokenNote, token, Predef$.MODULE$.int2Integer(ciId));
        return new XldUserToken(username, (List<Tokens>)new .colon.colon((Object)userToken, (List)Nil$.MODULE$));
    }

    @Override
    public void deleteUserToken(String username, Integer ciId) {
        this.xldUserTokenRepository.deleteTokenByCiIdAndUsername(username, ciId);
    }

    public UserTokenServiceImpl(@Autowired XldUserTokenRespository xldUserTokenRepository) {
        this.xldUserTokenRepository = xldUserTokenRepository;
    }
}

