package com.xebialabs.deployit.security.service

import java.util.Date
import com.xebialabs.deployit.engine.api.dto.{Ordering, Paging}
import com.xebialabs.deployit.security.model.XldUserToken

trait UserTokenService {
  def createUserToken(username: String, tokenNote: String, expiryDate: Date): XldUserToken
  def listUserTokenByUserName(username: String, paging: Paging, order: Ordering, tokenNote: String): XldUserToken
  def deleteUserToken(username: String, ciId: Integer): Unit
  def findByUserToken(tokenHash: String): XldUserToken
  def updateLastUsedDate(ciId: Int, lastUsedDate: Date): Int
  def listTokensExpiringInDays(days: Int, paging: Paging): java.util.List[XldUserToken]
  def updateTokenExpiredNotified(ciId: Int, notifiedDate: Date, isNotified: Boolean): Unit
  def countUserTokens(username: String): Int
}
