package com.xebialabs.deployit.security.model

case class XldUserCredentials(id: java.lang.Long,
                              profileUsername: String,
                              label: String,
                              username: String,
                              email: String,
                              default: Boolean,
                              password: Option[String],
                              passphrase: Option[String],
                              privateKey: Option[String])

object XldUserCredentials {
  def apply(id: Long, profileUsername: String, label: String, username: String, email: String, default: Boolean, password: Option[String]): XldUserCredentials =
    XldUserCredentials(id, profileUsername, label, username, email, default, password, None, None)

  def apply(id: Long, profileUsername: String, label: String, username: String, email: String, default: Boolean, password: String): XldUserCredentials =
    apply(id, profileUsername, label, username, email, default, Option(password))

  def apply(id: Long, profileUsername: String, label: String, username: String, email: String, default: Boolean, passphrase: Option[String], privateKey: Option[String]): XldUserCredentials =
    XldUserCredentials(id, profileUsername, label, username, email, default, None, passphrase, privateKey)

  def apply(id: Long, profileUsername: String, label: String, username: String, email: String, default: Boolean, passphrase: String, privateKey: String): XldUserCredentials =
    apply(id, profileUsername, label, username, email, default, None, Option(passphrase), Option(privateKey))
}
