package com.xebialabs.deployit.security.model

import java.util.Date

case class Tokens(createdDate: Date,
                  lastUsedDate: Date,
                  expiryDate: Date,
                  tokenNote : String,
                  tokenHash: String,
                  ciId: Integer,
                  isNotified: Boolean,
                  emailSentDate: Date) {
  def isExpired(): Boolean = expiryDate != null && expiryDate.getTime < System.currentTimeMillis()
}

object Tokens {
  def apply(createdDate: Date,
            lastUsedDate: Date,
            expiryDate: Date,
            tokenNote : String,
            tokenHash: String,
            ciId: Integer): Tokens = {
    new Tokens(createdDate, lastUsedDate, expiryDate, tokenNote, tokenHash, ciId, false, null)
  }

  def apply(expiryDate: Date,
            tokenNote : String,
            ciId: Integer,
            isNotified: Boolean): Tokens = {
    new Tokens(null, null, expiryDate, tokenNote, null, ciId, isNotified, null)
  }

  def apply(createdDate: Date,
            lastUsedDate: Date,
            expiryDate: Date,
            tokenNote : String,
            tokenHash: String,
            ciId: Integer,
            isNotified: Boolean,
            emailSentDate: Date): Tokens = {
    new Tokens(createdDate, lastUsedDate, expiryDate, tokenNote, tokenHash, ciId, isNotified, emailSentDate)
  }
  def apply(createdDate: Date, expiryDate: Date, tokenNote: String, tokenHash: String): Tokens = {
    new Tokens(createdDate, null, expiryDate, tokenNote, tokenHash, null, false, null)
  }
}

case class XldUserToken(username: String, tokens: List[Tokens])
object XldUserToken {
  def apply(username: String,
            tokens: Tokens*): XldUserToken = XldUserToken(username, tokens.toList)
  def apply(username: String,
           ): XldUserToken = XldUserToken(username,List.empty[Tokens])
}
