package com.xebialabs.deployit.security.service.impl

import com.xebialabs.deployit.security.service.UserStatsService
import com.xebialabs.deployit.security.repository.XldUserProfileRepository
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service

@Service
class UserStatsServiceImpl (@Autowired xldUserProfileRepository: XldUserProfileRepository) extends UserStatsService {

  override def prepareUserStatsByUserProfile: Map[String, Int] = {
    val usersEnabled = xldUserProfileRepository.countUserWithLoginAllowed();
    val usersEnabledGroupByType = xldUserProfileRepository.countUsersWithLoginAllowedAndGroupByType()
    val allUsers = xldUserProfileRepository.countAllUsers()
    Map(
      "allUsers" -> allUsers,
      "usersEnabled" -> usersEnabled,
      "usersEnabledWithInternal" -> usersEnabledGroupByType.getOrElse("internal", 0),
      "usersEnabledWithExternal" -> usersEnabledGroupByType.getOrElse("external", 0),
    )
  }
}
