package com.xebialabs.deployit.task.archive.sql

import com.xebialabs.deployit.core.sql.SchemaInfo
import com.xebialabs.deployit.task.archive.{ControlTaskMessage, DefaultTaskMessage, DeploymentTaskMessage, TaskMessage}
import org.springframework.jdbc.core.JdbcTemplate

object TaskArchiver {
  def apply(taskMessage: TaskMessage)(implicit schemaInfo: SchemaInfo): TaskArchiver = taskMessage match {
    case deploymentTaskMessage: DeploymentTaskMessage => new DeploymentTaskArchiver(deploymentTaskMessage)
    case controlTaskMessage: ControlTaskMessage => new ControlTaskArchiver(controlTaskMessage)
    case defaultTaskMessage: DefaultTaskMessage => new DefaultTaskArchiver(defaultTaskMessage)
  }
}

trait TaskArchiver {
  def store(jdbcTemplate: JdbcTemplate): Unit
}
