package com.xebialabs.deployit.task.archive.sql

import com.xebialabs.deployit.core.sql.{Queries, SchemaInfo, toCalendar}
import com.xebialabs.deployit.task.archive.DeploymentTaskMessage
import org.springframework.jdbc.core.JdbcTemplate

class DeploymentTaskArchiver(deploymentTaskMessage: DeploymentTaskMessage)(implicit override val schemaInfo: SchemaInfo)
  extends DefaultTaskArchiver(deploymentTaskMessage)
    with DeploymentTaskArchiverQueries {

  override def store(jdbcTemplate: JdbcTemplate): Unit = {
    archiveDetails(jdbcTemplate)
    jdbcTemplate.update(
      INSERT_DEPLOYMENT,
      deploymentTaskMessage.taskId,
      deploymentTaskMessage.mainApplication,
      deploymentTaskMessage.packages,
      deploymentTaskMessage.environmentId,
      deploymentTaskMessage.environmentInternalId.asInstanceOf[Object],
      deploymentTaskMessage.environmentSecuredId.map(_.asInstanceOf[Object]).orNull,
      deploymentTaskMessage.environmentDirectoryReference,
      deploymentTaskMessage.taskType,
      deploymentTaskMessage.owner,
      deploymentTaskMessage.state,
      deploymentTaskMessage.failureCount,
      toCalendar(deploymentTaskMessage.startDate),
      toCalendar(deploymentTaskMessage.endDate),
      deploymentTaskMessage.duration.asInstanceOf[Object],
      deploymentTaskMessage.isRollback,
      deploymentTaskMessage.archiveDetails.workerName.orNull
    )

    deploymentTaskMessage.applications.foreach(application =>
      jdbcTemplate.update(
        INSERT_APPLICATION,
        deploymentTaskMessage.taskId,
        application.applicationName,
        application.applicationInternalId.asInstanceOf[Object],
        application.applicationSecuredId.map(_.asInstanceOf[Object]).orNull,
        application.applicationDirectoryReference
      )
    )
  }
}

object DeploymentTaskArchiver {
  val kind = "DEPLOYMENT"
}

trait DeploymentTaskArchiverQueries extends Queries {
  lazy val INSERT_DEPLOYMENT: String = {
    import com.xebialabs.deployit.task.archive.sql.schema.ArchivedDeploymentTasks._
    sqlb"insert into $tableName ($task_id, $main_application, $packages, $environment, $environment_internal_id, $environment_secured_ci, $environment_dir_ref, " +
      sqlb"$task_type, $owner, $status, $failure_count, $start_date, $end_date, $duration, $rolled_back, $worker_name) " +
      sqlb"values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"
  }

  lazy val INSERT_APPLICATION: String = {
    import com.xebialabs.deployit.task.archive.sql.schema.ArchivedDeploymentTasks.Applications._
    sqlb"insert into $tableName ($task_id, $application, $application_internal_id, $application_secured_ci, $application_dir_ref) values (?, ?, ?, ?, ?)"
  }
}
