package com.xebialabs.deployit.task.archive.sql.schema

import com.xebialabs.deployit.core.sql.{ColumnName, TableName}

trait ArchivedTasksSharedKeys {
  val task_id = ColumnName("task_id")
}

object ArchivedTasks extends ArchivedTasksSharedKeys{

  val tableName = TableName("XLD_ARCHIVED_TASKS")

  val task_kind = ColumnName("task_kind")
  val task_details = ColumnName("task_details")
  val worker_name = ColumnName("worker_name")

}

trait ArchivedTasksCommon extends ArchivedTasksSharedKeys {
  val start_date = ColumnName("start_date")
}

object ArchivedTasksShared extends ArchivedTasksCommon

object ArchivedDeploymentTasks extends ArchivedTasksCommon {
  val tableName = TableName("XLD_ARCHIVED_DEPLOYMENT_TASKS")

  val main_application = ColumnName("main_application")
  val packages = ColumnName("packages")
  val environment = ColumnName("environment")
  val environment_internal_id = ColumnName("environment_internal_id")
  val environment_secured_ci = ColumnName("environment_secured_ci")
  val environment_dir_ref = ColumnName("environment_dir_ref")
  val task_type = ColumnName("task_type")
  val owner = ColumnName("owner")
  val status = ColumnName("status")
  val failure_count = ColumnName("failure_count")
  val end_date = ColumnName("end_date")
  val duration = ColumnName("duration")
  val rolled_back = ColumnName("rolled_back")
  val worker_name = ColumnName("worker_name")

  object Applications extends ArchivedTasksSharedKeys {
    val tableName = TableName("XLD_ARCHIVED_DT_APPLICATIONS")

    val application = ColumnName("application")
    val application_internal_id = ColumnName("application_internal_id")
    val application_secured_ci = ColumnName("application_secured_ci")
    val application_dir_ref = ColumnName("application_dir_ref")
  }
}

object ArchivedControlTasks extends ArchivedTasksCommon {
  val tableName = TableName("XLD_ARCHIVED_CONTROL_TASKS")

  val control_task_name = ColumnName("control_task_name")
  val target_ci = ColumnName("target_ci")
  val target_internal_id = ColumnName("target_internal_id")
  val target_secured_ci = ColumnName("target_secured_ci")
  val target_dir_ref = ColumnName("target_dir_ref")
  val owner = ColumnName("owner")
  val description = ColumnName("description")
  val status = ColumnName("status")
  val failure_count = ColumnName("failure_count")
  val end_date = ColumnName("end_date")
  val worker_name = ColumnName("worker_name")
}

object ArchivedUnknownTasks extends ArchivedTasksCommon {
  val tableName = TableName("XLD_ARCHIVED_UNKNOWN_TASKS")
}


