  package com.xebialabs.deployit.task.archive.sql

import java.io.{Reader, StringReader}
import java.util

import com.fasterxml.jackson.core.filter.{FilteringParserDelegate, JsonPointerBasedFilter, TokenFilter}
import com.xebialabs.deployit.engine.api.execution.BlockState
import com.xebialabs.deployit.engine.tasker.{Block, BlockPath}
import com.xebialabs.deployit.task.archive._
import org.apache.commons.io.IOUtils

trait DefaultTaskReader extends TaskReader {
  def reader: Reader

  override def fully:ArchivedTask = patchPhaseContainer(unfiltered)

  override def withoutSteps:ArchivedTask = patchPhaseContainer(ArchiveObjectMapper.mapper.readerFor(classOf[ArchivedTask]).readValue(filter(NoStepsFilter, true, true)))

  override def withoutBlocks:ArchivedTask = patchPhaseContainer(ArchiveObjectMapper.mapper.readerFor(classOf[ArchivedTask]).readValue(filter(NoBlocksFilter, true, true)))

  //TODO: This can be much improved, by not fully reading the task into memory.
  override def block(blockId: String): BlockState = blockId match {
    case "FAKE" =>
      // Task for before there were blocks: read steps from task into fake block.
      val steps = fully.getSteps
      val result = new ArchivedStepBlock()
      result.setSteps(steps)
      result
    case _ => unfiltered.getBlock.asInstanceOf[Block].getBlock(BlockPath(blockId).tail).orNull
  }

  override def metadata: util.Map[String, String] = ArchiveObjectMapper.mapper.readerFor(classOf[util.Map[String, String]]).readValue(filter(MetadataFilter, false, false))

  private def unfiltered: ArchivedTask = ArchiveObjectMapper.mapper.readerFor(classOf[ArchivedTask]).readValue(reader)

  private def filter(filter: TokenFilter, includePath: Boolean, allowMultiple: Boolean) =
    new FilteringParserDelegate(ArchiveObjectMapper.mapper.getFactory.createParser(reader), filter, includePath, allowMultiple)
}

class StreamingTaskReader(override val reader: Reader) extends DefaultTaskReader

class CachingTaskReader(input: Reader) extends DefaultTaskReader {
  private val string = IOUtils.toString(input)
  override def reader: Reader = new StringReader(string)
}

object NoStepsFilter extends TokenFilter {
  override def includeProperty(name: String): TokenFilter = name match {
    case "phases" => this
    case "block" => this
    case "blocks" => this
    case "steps" => null
    case _ => TokenFilter.INCLUDE_ALL
  }
}

object NoBlocksFilter extends TokenFilter {
  override def includeProperty(name: String): TokenFilter = name match {
    case "phases" => null
    case "block" => null
    case "blocks" => null
    case "steps" => null
    case _ => TokenFilter.INCLUDE_ALL
  }
}

// see TODO above, attempt to read only block from JSON.
//class BlockFilter(str: String) extends TokenFilter {
//  override def includeProperty(name: String): TokenFilter = name match {
//    case "phases" => this
//    case "block" => this
//    case "blocks" => this
//    case "id" => new IdFilter(str)
//    case _ => null
//  }
//}
//
//class IdFilter(str: String) extends TokenFilter {
//  override def includeValue(p: JsonParser): Boolean = p.getValueAsString == str
//}

object MetadataFilter extends JsonPointerBasedFilter("/metadata")

