package ai.digital.deploy.engine.tasker.service.impl

import ai.digital.deploy.engine.tasker.service.TaskStatusService
import com.xebialabs.deployit.engine.api.dto.ActiveTaskStatus
import com.xebialabs.deployit.engine.tasker.TaskId
import com.xebialabs.deployit.engine.tasker.repository.ActiveTaskStatusRepository
import com.xebialabs.deployit.exception.NotFoundException
import com.xebialabs.deployit.local.message.MessageService
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service

@Service
class TaskStatusServiceImpl(@Autowired activeTaskStatusRepository: ActiveTaskStatusRepository,
                            @Autowired deployMessageService: MessageService)
  extends TaskStatusService {
  def findOne(taskId: TaskId, path: String): ActiveTaskStatus = {
    activeTaskStatusRepository.findOne(taskId, path)
      .getOrElse(throw new NotFoundException(deployMessageService.getMessage("task.status.notfound", taskId, path)))
  }

  def createOrUpdate(taskId: String, path: String, status: String): Unit = {
    activeTaskStatusRepository.findOne(taskId, path) match {
      case Some(_) => activeTaskStatusRepository.update(taskId, path, status)
      case None => activeTaskStatusRepository.create(taskId, path, status)
    }
  }

  def delete(taskId: String): Unit = {
    activeTaskStatusRepository.delete(taskId)
  }

  def findAll(taskId: TaskId): List[ActiveTaskStatus] = {
    activeTaskStatusRepository.findAll(taskId)
  }
}
