package ai.digital.deploy.engine.tasker.service.impl

import ai.digital.deploy.engine.tasker.service.TaskPathStatusService
import com.xebialabs.deployit.core.events.TaskPathStatusEvent
import com.xebialabs.deployit.engine.api.dto.TaskPathStatus
import com.xebialabs.deployit.engine.tasker.TaskId
import com.xebialabs.deployit.engine.tasker.repository.TaskPathStatusRepository
import com.xebialabs.deployit.exception.NotFoundException
import com.xebialabs.deployit.local.message.MessageService
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service

@Service
class TaskPathStatusServiceImpl(@Autowired taskPathStatusRepository: TaskPathStatusRepository,
                                @Autowired deployMessageService: MessageService)
  extends TaskPathStatusService {

  override def batchCreate(taskPathStatuses: Seq[TaskPathStatusEvent], updateTime: Long): Unit =
    taskPathStatusRepository.batchCreate(taskPathStatuses, updateTime)

  override def create(taskId: TaskId, path: String, status: String, updateTime: Long): Unit =
    taskPathStatusRepository.create(taskId, path, status, updateTime)

  override def delete(taskId: TaskId): Unit =
    taskPathStatusRepository.delete(taskId)

  override def findOne(taskId: TaskId, path: String): TaskPathStatus =
    taskPathStatusRepository.findOne(taskId, path)
      .getOrElse(throw new NotFoundException(deployMessageService.getMessage("task.status.notfound", taskId, path)))

}
