package ai.digital.deploy.engine.tasker.service.impl

import ai.digital.deploy.engine.tasker.service.TaskStepLogService
import com.xebialabs.deployit.core.events.TaskStepLogEvent
import com.xebialabs.deployit.engine.api.dto.TaskStepLog
import com.xebialabs.deployit.engine.tasker.TaskId
import com.xebialabs.deployit.engine.tasker.repository.TaskStepLogRepository
import com.xebialabs.deployit.exception.NotFoundException
import com.xebialabs.deployit.local.message.MessageService
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service

@Service
class TaskStepLogServiceImpl(@Autowired taskStepLogRepository: TaskStepLogRepository,
                             @Autowired deployMessageService: MessageService)
  extends TaskStepLogService {

  override def batchCreate(taskStepLogs: Seq[TaskStepLogEvent], updateTime: Long): Unit =
    taskStepLogRepository.batchCreate(taskStepLogs, updateTime)

  override def findOne(taskId: TaskId, stepPath: String): TaskStepLog =
    taskStepLogRepository.findOne(taskId, stepPath)
      .getOrElse(
        throw new NotFoundException(deployMessageService.getMessage("task.step.log.notfound", taskId, stepPath)))

  override def create(taskStepLog: TaskStepLogEvent, updateTime: Long): Unit =
    taskStepLogRepository.create(taskStepLog, updateTime)

  override def delete(taskId: TaskId): Unit =
    taskStepLogRepository.delete(taskId)

  override def findAll(taskId: TaskId): List[TaskStepLog] =
    taskStepLogRepository.findAll(taskId)

}
