/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.settings.impl;

import java.io.Serializable;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.core.settings.Mergeable;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.DeletionPolicy;
import org.apache.activemq.artemis.core.settings.impl.SlowConsumerPolicy;
import org.apache.activemq.artemis.core.settings.impl.SlowConsumerThresholdMeasurementUnit;
import org.apache.activemq.artemis.utils.BufferHelper;

public class AddressSettings
implements Mergeable<AddressSettings>,
Serializable,
EncodingSupport {
    private static final long serialVersionUID = 1607502280582336366L;
    public static final long DEFAULT_MAX_SIZE_BYTES = -1L;
    public static final AddressFullMessagePolicy DEFAULT_ADDRESS_FULL_MESSAGE_POLICY = AddressFullMessagePolicy.PAGE;
    public static final int DEFAULT_PAGE_SIZE = 0xA00000;
    public static final int DEFAULT_MAX_DELIVERY_ATTEMPTS = 10;
    public static final int DEFAULT_PAGE_MAX_CACHE = 5;
    public static final int DEFAULT_MESSAGE_COUNTER_HISTORY_DAY_LIMIT = 0;
    public static final long DEFAULT_REDELIVER_DELAY = 0L;
    public static final double DEFAULT_REDELIVER_MULTIPLIER = 1.0;
    public static final double DEFAULT_REDELIVER_COLLISION_AVOIDANCE_FACTOR = 0.0;
    public static final boolean DEFAULT_LAST_VALUE_QUEUE = false;
    @Deprecated
    public static final boolean DEFAULT_AUTO_CREATE_JMS_QUEUES = true;
    @Deprecated
    public static final boolean DEFAULT_AUTO_DELETE_JMS_QUEUES = true;
    @Deprecated
    public static final boolean DEFAULT_AUTO_CREATE_TOPICS = true;
    @Deprecated
    public static final boolean DEFAULT_AUTO_DELETE_TOPICS = true;
    public static final boolean DEFAULT_AUTO_CREATE_QUEUES = true;
    public static final boolean DEFAULT_AUTO_DELETE_QUEUES = true;
    public static final boolean DEFAULT_AUTO_DELETE_CREATED_QUEUES = false;
    public static final long DEFAULT_AUTO_DELETE_QUEUES_DELAY = 0L;
    public static final long DEFAULT_AUTO_DELETE_QUEUES_MESSAGE_COUNT = 0L;
    public static final DeletionPolicy DEFAULT_CONFIG_DELETE_QUEUES = DeletionPolicy.OFF;
    public static final boolean DEFAULT_AUTO_CREATE_ADDRESSES = true;
    public static final boolean DEFAULT_AUTO_DELETE_ADDRESSES = true;
    public static final long DEFAULT_AUTO_DELETE_ADDRESSES_DELAY = 0L;
    public static final DeletionPolicy DEFAULT_CONFIG_DELETE_ADDRESSES = DeletionPolicy.OFF;
    public static final DeletionPolicy DEFAULT_CONFIG_DELETE_DIVERTS = DeletionPolicy.OFF;
    public static final long DEFAULT_REDISTRIBUTION_DELAY = -1L;
    public static final boolean DEFAULT_AUTO_CREATE_EXPIRY_RESOURCES = false;
    public static final SimpleString DEFAULT_EXPIRY_QUEUE_PREFIX = SimpleString.toSimpleString((String)"EXP.");
    public static final SimpleString DEFAULT_EXPIRY_QUEUE_SUFFIX = SimpleString.toSimpleString((String)"");
    public static final long DEFAULT_EXPIRY_DELAY = -1L;
    public static final long DEFAULT_MIN_EXPIRY_DELAY = -1L;
    public static final long DEFAULT_MAX_EXPIRY_DELAY = -1L;
    public static final boolean DEFAULT_SEND_TO_DLA_ON_NO_ROUTE = false;
    public static final long DEFAULT_SLOW_CONSUMER_THRESHOLD = -1L;
    public static final long DEFAULT_SLOW_CONSUMER_CHECK_PERIOD = 5L;
    public static final int MANAGEMENT_BROWSE_PAGE_SIZE = 200;
    public static final SlowConsumerPolicy DEFAULT_SLOW_CONSUMER_POLICY = SlowConsumerPolicy.NOTIFY;
    public static final int DEFAULT_QUEUE_PREFETCH = 1000;
    public static final long DEFAULT_ADDRESS_REJECT_THRESHOLD = -1L;
    public static final boolean DEFAULT_AUTO_CREATE_DEAD_LETTER_RESOURCES = false;
    public static final SimpleString DEFAULT_DEAD_LETTER_QUEUE_PREFIX = SimpleString.toSimpleString((String)"DLQ.");
    public static final SimpleString DEFAULT_DEAD_LETTER_QUEUE_SUFFIX = SimpleString.toSimpleString((String)"");
    public static final boolean DEFAULT_ENABLE_METRICS = true;
    public static final int MANAGEMENT_MESSAGE_ATTRIBUTE_SIZE_LIMIT = 256;
    public static final SlowConsumerThresholdMeasurementUnit DEFAULT_SLOW_CONSUMER_THRESHOLD_MEASUREMENT_UNIT = SlowConsumerThresholdMeasurementUnit.MESSAGES_PER_SECOND;
    public static final boolean DEFAULT_ENABLE_INGRESS_TIMESTAMP = false;
    private AddressFullMessagePolicy addressFullMessagePolicy = null;
    private Long maxSizeBytes = null;
    private Integer pageSizeBytes = null;
    private Integer pageMaxCache = null;
    private Boolean dropMessagesWhenFull = null;
    private Integer maxDeliveryAttempts = null;
    private Integer messageCounterHistoryDayLimit = null;
    private Long redeliveryDelay = null;
    private Double redeliveryMultiplier = null;
    private Double redeliveryCollisionAvoidanceFactor = null;
    private Long maxRedeliveryDelay = null;
    private SimpleString deadLetterAddress = null;
    private SimpleString expiryAddress = null;
    private Long expiryDelay = -1L;
    private Long minExpiryDelay = -1L;
    private Long maxExpiryDelay = -1L;
    private Boolean defaultLastValueQueue = null;
    private SimpleString defaultLastValueKey = null;
    private Boolean defaultNonDestructive = null;
    private Boolean defaultExclusiveQueue = null;
    private Boolean defaultGroupRebalance = null;
    private Boolean defaultGroupRebalancePauseDispatch = null;
    private Integer defaultGroupBuckets = null;
    private SimpleString defaultGroupFirstKey = null;
    private Long redistributionDelay = null;
    private Boolean sendToDLAOnNoRoute = null;
    private Long slowConsumerThreshold = null;
    private SlowConsumerThresholdMeasurementUnit slowConsumerThresholdMeasurementUnit = DEFAULT_SLOW_CONSUMER_THRESHOLD_MEASUREMENT_UNIT;
    private Long slowConsumerCheckPeriod = null;
    private SlowConsumerPolicy slowConsumerPolicy = null;
    @Deprecated
    private Boolean autoCreateJmsQueues = null;
    @Deprecated
    private Boolean autoDeleteJmsQueues = null;
    @Deprecated
    private Boolean autoCreateJmsTopics = null;
    @Deprecated
    private Boolean autoDeleteJmsTopics = null;
    private Boolean autoCreateQueues = null;
    private Boolean autoDeleteQueues = null;
    private Boolean autoDeleteCreatedQueues = null;
    private Long autoDeleteQueuesDelay = null;
    private Long autoDeleteQueuesMessageCount = null;
    private Long defaultRingSize = null;
    private Long retroactiveMessageCount = null;
    private DeletionPolicy configDeleteQueues = null;
    private Boolean autoCreateAddresses = null;
    private Boolean autoDeleteAddresses = null;
    private Long autoDeleteAddressesDelay = null;
    private DeletionPolicy configDeleteAddresses = null;
    private DeletionPolicy configDeleteDiverts = null;
    private Integer managementBrowsePageSize = 200;
    private Long maxSizeBytesRejectThreshold = null;
    private Integer defaultMaxConsumers = null;
    private Boolean defaultPurgeOnNoConsumers = null;
    private Integer defaultConsumersBeforeDispatch = null;
    private Long defaultDelayBeforeDispatch = null;
    private RoutingType defaultQueueRoutingType = null;
    private RoutingType defaultAddressRoutingType = null;
    private Integer defaultConsumerWindowSize = null;
    private Boolean autoCreateDeadLetterResources = null;
    private SimpleString deadLetterQueuePrefix = null;
    private SimpleString deadLetterQueueSuffix = null;
    private Boolean autoCreateExpiryResources = null;
    private SimpleString expiryQueuePrefix = null;
    private SimpleString expiryQueueSuffix = null;
    private Boolean enableMetrics = null;
    private Integer managementMessageAttributeSizeLimit = null;
    private Boolean enableIngressTimestamp = null;
    private transient Integer queuePrefetch = null;

    public AddressSettings(AddressSettings other) {
        this.addressFullMessagePolicy = other.addressFullMessagePolicy;
        this.maxSizeBytes = other.maxSizeBytes;
        this.pageSizeBytes = other.pageSizeBytes;
        this.pageMaxCache = other.pageMaxCache;
        this.dropMessagesWhenFull = other.dropMessagesWhenFull;
        this.maxDeliveryAttempts = other.maxDeliveryAttempts;
        this.messageCounterHistoryDayLimit = other.messageCounterHistoryDayLimit;
        this.redeliveryDelay = other.redeliveryDelay;
        this.redeliveryMultiplier = other.redeliveryMultiplier;
        this.redeliveryCollisionAvoidanceFactor = other.redeliveryCollisionAvoidanceFactor;
        this.maxRedeliveryDelay = other.maxRedeliveryDelay;
        this.deadLetterAddress = other.deadLetterAddress;
        this.autoCreateDeadLetterResources = other.autoCreateDeadLetterResources;
        this.deadLetterQueuePrefix = other.deadLetterQueuePrefix;
        this.deadLetterQueueSuffix = other.deadLetterQueueSuffix;
        this.expiryAddress = other.expiryAddress;
        this.autoCreateExpiryResources = other.autoCreateExpiryResources;
        this.expiryQueuePrefix = other.expiryQueuePrefix;
        this.expiryQueueSuffix = other.expiryQueueSuffix;
        this.expiryDelay = other.expiryDelay;
        this.minExpiryDelay = other.minExpiryDelay;
        this.maxExpiryDelay = other.maxExpiryDelay;
        this.defaultLastValueQueue = other.defaultLastValueQueue;
        this.defaultLastValueKey = other.defaultLastValueKey;
        this.defaultNonDestructive = other.defaultNonDestructive;
        this.defaultExclusiveQueue = other.defaultExclusiveQueue;
        this.redistributionDelay = other.redistributionDelay;
        this.sendToDLAOnNoRoute = other.sendToDLAOnNoRoute;
        this.slowConsumerThreshold = other.slowConsumerThreshold;
        this.slowConsumerCheckPeriod = other.slowConsumerCheckPeriod;
        this.slowConsumerPolicy = other.slowConsumerPolicy;
        this.autoCreateJmsQueues = other.autoCreateJmsQueues;
        this.autoDeleteJmsQueues = other.autoDeleteJmsQueues;
        this.autoCreateJmsTopics = other.autoCreateJmsTopics;
        this.autoDeleteJmsTopics = other.autoDeleteJmsTopics;
        this.autoCreateQueues = other.autoCreateQueues;
        this.autoDeleteQueues = other.autoDeleteQueues;
        this.autoDeleteCreatedQueues = other.autoDeleteCreatedQueues;
        this.autoDeleteQueuesDelay = other.autoDeleteQueuesDelay;
        this.configDeleteQueues = other.configDeleteQueues;
        this.autoCreateAddresses = other.autoCreateAddresses;
        this.autoDeleteAddresses = other.autoDeleteAddresses;
        this.autoDeleteAddressesDelay = other.autoDeleteAddressesDelay;
        this.configDeleteAddresses = other.configDeleteAddresses;
        this.managementBrowsePageSize = other.managementBrowsePageSize;
        this.queuePrefetch = other.queuePrefetch;
        this.maxSizeBytesRejectThreshold = other.maxSizeBytesRejectThreshold;
        this.defaultMaxConsumers = other.defaultMaxConsumers;
        this.defaultPurgeOnNoConsumers = other.defaultPurgeOnNoConsumers;
        this.defaultConsumersBeforeDispatch = other.defaultConsumersBeforeDispatch;
        this.defaultDelayBeforeDispatch = other.defaultDelayBeforeDispatch;
        this.defaultQueueRoutingType = other.defaultQueueRoutingType;
        this.defaultAddressRoutingType = other.defaultAddressRoutingType;
        this.defaultConsumerWindowSize = other.defaultConsumerWindowSize;
        this.defaultGroupRebalance = other.defaultGroupRebalance;
        this.defaultGroupRebalancePauseDispatch = other.defaultGroupRebalancePauseDispatch;
        this.defaultGroupBuckets = other.defaultGroupBuckets;
        this.defaultGroupFirstKey = other.defaultGroupFirstKey;
        this.defaultRingSize = other.defaultRingSize;
        this.enableMetrics = other.enableMetrics;
        this.managementMessageAttributeSizeLimit = other.managementMessageAttributeSizeLimit;
        this.slowConsumerThresholdMeasurementUnit = other.slowConsumerThresholdMeasurementUnit;
        this.enableIngressTimestamp = other.enableIngressTimestamp;
    }

    public AddressSettings() {
    }

    @Deprecated
    public boolean isAutoCreateJmsQueues() {
        return this.autoCreateJmsQueues != null ? this.autoCreateJmsQueues : true;
    }

    @Deprecated
    public AddressSettings setAutoCreateJmsQueues(boolean autoCreateJmsQueues) {
        this.autoCreateJmsQueues = autoCreateJmsQueues;
        return this;
    }

    @Deprecated
    public boolean isAutoDeleteJmsQueues() {
        return this.autoDeleteJmsQueues != null ? this.autoDeleteJmsQueues : true;
    }

    @Deprecated
    public AddressSettings setAutoDeleteJmsQueues(boolean autoDeleteJmsQueues) {
        this.autoDeleteJmsQueues = autoDeleteJmsQueues;
        return this;
    }

    @Deprecated
    public boolean isAutoCreateJmsTopics() {
        return this.autoCreateJmsTopics != null ? this.autoCreateJmsTopics : true;
    }

    @Deprecated
    public AddressSettings setAutoCreateJmsTopics(boolean autoCreateJmsTopics) {
        this.autoCreateJmsTopics = autoCreateJmsTopics;
        return this;
    }

    @Deprecated
    public boolean isAutoDeleteJmsTopics() {
        return this.autoDeleteJmsTopics != null ? this.autoDeleteJmsTopics : true;
    }

    @Deprecated
    public AddressSettings setAutoDeleteJmsTopics(boolean autoDeleteJmsTopics) {
        this.autoDeleteJmsTopics = autoDeleteJmsTopics;
        return this;
    }

    public boolean isAutoCreateQueues() {
        return this.autoCreateQueues != null ? this.autoCreateQueues : true;
    }

    public AddressSettings setAutoCreateQueues(Boolean autoCreateQueues) {
        this.autoCreateQueues = autoCreateQueues;
        return this;
    }

    public boolean isAutoDeleteQueues() {
        return this.autoDeleteQueues != null ? this.autoDeleteQueues : true;
    }

    public AddressSettings setAutoDeleteQueues(Boolean autoDeleteQueues) {
        this.autoDeleteQueues = autoDeleteQueues;
        return this;
    }

    public AddressSettings setAutoDeleteCreatedQueues(Boolean autoDeleteCreatedQueues) {
        this.autoDeleteCreatedQueues = autoDeleteCreatedQueues;
        return this;
    }

    public boolean isAutoDeleteCreatedQueues() {
        return this.autoDeleteCreatedQueues != null ? this.autoDeleteCreatedQueues : false;
    }

    public long getAutoDeleteQueuesDelay() {
        return this.autoDeleteQueuesDelay != null ? this.autoDeleteQueuesDelay : 0L;
    }

    public AddressSettings setAutoDeleteQueuesDelay(long autoDeleteQueuesDelay) {
        this.autoDeleteQueuesDelay = autoDeleteQueuesDelay;
        return this;
    }

    public long getAutoDeleteQueuesMessageCount() {
        return this.autoDeleteQueuesMessageCount != null ? this.autoDeleteQueuesMessageCount : 0L;
    }

    public AddressSettings setAutoDeleteQueuesMessageCount(long autoDeleteQueuesMessageCount) {
        this.autoDeleteQueuesMessageCount = autoDeleteQueuesMessageCount;
        return this;
    }

    public DeletionPolicy getConfigDeleteQueues() {
        return this.configDeleteQueues != null ? this.configDeleteQueues : DEFAULT_CONFIG_DELETE_QUEUES;
    }

    public AddressSettings setConfigDeleteQueues(DeletionPolicy configDeleteQueues) {
        this.configDeleteQueues = configDeleteQueues;
        return this;
    }

    public boolean isAutoCreateAddresses() {
        return this.autoCreateAddresses != null ? this.autoCreateAddresses : true;
    }

    public AddressSettings setAutoCreateAddresses(Boolean autoCreateAddresses) {
        this.autoCreateAddresses = autoCreateAddresses;
        return this;
    }

    public boolean isAutoDeleteAddresses() {
        return this.autoDeleteAddresses != null ? this.autoDeleteAddresses : true;
    }

    public AddressSettings setAutoDeleteAddresses(Boolean autoDeleteAddresses) {
        this.autoDeleteAddresses = autoDeleteAddresses;
        return this;
    }

    public long getAutoDeleteAddressesDelay() {
        return this.autoDeleteAddressesDelay != null ? this.autoDeleteAddressesDelay : 0L;
    }

    public AddressSettings setAutoDeleteAddressesDelay(long autoDeleteAddressesDelay) {
        this.autoDeleteAddressesDelay = autoDeleteAddressesDelay;
        return this;
    }

    public DeletionPolicy getConfigDeleteAddresses() {
        return this.configDeleteAddresses != null ? this.configDeleteAddresses : DEFAULT_CONFIG_DELETE_ADDRESSES;
    }

    public AddressSettings setConfigDeleteAddresses(DeletionPolicy configDeleteAddresses) {
        this.configDeleteAddresses = configDeleteAddresses;
        return this;
    }

    public AddressSettings setConfigDeleteDiverts(DeletionPolicy configDeleteDiverts) {
        this.configDeleteDiverts = configDeleteDiverts;
        return this;
    }

    public DeletionPolicy getConfigDeleteDiverts() {
        return this.configDeleteDiverts != null ? this.configDeleteDiverts : DEFAULT_CONFIG_DELETE_DIVERTS;
    }

    public int getDefaultMaxConsumers() {
        return this.defaultMaxConsumers != null ? this.defaultMaxConsumers : ActiveMQDefaultConfiguration.getDefaultMaxQueueConsumers();
    }

    public AddressSettings setDefaultMaxConsumers(Integer defaultMaxConsumers) {
        this.defaultMaxConsumers = defaultMaxConsumers;
        return this;
    }

    public int getDefaultConsumersBeforeDispatch() {
        return this.defaultConsumersBeforeDispatch != null ? this.defaultConsumersBeforeDispatch : ActiveMQDefaultConfiguration.getDefaultConsumersBeforeDispatch();
    }

    public AddressSettings setDefaultConsumersBeforeDispatch(Integer defaultConsumersBeforeDispatch) {
        this.defaultConsumersBeforeDispatch = defaultConsumersBeforeDispatch;
        return this;
    }

    public long getDefaultDelayBeforeDispatch() {
        return this.defaultDelayBeforeDispatch != null ? this.defaultDelayBeforeDispatch : ActiveMQDefaultConfiguration.getDefaultDelayBeforeDispatch();
    }

    public AddressSettings setDefaultDelayBeforeDispatch(Long defaultDelayBeforeDispatch) {
        this.defaultDelayBeforeDispatch = defaultDelayBeforeDispatch;
        return this;
    }

    public boolean isDefaultPurgeOnNoConsumers() {
        return this.defaultPurgeOnNoConsumers != null ? this.defaultPurgeOnNoConsumers : ActiveMQDefaultConfiguration.getDefaultPurgeOnNoConsumers();
    }

    public AddressSettings setDefaultPurgeOnNoConsumers(Boolean defaultPurgeOnNoConsumers) {
        this.defaultPurgeOnNoConsumers = defaultPurgeOnNoConsumers;
        return this;
    }

    public RoutingType getDefaultQueueRoutingType() {
        return this.defaultQueueRoutingType != null ? this.defaultQueueRoutingType : ActiveMQDefaultConfiguration.getDefaultRoutingType();
    }

    public AddressSettings setDefaultQueueRoutingType(RoutingType defaultQueueRoutingType) {
        this.defaultQueueRoutingType = defaultQueueRoutingType;
        return this;
    }

    public RoutingType getDefaultAddressRoutingType() {
        return this.defaultAddressRoutingType != null ? this.defaultAddressRoutingType : ActiveMQDefaultConfiguration.getDefaultRoutingType();
    }

    public AddressSettings setDefaultAddressRoutingType(RoutingType defaultAddressRoutingType) {
        this.defaultAddressRoutingType = defaultAddressRoutingType;
        return this;
    }

    public boolean isDefaultLastValueQueue() {
        return this.defaultLastValueQueue != null ? this.defaultLastValueQueue : false;
    }

    public AddressSettings setDefaultLastValueQueue(boolean defaultLastValueQueue) {
        this.defaultLastValueQueue = defaultLastValueQueue;
        return this;
    }

    public SimpleString getDefaultLastValueKey() {
        return this.defaultLastValueKey != null ? this.defaultLastValueKey : ActiveMQDefaultConfiguration.getDefaultLastValueKey();
    }

    public AddressSettings setDefaultLastValueKey(SimpleString defaultLastValueKey) {
        this.defaultLastValueKey = defaultLastValueKey;
        return this;
    }

    public boolean isDefaultNonDestructive() {
        return this.defaultNonDestructive != null ? this.defaultNonDestructive : ActiveMQDefaultConfiguration.getDefaultNonDestructive();
    }

    public AddressSettings setDefaultNonDestructive(boolean defaultNonDestructive) {
        this.defaultNonDestructive = defaultNonDestructive;
        return this;
    }

    public boolean isDefaultExclusiveQueue() {
        return this.defaultExclusiveQueue != null ? this.defaultExclusiveQueue : ActiveMQDefaultConfiguration.getDefaultExclusive();
    }

    public AddressSettings setDefaultExclusiveQueue(Boolean defaultExclusiveQueue) {
        this.defaultExclusiveQueue = defaultExclusiveQueue;
        return this;
    }

    public AddressFullMessagePolicy getAddressFullMessagePolicy() {
        return this.addressFullMessagePolicy != null ? this.addressFullMessagePolicy : DEFAULT_ADDRESS_FULL_MESSAGE_POLICY;
    }

    public AddressSettings setAddressFullMessagePolicy(AddressFullMessagePolicy addressFullMessagePolicy) {
        this.addressFullMessagePolicy = addressFullMessagePolicy;
        return this;
    }

    public int getPageSizeBytes() {
        return this.pageSizeBytes != null ? this.pageSizeBytes : 0xA00000;
    }

    public AddressSettings setPageSizeBytes(int pageSize) {
        this.pageSizeBytes = pageSize;
        return this;
    }

    public int getPageCacheMaxSize() {
        return this.pageMaxCache != null ? this.pageMaxCache : 5;
    }

    public AddressSettings setPageCacheMaxSize(int pageMaxCache) {
        this.pageMaxCache = pageMaxCache;
        return this;
    }

    public long getMaxSizeBytes() {
        return this.maxSizeBytes != null ? this.maxSizeBytes : -1L;
    }

    public AddressSettings setMaxSizeBytes(long maxSizeBytes) {
        this.maxSizeBytes = maxSizeBytes;
        return this;
    }

    public int getMaxDeliveryAttempts() {
        return this.maxDeliveryAttempts != null ? this.maxDeliveryAttempts : 10;
    }

    public AddressSettings setMaxDeliveryAttempts(int maxDeliveryAttempts) {
        this.maxDeliveryAttempts = maxDeliveryAttempts;
        return this;
    }

    public int getMessageCounterHistoryDayLimit() {
        return this.messageCounterHistoryDayLimit != null ? this.messageCounterHistoryDayLimit : 0;
    }

    public AddressSettings setMessageCounterHistoryDayLimit(int messageCounterHistoryDayLimit) {
        this.messageCounterHistoryDayLimit = messageCounterHistoryDayLimit;
        return this;
    }

    public long getRedeliveryDelay() {
        return this.redeliveryDelay != null ? this.redeliveryDelay : 0L;
    }

    public AddressSettings setRedeliveryDelay(long redeliveryDelay) {
        this.redeliveryDelay = redeliveryDelay;
        return this;
    }

    public double getRedeliveryMultiplier() {
        return this.redeliveryMultiplier != null ? this.redeliveryMultiplier : 1.0;
    }

    public AddressSettings setRedeliveryMultiplier(double redeliveryMultiplier) {
        this.redeliveryMultiplier = redeliveryMultiplier;
        return this;
    }

    public double getRedeliveryCollisionAvoidanceFactor() {
        return this.redeliveryCollisionAvoidanceFactor != null ? this.redeliveryCollisionAvoidanceFactor : 0.0;
    }

    public AddressSettings setRedeliveryCollisionAvoidanceFactor(double redeliveryCollisionAvoidanceFactor) {
        this.redeliveryCollisionAvoidanceFactor = redeliveryCollisionAvoidanceFactor;
        return this;
    }

    public long getMaxRedeliveryDelay() {
        return this.maxRedeliveryDelay != null ? this.maxRedeliveryDelay : this.getRedeliveryDelay() * 10L;
    }

    public AddressSettings setMaxRedeliveryDelay(long maxRedeliveryDelay) {
        this.maxRedeliveryDelay = maxRedeliveryDelay;
        return this;
    }

    public SimpleString getDeadLetterAddress() {
        return this.deadLetterAddress;
    }

    public AddressSettings setDeadLetterAddress(SimpleString deadLetterAddress) {
        this.deadLetterAddress = deadLetterAddress;
        return this;
    }

    public SimpleString getExpiryAddress() {
        return this.expiryAddress;
    }

    public AddressSettings setExpiryAddress(SimpleString expiryAddress) {
        this.expiryAddress = expiryAddress;
        return this;
    }

    public boolean isAutoCreateExpiryResources() {
        return this.autoCreateExpiryResources != null ? this.autoCreateExpiryResources : false;
    }

    public AddressSettings setAutoCreateExpiryResources(boolean value) {
        this.autoCreateExpiryResources = value;
        return this;
    }

    public SimpleString getExpiryQueuePrefix() {
        return this.expiryQueuePrefix != null ? this.expiryQueuePrefix : DEFAULT_EXPIRY_QUEUE_PREFIX;
    }

    public AddressSettings setExpiryQueuePrefix(SimpleString value) {
        this.expiryQueuePrefix = value;
        return this;
    }

    public SimpleString getExpiryQueueSuffix() {
        return this.expiryQueueSuffix != null ? this.expiryQueueSuffix : DEFAULT_EXPIRY_QUEUE_SUFFIX;
    }

    public AddressSettings setExpiryQueueSuffix(SimpleString value) {
        this.expiryQueueSuffix = value;
        return this;
    }

    public Long getExpiryDelay() {
        return this.expiryDelay;
    }

    public AddressSettings setExpiryDelay(Long expiryDelay) {
        this.expiryDelay = expiryDelay;
        return this;
    }

    public Long getMinExpiryDelay() {
        return this.minExpiryDelay;
    }

    public AddressSettings setMinExpiryDelay(Long minExpiryDelay) {
        this.minExpiryDelay = minExpiryDelay;
        return this;
    }

    public Long getMaxExpiryDelay() {
        return this.maxExpiryDelay;
    }

    public AddressSettings setMaxExpiryDelay(Long maxExpiryDelay) {
        this.maxExpiryDelay = maxExpiryDelay;
        return this;
    }

    public boolean isSendToDLAOnNoRoute() {
        return this.sendToDLAOnNoRoute != null ? this.sendToDLAOnNoRoute : false;
    }

    public AddressSettings setSendToDLAOnNoRoute(boolean value) {
        this.sendToDLAOnNoRoute = value;
        return this;
    }

    public boolean isAutoCreateDeadLetterResources() {
        return this.autoCreateDeadLetterResources != null ? this.autoCreateDeadLetterResources : false;
    }

    public AddressSettings setAutoCreateDeadLetterResources(boolean value) {
        this.autoCreateDeadLetterResources = value;
        return this;
    }

    public SimpleString getDeadLetterQueuePrefix() {
        return this.deadLetterQueuePrefix != null ? this.deadLetterQueuePrefix : DEFAULT_DEAD_LETTER_QUEUE_PREFIX;
    }

    public AddressSettings setDeadLetterQueuePrefix(SimpleString value) {
        this.deadLetterQueuePrefix = value;
        return this;
    }

    public SimpleString getDeadLetterQueueSuffix() {
        return this.deadLetterQueueSuffix != null ? this.deadLetterQueueSuffix : DEFAULT_DEAD_LETTER_QUEUE_SUFFIX;
    }

    public AddressSettings setDeadLetterQueueSuffix(SimpleString value) {
        this.deadLetterQueueSuffix = value;
        return this;
    }

    public long getRedistributionDelay() {
        return this.redistributionDelay != null ? this.redistributionDelay : -1L;
    }

    public AddressSettings setRedistributionDelay(long redistributionDelay) {
        this.redistributionDelay = redistributionDelay;
        return this;
    }

    public long getSlowConsumerThreshold() {
        return this.slowConsumerThreshold != null ? this.slowConsumerThreshold : -1L;
    }

    public AddressSettings setSlowConsumerThreshold(long slowConsumerThreshold) {
        this.slowConsumerThreshold = slowConsumerThreshold;
        return this;
    }

    public SlowConsumerThresholdMeasurementUnit getSlowConsumerThresholdMeasurementUnit() {
        return this.slowConsumerThresholdMeasurementUnit != null ? this.slowConsumerThresholdMeasurementUnit : DEFAULT_SLOW_CONSUMER_THRESHOLD_MEASUREMENT_UNIT;
    }

    public AddressSettings setSlowConsumerThresholdMeasurementUnit(SlowConsumerThresholdMeasurementUnit slowConsumerThresholdMeasurementUnit) {
        this.slowConsumerThresholdMeasurementUnit = slowConsumerThresholdMeasurementUnit;
        return this;
    }

    public long getSlowConsumerCheckPeriod() {
        return this.slowConsumerCheckPeriod != null ? this.slowConsumerCheckPeriod : 5L;
    }

    public AddressSettings setSlowConsumerCheckPeriod(long slowConsumerCheckPeriod) {
        this.slowConsumerCheckPeriod = slowConsumerCheckPeriod;
        return this;
    }

    public SlowConsumerPolicy getSlowConsumerPolicy() {
        return this.slowConsumerPolicy != null ? this.slowConsumerPolicy : DEFAULT_SLOW_CONSUMER_POLICY;
    }

    public AddressSettings setSlowConsumerPolicy(SlowConsumerPolicy slowConsumerPolicy) {
        this.slowConsumerPolicy = slowConsumerPolicy;
        return this;
    }

    public int getManagementBrowsePageSize() {
        return this.managementBrowsePageSize != null ? this.managementBrowsePageSize : 200;
    }

    public AddressSettings setManagementBrowsePageSize(int managementBrowsePageSize) {
        this.managementBrowsePageSize = managementBrowsePageSize;
        return this;
    }

    public int getQueuePrefetch() {
        return this.queuePrefetch != null ? this.queuePrefetch : 1000;
    }

    public AddressSettings setQueuePrefetch(int queuePrefetch) {
        this.queuePrefetch = queuePrefetch;
        return this;
    }

    public long getMaxSizeBytesRejectThreshold() {
        return this.maxSizeBytesRejectThreshold == null ? -1L : this.maxSizeBytesRejectThreshold;
    }

    public AddressSettings setMaxSizeBytesRejectThreshold(long maxSizeBytesRejectThreshold) {
        this.maxSizeBytesRejectThreshold = maxSizeBytesRejectThreshold;
        return this;
    }

    public int getDefaultConsumerWindowSize() {
        return this.defaultConsumerWindowSize != null ? this.defaultConsumerWindowSize : 0x100000;
    }

    public AddressSettings setDefaultConsumerWindowSize(int defaultConsumerWindowSize) {
        this.defaultConsumerWindowSize = defaultConsumerWindowSize;
        return this;
    }

    public boolean isDefaultGroupRebalance() {
        return this.defaultGroupRebalance != null ? this.defaultGroupRebalance : ActiveMQDefaultConfiguration.getDefaultGroupRebalance();
    }

    public AddressSettings setDefaultGroupRebalance(boolean defaultGroupRebalance) {
        this.defaultGroupRebalance = defaultGroupRebalance;
        return this;
    }

    public boolean isDefaultGroupRebalancePauseDispatch() {
        return this.defaultGroupRebalancePauseDispatch != null ? this.defaultGroupRebalancePauseDispatch : ActiveMQDefaultConfiguration.getDefaultGroupRebalancePauseDispatch();
    }

    public AddressSettings setDefaultGroupRebalancePauseDispatch(boolean defaultGroupRebalancePauseDispatch) {
        this.defaultGroupRebalancePauseDispatch = defaultGroupRebalancePauseDispatch;
        return this;
    }

    public int getDefaultGroupBuckets() {
        return this.defaultGroupBuckets != null ? this.defaultGroupBuckets : ActiveMQDefaultConfiguration.getDefaultGroupBuckets();
    }

    public SimpleString getDefaultGroupFirstKey() {
        return this.defaultGroupFirstKey != null ? this.defaultGroupFirstKey : ActiveMQDefaultConfiguration.getDefaultGroupFirstKey();
    }

    public AddressSettings setDefaultGroupFirstKey(SimpleString defaultGroupFirstKey) {
        this.defaultGroupFirstKey = defaultGroupFirstKey;
        return this;
    }

    public AddressSettings setDefaultGroupBuckets(int defaultGroupBuckets) {
        this.defaultGroupBuckets = defaultGroupBuckets;
        return this;
    }

    public long getDefaultRingSize() {
        return this.defaultRingSize != null ? this.defaultRingSize : -1L;
    }

    public AddressSettings setDefaultRingSize(long defaultRingSize) {
        this.defaultRingSize = defaultRingSize;
        return this;
    }

    public long getRetroactiveMessageCount() {
        return this.retroactiveMessageCount != null ? this.retroactiveMessageCount : 0L;
    }

    public AddressSettings setRetroactiveMessageCount(long defaultRetroactiveMessageCount) {
        this.retroactiveMessageCount = defaultRetroactiveMessageCount;
        return this;
    }

    public boolean isEnableMetrics() {
        return this.enableMetrics != null ? this.enableMetrics : true;
    }

    public AddressSettings setEnableMetrics(boolean enableMetrics) {
        this.enableMetrics = enableMetrics;
        return this;
    }

    public int getManagementMessageAttributeSizeLimit() {
        return this.managementMessageAttributeSizeLimit != null ? this.managementMessageAttributeSizeLimit : 256;
    }

    public AddressSettings setManagementMessageAttributeSizeLimit(int managementMessageAttributeSizeLimit) {
        this.managementMessageAttributeSizeLimit = managementMessageAttributeSizeLimit;
        return this;
    }

    public boolean isEnableIngressTimestamp() {
        return this.enableIngressTimestamp != null ? this.enableIngressTimestamp : false;
    }

    public AddressSettings setEnableIngressTimestamp(boolean enableIngressTimestamp) {
        this.enableIngressTimestamp = enableIngressTimestamp;
        return this;
    }

    @Override
    public void merge(AddressSettings merged) {
        if (this.maxDeliveryAttempts == null) {
            this.maxDeliveryAttempts = merged.maxDeliveryAttempts;
        }
        if (this.dropMessagesWhenFull == null) {
            this.dropMessagesWhenFull = merged.dropMessagesWhenFull;
        }
        if (this.maxSizeBytes == null) {
            this.maxSizeBytes = merged.maxSizeBytes;
        }
        if (this.pageMaxCache == null) {
            this.pageMaxCache = merged.pageMaxCache;
        }
        if (this.pageSizeBytes == null) {
            this.pageSizeBytes = merged.pageSizeBytes;
        }
        if (this.messageCounterHistoryDayLimit == null) {
            this.messageCounterHistoryDayLimit = merged.messageCounterHistoryDayLimit;
        }
        if (this.redeliveryDelay == null) {
            this.redeliveryDelay = merged.redeliveryDelay;
        }
        if (this.redeliveryMultiplier == null) {
            this.redeliveryMultiplier = merged.redeliveryMultiplier;
        }
        if (this.redeliveryCollisionAvoidanceFactor == null) {
            this.redeliveryCollisionAvoidanceFactor = merged.redeliveryCollisionAvoidanceFactor;
        }
        if (this.maxRedeliveryDelay == null) {
            this.maxRedeliveryDelay = merged.maxRedeliveryDelay;
        }
        if (this.deadLetterAddress == null) {
            this.deadLetterAddress = merged.deadLetterAddress;
        }
        if (this.expiryAddress == null) {
            this.expiryAddress = merged.expiryAddress;
        }
        if (this.expiryDelay == null) {
            this.expiryDelay = merged.expiryDelay;
        }
        if (this.minExpiryDelay == null) {
            this.minExpiryDelay = merged.minExpiryDelay;
        }
        if (this.maxExpiryDelay == null) {
            this.maxExpiryDelay = merged.maxExpiryDelay;
        }
        if (this.redistributionDelay == null) {
            this.redistributionDelay = merged.redistributionDelay;
        }
        if (this.sendToDLAOnNoRoute == null) {
            this.sendToDLAOnNoRoute = merged.sendToDLAOnNoRoute;
        }
        if (this.addressFullMessagePolicy == null) {
            this.addressFullMessagePolicy = merged.addressFullMessagePolicy;
        }
        if (this.slowConsumerThreshold == null) {
            this.slowConsumerThreshold = merged.slowConsumerThreshold;
        }
        if (this.slowConsumerThresholdMeasurementUnit == null) {
            this.slowConsumerThresholdMeasurementUnit = merged.slowConsumerThresholdMeasurementUnit;
        }
        if (this.slowConsumerCheckPeriod == null) {
            this.slowConsumerCheckPeriod = merged.slowConsumerCheckPeriod;
        }
        if (this.slowConsumerPolicy == null) {
            this.slowConsumerPolicy = merged.slowConsumerPolicy;
        }
        if (this.autoCreateJmsQueues == null) {
            this.autoCreateJmsQueues = merged.autoCreateJmsQueues;
        }
        if (this.autoDeleteJmsQueues == null) {
            this.autoDeleteJmsQueues = merged.autoDeleteJmsQueues;
        }
        if (this.autoCreateJmsTopics == null) {
            this.autoCreateJmsTopics = merged.autoCreateJmsTopics;
        }
        if (this.autoDeleteJmsTopics == null) {
            this.autoDeleteJmsTopics = merged.autoDeleteJmsTopics;
        }
        if (this.autoCreateQueues == null) {
            this.autoCreateQueues = merged.autoCreateQueues;
        }
        if (this.autoDeleteQueues == null) {
            this.autoDeleteQueues = merged.autoDeleteQueues;
        }
        if (this.autoDeleteCreatedQueues == null) {
            this.autoDeleteCreatedQueues = merged.autoDeleteCreatedQueues;
        }
        if (this.autoDeleteQueuesDelay == null) {
            this.autoDeleteQueuesDelay = merged.autoDeleteQueuesDelay;
        }
        if (this.autoDeleteQueuesMessageCount == null) {
            this.autoDeleteQueuesMessageCount = merged.autoDeleteQueuesMessageCount;
        }
        if (this.configDeleteQueues == null) {
            this.configDeleteQueues = merged.configDeleteQueues;
        }
        if (this.autoCreateAddresses == null) {
            this.autoCreateAddresses = merged.autoCreateAddresses;
        }
        if (this.autoDeleteAddresses == null) {
            this.autoDeleteAddresses = merged.autoDeleteAddresses;
        }
        if (this.autoDeleteAddressesDelay == null) {
            this.autoDeleteAddressesDelay = merged.autoDeleteAddressesDelay;
        }
        if (this.configDeleteAddresses == null) {
            this.configDeleteAddresses = merged.configDeleteAddresses;
        }
        if (this.managementBrowsePageSize == null) {
            this.managementBrowsePageSize = merged.managementBrowsePageSize;
        }
        if (this.managementMessageAttributeSizeLimit == null) {
            this.managementMessageAttributeSizeLimit = merged.managementMessageAttributeSizeLimit;
        }
        if (this.queuePrefetch == null) {
            this.queuePrefetch = merged.queuePrefetch;
        }
        if (this.maxSizeBytesRejectThreshold == null) {
            this.maxSizeBytesRejectThreshold = merged.maxSizeBytesRejectThreshold;
        }
        if (this.defaultMaxConsumers == null) {
            this.defaultMaxConsumers = merged.defaultMaxConsumers;
        }
        if (this.defaultPurgeOnNoConsumers == null) {
            this.defaultPurgeOnNoConsumers = merged.defaultPurgeOnNoConsumers;
        }
        if (this.defaultQueueRoutingType == null) {
            this.defaultQueueRoutingType = merged.defaultQueueRoutingType;
        }
        if (this.defaultAddressRoutingType == null) {
            this.defaultAddressRoutingType = merged.defaultAddressRoutingType;
        }
        if (this.defaultExclusiveQueue == null) {
            this.defaultExclusiveQueue = merged.defaultExclusiveQueue;
        }
        if (this.defaultConsumerWindowSize == null) {
            this.defaultConsumerWindowSize = merged.defaultConsumerWindowSize;
        }
        if (this.defaultLastValueQueue == null) {
            this.defaultLastValueQueue = merged.defaultLastValueQueue;
        }
        if (this.defaultLastValueKey == null) {
            this.defaultLastValueKey = merged.defaultLastValueKey;
        }
        if (this.defaultNonDestructive == null) {
            this.defaultNonDestructive = merged.defaultNonDestructive;
        }
        if (this.defaultConsumersBeforeDispatch == null) {
            this.defaultConsumersBeforeDispatch = merged.defaultConsumersBeforeDispatch;
        }
        if (this.defaultDelayBeforeDispatch == null) {
            this.defaultDelayBeforeDispatch = merged.defaultDelayBeforeDispatch;
        }
        if (this.defaultGroupRebalance == null) {
            this.defaultGroupRebalance = merged.defaultGroupRebalance;
        }
        if (this.defaultGroupRebalancePauseDispatch == null) {
            this.defaultGroupRebalancePauseDispatch = merged.defaultGroupRebalancePauseDispatch;
        }
        if (this.defaultGroupBuckets == null) {
            this.defaultGroupBuckets = merged.defaultGroupBuckets;
        }
        if (this.defaultGroupFirstKey == null) {
            this.defaultGroupFirstKey = merged.defaultGroupFirstKey;
        }
        if (this.defaultRingSize == null) {
            this.defaultRingSize = merged.defaultRingSize;
        }
        if (this.retroactiveMessageCount == null) {
            this.retroactiveMessageCount = merged.retroactiveMessageCount;
        }
        if (this.autoCreateDeadLetterResources == null) {
            this.autoCreateDeadLetterResources = merged.autoCreateDeadLetterResources;
        }
        if (this.deadLetterQueuePrefix == null) {
            this.deadLetterQueuePrefix = merged.deadLetterQueuePrefix;
        }
        if (this.deadLetterQueueSuffix == null) {
            this.deadLetterQueueSuffix = merged.deadLetterQueueSuffix;
        }
        if (this.autoCreateExpiryResources == null) {
            this.autoCreateExpiryResources = merged.autoCreateExpiryResources;
        }
        if (this.expiryQueuePrefix == null) {
            this.expiryQueuePrefix = merged.expiryQueuePrefix;
        }
        if (this.expiryQueueSuffix == null) {
            this.expiryQueueSuffix = merged.expiryQueueSuffix;
        }
        if (this.enableMetrics == null) {
            this.enableMetrics = merged.enableMetrics;
        }
        if (this.enableIngressTimestamp == null) {
            this.enableIngressTimestamp = merged.enableIngressTimestamp;
        }
    }

    public void decode(ActiveMQBuffer buffer) {
        int original = buffer.readerIndex();
        try {
            this.decode(buffer, false);
        }
        catch (Throwable e) {
            buffer.readerIndex(original);
            this.decode(buffer, true);
        }
    }

    public void decode(ActiveMQBuffer buffer, boolean tryCompatible) {
        Integer slowConsumerMeasurementUnitEnumValue;
        SimpleString policyStr = buffer.readNullableSimpleString();
        this.addressFullMessagePolicy = policyStr != null ? AddressFullMessagePolicy.valueOf((String)policyStr.toString()) : null;
        this.maxSizeBytes = BufferHelper.readNullableLong((ActiveMQBuffer)buffer);
        Long pageSizeLong = BufferHelper.readNullableLong((ActiveMQBuffer)buffer);
        this.pageSizeBytes = pageSizeLong == null ? null : Integer.valueOf(pageSizeLong.intValue());
        this.pageMaxCache = BufferHelper.readNullableInteger((ActiveMQBuffer)buffer);
        this.dropMessagesWhenFull = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        this.maxDeliveryAttempts = BufferHelper.readNullableInteger((ActiveMQBuffer)buffer);
        this.messageCounterHistoryDayLimit = BufferHelper.readNullableInteger((ActiveMQBuffer)buffer);
        this.redeliveryDelay = BufferHelper.readNullableLong((ActiveMQBuffer)buffer);
        this.redeliveryMultiplier = BufferHelper.readNullableDouble((ActiveMQBuffer)buffer);
        this.maxRedeliveryDelay = BufferHelper.readNullableLong((ActiveMQBuffer)buffer);
        this.deadLetterAddress = buffer.readNullableSimpleString();
        this.expiryAddress = buffer.readNullableSimpleString();
        this.expiryDelay = BufferHelper.readNullableLong((ActiveMQBuffer)buffer);
        this.defaultLastValueQueue = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        this.redistributionDelay = BufferHelper.readNullableLong((ActiveMQBuffer)buffer);
        this.sendToDLAOnNoRoute = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        this.slowConsumerThreshold = BufferHelper.readNullableLong((ActiveMQBuffer)buffer);
        this.slowConsumerCheckPeriod = BufferHelper.readNullableLong((ActiveMQBuffer)buffer);
        policyStr = buffer.readNullableSimpleString();
        this.slowConsumerPolicy = policyStr != null ? SlowConsumerPolicy.valueOf(policyStr.toString()) : null;
        this.autoCreateJmsQueues = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        this.autoDeleteJmsQueues = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        this.autoCreateJmsTopics = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        this.autoDeleteJmsTopics = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        this.autoCreateQueues = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        this.autoDeleteQueues = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        policyStr = tryCompatible ? null : buffer.readNullableSimpleString();
        this.configDeleteQueues = policyStr != null ? DeletionPolicy.valueOf(policyStr.toString()) : null;
        this.autoCreateAddresses = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        this.autoDeleteAddresses = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        policyStr = tryCompatible ? null : buffer.readNullableSimpleString();
        this.configDeleteAddresses = policyStr != null ? DeletionPolicy.valueOf(policyStr.toString()) : null;
        this.managementBrowsePageSize = BufferHelper.readNullableInteger((ActiveMQBuffer)buffer);
        this.maxSizeBytesRejectThreshold = BufferHelper.readNullableLong((ActiveMQBuffer)buffer);
        this.defaultMaxConsumers = BufferHelper.readNullableInteger((ActiveMQBuffer)buffer);
        this.defaultPurgeOnNoConsumers = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        this.defaultQueueRoutingType = RoutingType.getType((byte)buffer.readByte());
        this.defaultAddressRoutingType = RoutingType.getType((byte)buffer.readByte());
        if (buffer.readableBytes() > 0) {
            this.defaultExclusiveQueue = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.defaultConsumersBeforeDispatch = BufferHelper.readNullableInteger((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.defaultDelayBeforeDispatch = BufferHelper.readNullableLong((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.defaultConsumerWindowSize = BufferHelper.readNullableInteger((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.defaultLastValueKey = buffer.readNullableSimpleString();
        }
        if (buffer.readableBytes() > 0) {
            this.defaultNonDestructive = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.autoDeleteQueuesDelay = BufferHelper.readNullableLong((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.autoDeleteAddressesDelay = BufferHelper.readNullableLong((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.defaultGroupRebalance = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.defaultGroupBuckets = BufferHelper.readNullableInteger((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.autoDeleteQueuesMessageCount = BufferHelper.readNullableLong((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.autoDeleteCreatedQueues = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.defaultRingSize = BufferHelper.readNullableLong((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.redeliveryCollisionAvoidanceFactor = BufferHelper.readNullableDouble((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.defaultGroupFirstKey = buffer.readNullableSimpleString();
        }
        if (buffer.readableBytes() > 0) {
            this.retroactiveMessageCount = BufferHelper.readNullableLong((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.autoCreateDeadLetterResources = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.deadLetterQueuePrefix = buffer.readNullableSimpleString();
        }
        if (buffer.readableBytes() > 0) {
            this.deadLetterQueueSuffix = buffer.readNullableSimpleString();
        }
        if (buffer.readableBytes() > 0) {
            this.autoCreateExpiryResources = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.expiryQueuePrefix = buffer.readNullableSimpleString();
        }
        if (buffer.readableBytes() > 0) {
            this.expiryQueueSuffix = buffer.readNullableSimpleString();
        }
        if (buffer.readableBytes() > 0) {
            this.minExpiryDelay = BufferHelper.readNullableLong((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.maxExpiryDelay = BufferHelper.readNullableLong((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.enableMetrics = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.defaultGroupRebalancePauseDispatch = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.managementMessageAttributeSizeLimit = BufferHelper.readNullableInteger((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0 && (slowConsumerMeasurementUnitEnumValue = BufferHelper.readNullableInteger((ActiveMQBuffer)buffer)) != null) {
            this.slowConsumerThresholdMeasurementUnit = SlowConsumerThresholdMeasurementUnit.valueOf(slowConsumerMeasurementUnitEnumValue);
        }
        if (buffer.readableBytes() > 0) {
            this.enableIngressTimestamp = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        }
    }

    public int getEncodeSize() {
        return BufferHelper.sizeOfNullableSimpleString(this.addressFullMessagePolicy != null ? this.addressFullMessagePolicy.toString() : null) + BufferHelper.sizeOfNullableLong((Long)this.maxSizeBytes) + BufferHelper.sizeOfNullableLong(this.pageSizeBytes == null ? null : Long.valueOf(this.pageSizeBytes.intValue())) + BufferHelper.sizeOfNullableInteger((Integer)this.pageMaxCache) + BufferHelper.sizeOfNullableBoolean((Boolean)this.dropMessagesWhenFull) + BufferHelper.sizeOfNullableInteger((Integer)this.maxDeliveryAttempts) + BufferHelper.sizeOfNullableInteger((Integer)this.messageCounterHistoryDayLimit) + BufferHelper.sizeOfNullableLong((Long)this.redeliveryDelay) + BufferHelper.sizeOfNullableDouble((Double)this.redeliveryMultiplier) + BufferHelper.sizeOfNullableDouble((Double)this.redeliveryCollisionAvoidanceFactor) + BufferHelper.sizeOfNullableLong((Long)this.maxRedeliveryDelay) + SimpleString.sizeofNullableString((SimpleString)this.deadLetterAddress) + SimpleString.sizeofNullableString((SimpleString)this.expiryAddress) + BufferHelper.sizeOfNullableLong((Long)this.expiryDelay) + BufferHelper.sizeOfNullableLong((Long)this.minExpiryDelay) + BufferHelper.sizeOfNullableLong((Long)this.maxExpiryDelay) + BufferHelper.sizeOfNullableBoolean((Boolean)this.defaultLastValueQueue) + BufferHelper.sizeOfNullableLong((Long)this.redistributionDelay) + BufferHelper.sizeOfNullableBoolean((Boolean)this.sendToDLAOnNoRoute) + BufferHelper.sizeOfNullableLong((Long)this.slowConsumerCheckPeriod) + BufferHelper.sizeOfNullableLong((Long)this.slowConsumerThreshold) + BufferHelper.sizeOfNullableSimpleString(this.slowConsumerPolicy != null ? this.slowConsumerPolicy.toString() : null) + BufferHelper.sizeOfNullableBoolean((Boolean)this.autoCreateJmsQueues) + BufferHelper.sizeOfNullableBoolean((Boolean)this.autoDeleteJmsQueues) + BufferHelper.sizeOfNullableBoolean((Boolean)this.autoCreateJmsTopics) + BufferHelper.sizeOfNullableBoolean((Boolean)this.autoDeleteJmsTopics) + BufferHelper.sizeOfNullableBoolean((Boolean)this.autoCreateQueues) + BufferHelper.sizeOfNullableBoolean((Boolean)this.autoDeleteQueues) + BufferHelper.sizeOfNullableSimpleString(this.configDeleteQueues != null ? this.configDeleteQueues.toString() : null) + BufferHelper.sizeOfNullableBoolean((Boolean)this.autoCreateAddresses) + BufferHelper.sizeOfNullableBoolean((Boolean)this.autoDeleteAddresses) + BufferHelper.sizeOfNullableSimpleString(this.configDeleteAddresses != null ? this.configDeleteAddresses.toString() : null) + BufferHelper.sizeOfNullableInteger((Integer)this.managementBrowsePageSize) + BufferHelper.sizeOfNullableLong((Long)this.maxSizeBytesRejectThreshold) + BufferHelper.sizeOfNullableInteger((Integer)this.defaultMaxConsumers) + BufferHelper.sizeOfNullableBoolean((Boolean)this.defaultPurgeOnNoConsumers) + 1 + 1 + BufferHelper.sizeOfNullableBoolean((Boolean)this.defaultExclusiveQueue) + BufferHelper.sizeOfNullableInteger((Integer)this.defaultConsumersBeforeDispatch) + BufferHelper.sizeOfNullableLong((Long)this.defaultDelayBeforeDispatch) + BufferHelper.sizeOfNullableInteger((Integer)this.defaultConsumerWindowSize) + SimpleString.sizeofNullableString((SimpleString)this.defaultLastValueKey) + BufferHelper.sizeOfNullableBoolean((Boolean)this.defaultNonDestructive) + BufferHelper.sizeOfNullableLong((Long)this.autoDeleteQueuesDelay) + BufferHelper.sizeOfNullableLong((Long)this.autoDeleteAddressesDelay) + BufferHelper.sizeOfNullableBoolean((Boolean)this.defaultGroupRebalance) + BufferHelper.sizeOfNullableInteger((Integer)this.defaultGroupBuckets) + SimpleString.sizeofNullableString((SimpleString)this.defaultGroupFirstKey) + BufferHelper.sizeOfNullableLong((Long)this.autoDeleteQueuesMessageCount) + BufferHelper.sizeOfNullableBoolean((Boolean)this.autoDeleteCreatedQueues) + BufferHelper.sizeOfNullableLong((Long)this.defaultRingSize) + BufferHelper.sizeOfNullableLong((Long)this.retroactiveMessageCount) + BufferHelper.sizeOfNullableBoolean((Boolean)this.autoCreateDeadLetterResources) + SimpleString.sizeofNullableString((SimpleString)this.deadLetterQueuePrefix) + SimpleString.sizeofNullableString((SimpleString)this.deadLetterQueueSuffix) + BufferHelper.sizeOfNullableBoolean((Boolean)this.autoCreateExpiryResources) + SimpleString.sizeofNullableString((SimpleString)this.expiryQueuePrefix) + SimpleString.sizeofNullableString((SimpleString)this.expiryQueueSuffix) + BufferHelper.sizeOfNullableBoolean((Boolean)this.enableMetrics) + BufferHelper.sizeOfNullableBoolean((Boolean)this.defaultGroupRebalancePauseDispatch) + BufferHelper.sizeOfNullableInteger((Integer)this.managementMessageAttributeSizeLimit) + BufferHelper.sizeOfNullableInteger((Integer)this.slowConsumerThresholdMeasurementUnit.getValue()) + BufferHelper.sizeOfNullableBoolean((Boolean)this.enableIngressTimestamp);
    }

    public void encode(ActiveMQBuffer buffer) {
        buffer.writeNullableSimpleString(this.addressFullMessagePolicy != null ? new SimpleString(this.addressFullMessagePolicy.toString()) : null);
        BufferHelper.writeNullableLong((ActiveMQBuffer)buffer, (Long)this.maxSizeBytes);
        BufferHelper.writeNullableLong((ActiveMQBuffer)buffer, this.pageSizeBytes == null ? null : Long.valueOf(this.pageSizeBytes.intValue()));
        BufferHelper.writeNullableInteger((ActiveMQBuffer)buffer, (Integer)this.pageMaxCache);
        BufferHelper.writeNullableBoolean((ActiveMQBuffer)buffer, (Boolean)this.dropMessagesWhenFull);
        BufferHelper.writeNullableInteger((ActiveMQBuffer)buffer, (Integer)this.maxDeliveryAttempts);
        BufferHelper.writeNullableInteger((ActiveMQBuffer)buffer, (Integer)this.messageCounterHistoryDayLimit);
        BufferHelper.writeNullableLong((ActiveMQBuffer)buffer, (Long)this.redeliveryDelay);
        BufferHelper.writeNullableDouble((ActiveMQBuffer)buffer, (Double)this.redeliveryMultiplier);
        BufferHelper.writeNullableLong((ActiveMQBuffer)buffer, (Long)this.maxRedeliveryDelay);
        buffer.writeNullableSimpleString(this.deadLetterAddress);
        buffer.writeNullableSimpleString(this.expiryAddress);
        BufferHelper.writeNullableLong((ActiveMQBuffer)buffer, (Long)this.expiryDelay);
        BufferHelper.writeNullableBoolean((ActiveMQBuffer)buffer, (Boolean)this.defaultLastValueQueue);
        BufferHelper.writeNullableLong((ActiveMQBuffer)buffer, (Long)this.redistributionDelay);
        BufferHelper.writeNullableBoolean((ActiveMQBuffer)buffer, (Boolean)this.sendToDLAOnNoRoute);
        BufferHelper.writeNullableLong((ActiveMQBuffer)buffer, (Long)this.slowConsumerThreshold);
        BufferHelper.writeNullableLong((ActiveMQBuffer)buffer, (Long)this.slowConsumerCheckPeriod);
        buffer.writeNullableSimpleString(this.slowConsumerPolicy != null ? new SimpleString(this.slowConsumerPolicy.toString()) : null);
        BufferHelper.writeNullableBoolean((ActiveMQBuffer)buffer, (Boolean)this.autoCreateJmsQueues);
        BufferHelper.writeNullableBoolean((ActiveMQBuffer)buffer, (Boolean)this.autoDeleteJmsQueues);
        BufferHelper.writeNullableBoolean((ActiveMQBuffer)buffer, (Boolean)this.autoCreateJmsTopics);
        BufferHelper.writeNullableBoolean((ActiveMQBuffer)buffer, (Boolean)this.autoDeleteJmsTopics);
        BufferHelper.writeNullableBoolean((ActiveMQBuffer)buffer, (Boolean)this.autoCreateQueues);
        BufferHelper.writeNullableBoolean((ActiveMQBuffer)buffer, (Boolean)this.autoDeleteQueues);
        buffer.writeNullableSimpleString(this.configDeleteQueues != null ? new SimpleString(this.configDeleteQueues.toString()) : null);
        BufferHelper.writeNullableBoolean((ActiveMQBuffer)buffer, (Boolean)this.autoCreateAddresses);
        BufferHelper.writeNullableBoolean((ActiveMQBuffer)buffer, (Boolean)this.autoDeleteAddresses);
        buffer.writeNullableSimpleString(this.configDeleteAddresses != null ? new SimpleString(this.configDeleteAddresses.toString()) : null);
        BufferHelper.writeNullableInteger((ActiveMQBuffer)buffer, (Integer)this.managementBrowsePageSize);
        BufferHelper.writeNullableLong((ActiveMQBuffer)buffer, (Long)this.maxSizeBytesRejectThreshold);
        BufferHelper.writeNullableInteger((ActiveMQBuffer)buffer, (Integer)this.defaultMaxConsumers);
        BufferHelper.writeNullableBoolean((ActiveMQBuffer)buffer, (Boolean)this.defaultPurgeOnNoConsumers);
        buffer.writeByte(this.defaultQueueRoutingType == null ? (byte)-1 : this.defaultQueueRoutingType.getType());
        buffer.writeByte(this.defaultAddressRoutingType == null ? (byte)-1 : this.defaultAddressRoutingType.getType());
        BufferHelper.writeNullableBoolean((ActiveMQBuffer)buffer, (Boolean)this.defaultExclusiveQueue);
        BufferHelper.writeNullableInteger((ActiveMQBuffer)buffer, (Integer)this.defaultConsumersBeforeDispatch);
        BufferHelper.writeNullableLong((ActiveMQBuffer)buffer, (Long)this.defaultDelayBeforeDispatch);
        BufferHelper.writeNullableInteger((ActiveMQBuffer)buffer, (Integer)this.defaultConsumerWindowSize);
        buffer.writeNullableSimpleString(this.defaultLastValueKey);
        BufferHelper.writeNullableBoolean((ActiveMQBuffer)buffer, (Boolean)this.defaultNonDestructive);
        BufferHelper.writeNullableLong((ActiveMQBuffer)buffer, (Long)this.autoDeleteQueuesDelay);
        BufferHelper.writeNullableLong((ActiveMQBuffer)buffer, (Long)this.autoDeleteAddressesDelay);
        BufferHelper.writeNullableBoolean((ActiveMQBuffer)buffer, (Boolean)this.defaultGroupRebalance);
        BufferHelper.writeNullableInteger((ActiveMQBuffer)buffer, (Integer)this.defaultGroupBuckets);
        BufferHelper.writeNullableLong((ActiveMQBuffer)buffer, (Long)this.autoDeleteQueuesMessageCount);
        BufferHelper.writeNullableBoolean((ActiveMQBuffer)buffer, (Boolean)this.autoDeleteCreatedQueues);
        BufferHelper.writeNullableLong((ActiveMQBuffer)buffer, (Long)this.defaultRingSize);
        BufferHelper.writeNullableDouble((ActiveMQBuffer)buffer, (Double)this.redeliveryCollisionAvoidanceFactor);
        buffer.writeNullableSimpleString(this.defaultGroupFirstKey);
        BufferHelper.writeNullableLong((ActiveMQBuffer)buffer, (Long)this.retroactiveMessageCount);
        BufferHelper.writeNullableBoolean((ActiveMQBuffer)buffer, (Boolean)this.autoCreateDeadLetterResources);
        buffer.writeNullableSimpleString(this.deadLetterQueuePrefix);
        buffer.writeNullableSimpleString(this.deadLetterQueueSuffix);
        BufferHelper.writeNullableBoolean((ActiveMQBuffer)buffer, (Boolean)this.autoCreateExpiryResources);
        buffer.writeNullableSimpleString(this.expiryQueuePrefix);
        buffer.writeNullableSimpleString(this.expiryQueueSuffix);
        BufferHelper.writeNullableLong((ActiveMQBuffer)buffer, (Long)this.minExpiryDelay);
        BufferHelper.writeNullableLong((ActiveMQBuffer)buffer, (Long)this.maxExpiryDelay);
        BufferHelper.writeNullableBoolean((ActiveMQBuffer)buffer, (Boolean)this.enableMetrics);
        BufferHelper.writeNullableBoolean((ActiveMQBuffer)buffer, (Boolean)this.defaultGroupRebalancePauseDispatch);
        BufferHelper.writeNullableInteger((ActiveMQBuffer)buffer, (Integer)this.managementMessageAttributeSizeLimit);
        BufferHelper.writeNullableInteger((ActiveMQBuffer)buffer, this.slowConsumerThresholdMeasurementUnit == null ? null : Integer.valueOf(this.slowConsumerThresholdMeasurementUnit.getValue()));
        BufferHelper.writeNullableBoolean((ActiveMQBuffer)buffer, (Boolean)this.enableIngressTimestamp);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.addressFullMessagePolicy == null ? 0 : this.addressFullMessagePolicy.hashCode());
        result = 31 * result + (this.deadLetterAddress == null ? 0 : this.deadLetterAddress.hashCode());
        result = 31 * result + (this.dropMessagesWhenFull == null ? 0 : this.dropMessagesWhenFull.hashCode());
        result = 31 * result + (this.expiryAddress == null ? 0 : this.expiryAddress.hashCode());
        result = 31 * result + (this.expiryDelay == null ? 0 : this.expiryDelay.hashCode());
        result = 31 * result + (this.minExpiryDelay == null ? 0 : this.expiryDelay.hashCode());
        result = 31 * result + (this.maxExpiryDelay == null ? 0 : this.expiryDelay.hashCode());
        result = 31 * result + (this.defaultLastValueQueue == null ? 0 : this.defaultLastValueQueue.hashCode());
        result = 31 * result + (this.defaultLastValueKey == null ? 0 : this.defaultLastValueKey.hashCode());
        result = 31 * result + (this.defaultNonDestructive == null ? 0 : this.defaultNonDestructive.hashCode());
        result = 31 * result + (this.defaultExclusiveQueue == null ? 0 : this.defaultExclusiveQueue.hashCode());
        result = 31 * result + (this.maxDeliveryAttempts == null ? 0 : this.maxDeliveryAttempts.hashCode());
        result = 31 * result + (this.maxSizeBytes == null ? 0 : this.maxSizeBytes.hashCode());
        result = 31 * result + (this.messageCounterHistoryDayLimit == null ? 0 : this.messageCounterHistoryDayLimit.hashCode());
        result = 31 * result + (this.pageSizeBytes == null ? 0 : this.pageSizeBytes.hashCode());
        result = 31 * result + (this.pageMaxCache == null ? 0 : this.pageMaxCache.hashCode());
        result = 31 * result + (this.redeliveryDelay == null ? 0 : this.redeliveryDelay.hashCode());
        result = 31 * result + (this.redeliveryMultiplier == null ? 0 : this.redeliveryMultiplier.hashCode());
        result = 31 * result + (this.redeliveryCollisionAvoidanceFactor == null ? 0 : this.redeliveryCollisionAvoidanceFactor.hashCode());
        result = 31 * result + (this.maxRedeliveryDelay == null ? 0 : this.maxRedeliveryDelay.hashCode());
        result = 31 * result + (this.redistributionDelay == null ? 0 : this.redistributionDelay.hashCode());
        result = 31 * result + (this.sendToDLAOnNoRoute == null ? 0 : this.sendToDLAOnNoRoute.hashCode());
        result = 31 * result + (this.slowConsumerThreshold == null ? 0 : this.slowConsumerThreshold.hashCode());
        result = 31 * result + (this.slowConsumerCheckPeriod == null ? 0 : this.slowConsumerCheckPeriod.hashCode());
        result = 31 * result + (this.slowConsumerPolicy == null ? 0 : this.slowConsumerPolicy.hashCode());
        result = 31 * result + (this.autoCreateJmsQueues == null ? 0 : this.autoCreateJmsQueues.hashCode());
        result = 31 * result + (this.autoDeleteJmsQueues == null ? 0 : this.autoDeleteJmsQueues.hashCode());
        result = 31 * result + (this.autoCreateJmsTopics == null ? 0 : this.autoCreateJmsTopics.hashCode());
        result = 31 * result + (this.autoDeleteJmsTopics == null ? 0 : this.autoDeleteJmsTopics.hashCode());
        result = 31 * result + (this.autoCreateQueues == null ? 0 : this.autoCreateQueues.hashCode());
        result = 31 * result + (this.autoDeleteQueues == null ? 0 : this.autoDeleteQueues.hashCode());
        result = 31 * result + (this.autoDeleteCreatedQueues == null ? 0 : this.autoDeleteCreatedQueues.hashCode());
        result = 31 * result + (this.autoDeleteQueuesDelay == null ? 0 : this.autoDeleteQueuesDelay.hashCode());
        result = 31 * result + (this.autoDeleteQueuesMessageCount == null ? 0 : this.autoDeleteQueuesMessageCount.hashCode());
        result = 31 * result + (this.configDeleteQueues == null ? 0 : this.configDeleteQueues.hashCode());
        result = 31 * result + (this.autoCreateAddresses == null ? 0 : this.autoCreateAddresses.hashCode());
        result = 31 * result + (this.autoDeleteAddresses == null ? 0 : this.autoDeleteAddresses.hashCode());
        result = 31 * result + (this.autoDeleteAddressesDelay == null ? 0 : this.autoDeleteAddressesDelay.hashCode());
        result = 31 * result + (this.configDeleteAddresses == null ? 0 : this.configDeleteAddresses.hashCode());
        result = 31 * result + (this.configDeleteDiverts == null ? 0 : this.configDeleteDiverts.hashCode());
        result = 31 * result + (this.managementBrowsePageSize == null ? 0 : this.managementBrowsePageSize.hashCode());
        result = 31 * result + (this.queuePrefetch == null ? 0 : this.queuePrefetch.hashCode());
        result = 31 * result + (this.maxSizeBytesRejectThreshold == null ? 0 : this.maxSizeBytesRejectThreshold.hashCode());
        result = 31 * result + (this.defaultMaxConsumers == null ? 0 : this.defaultMaxConsumers.hashCode());
        result = 31 * result + (this.defaultPurgeOnNoConsumers == null ? 0 : this.defaultPurgeOnNoConsumers.hashCode());
        result = 31 * result + (this.defaultQueueRoutingType == null ? 0 : this.defaultQueueRoutingType.hashCode());
        result = 31 * result + (this.defaultAddressRoutingType == null ? 0 : this.defaultAddressRoutingType.hashCode());
        result = 31 * result + (this.defaultConsumersBeforeDispatch == null ? 0 : this.defaultConsumersBeforeDispatch.hashCode());
        result = 31 * result + (this.defaultDelayBeforeDispatch == null ? 0 : this.defaultDelayBeforeDispatch.hashCode());
        result = 31 * result + (this.defaultConsumerWindowSize == null ? 0 : this.defaultConsumerWindowSize.hashCode());
        result = 31 * result + (this.defaultGroupRebalance == null ? 0 : this.defaultGroupRebalance.hashCode());
        result = 31 * result + (this.defaultGroupRebalancePauseDispatch == null ? 0 : this.defaultGroupRebalancePauseDispatch.hashCode());
        result = 31 * result + (this.defaultGroupBuckets == null ? 0 : this.defaultGroupBuckets.hashCode());
        result = 31 * result + (this.defaultGroupFirstKey == null ? 0 : this.defaultGroupFirstKey.hashCode());
        result = 31 * result + (this.defaultRingSize == null ? 0 : this.defaultRingSize.hashCode());
        result = 31 * result + (this.retroactiveMessageCount == null ? 0 : this.retroactiveMessageCount.hashCode());
        result = 31 * result + (this.autoCreateDeadLetterResources == null ? 0 : this.autoCreateDeadLetterResources.hashCode());
        result = 31 * result + (this.deadLetterQueuePrefix == null ? 0 : this.deadLetterQueuePrefix.hashCode());
        result = 31 * result + (this.deadLetterQueueSuffix == null ? 0 : this.deadLetterQueueSuffix.hashCode());
        result = 31 * result + (this.autoCreateExpiryResources == null ? 0 : this.autoCreateExpiryResources.hashCode());
        result = 31 * result + (this.expiryQueuePrefix == null ? 0 : this.expiryQueuePrefix.hashCode());
        result = 31 * result + (this.expiryQueueSuffix == null ? 0 : this.expiryQueueSuffix.hashCode());
        result = 31 * result + (this.enableMetrics == null ? 0 : this.enableMetrics.hashCode());
        result = 31 * result + (this.managementMessageAttributeSizeLimit == null ? 0 : this.managementMessageAttributeSizeLimit.hashCode());
        result = 31 * result + (this.slowConsumerThresholdMeasurementUnit == null ? 0 : this.slowConsumerThresholdMeasurementUnit.hashCode());
        result = 31 * result + (this.enableIngressTimestamp == null ? 0 : this.enableIngressTimestamp.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AddressSettings other = (AddressSettings)obj;
        if (this.addressFullMessagePolicy == null ? other.addressFullMessagePolicy != null : !this.addressFullMessagePolicy.equals((Object)other.addressFullMessagePolicy)) {
            return false;
        }
        if (this.deadLetterAddress == null ? other.deadLetterAddress != null : !this.deadLetterAddress.equals((Object)other.deadLetterAddress)) {
            return false;
        }
        if (this.dropMessagesWhenFull == null ? other.dropMessagesWhenFull != null : !this.dropMessagesWhenFull.equals(other.dropMessagesWhenFull)) {
            return false;
        }
        if (this.expiryAddress == null ? other.expiryAddress != null : !this.expiryAddress.equals((Object)other.expiryAddress)) {
            return false;
        }
        if (this.expiryDelay == null ? other.expiryDelay != null : !this.expiryDelay.equals(other.expiryDelay)) {
            return false;
        }
        if (this.minExpiryDelay == null ? other.minExpiryDelay != null : !this.minExpiryDelay.equals(other.minExpiryDelay)) {
            return false;
        }
        if (this.maxExpiryDelay == null ? other.maxExpiryDelay != null : !this.maxExpiryDelay.equals(other.maxExpiryDelay)) {
            return false;
        }
        if (this.defaultLastValueQueue == null ? other.defaultLastValueQueue != null : !this.defaultLastValueQueue.equals(other.defaultLastValueQueue)) {
            return false;
        }
        if (this.defaultLastValueKey == null ? other.defaultLastValueKey != null : !this.defaultLastValueKey.equals((Object)other.defaultLastValueKey)) {
            return false;
        }
        if (this.defaultNonDestructive == null ? other.defaultNonDestructive != null : !this.defaultNonDestructive.equals(other.defaultNonDestructive)) {
            return false;
        }
        if (this.defaultExclusiveQueue == null ? other.defaultExclusiveQueue != null : !this.defaultExclusiveQueue.equals(other.defaultExclusiveQueue)) {
            return false;
        }
        if (this.maxDeliveryAttempts == null ? other.maxDeliveryAttempts != null : !this.maxDeliveryAttempts.equals(other.maxDeliveryAttempts)) {
            return false;
        }
        if (this.maxSizeBytes == null ? other.maxSizeBytes != null : !this.maxSizeBytes.equals(other.maxSizeBytes)) {
            return false;
        }
        if (this.messageCounterHistoryDayLimit == null ? other.messageCounterHistoryDayLimit != null : !this.messageCounterHistoryDayLimit.equals(other.messageCounterHistoryDayLimit)) {
            return false;
        }
        if (this.pageSizeBytes == null ? other.pageSizeBytes != null : !this.pageSizeBytes.equals(other.pageSizeBytes)) {
            return false;
        }
        if (this.pageMaxCache == null ? other.pageMaxCache != null : !this.pageMaxCache.equals(other.pageMaxCache)) {
            return false;
        }
        if (this.redeliveryDelay == null ? other.redeliveryDelay != null : !this.redeliveryDelay.equals(other.redeliveryDelay)) {
            return false;
        }
        if (this.redeliveryMultiplier == null ? other.redeliveryMultiplier != null : !this.redeliveryMultiplier.equals(other.redeliveryMultiplier)) {
            return false;
        }
        if (this.redeliveryCollisionAvoidanceFactor == null ? other.redeliveryCollisionAvoidanceFactor != null : !this.redeliveryCollisionAvoidanceFactor.equals(other.redeliveryCollisionAvoidanceFactor)) {
            return false;
        }
        if (this.maxRedeliveryDelay == null ? other.maxRedeliveryDelay != null : !this.maxRedeliveryDelay.equals(other.maxRedeliveryDelay)) {
            return false;
        }
        if (this.redistributionDelay == null ? other.redistributionDelay != null : !this.redistributionDelay.equals(other.redistributionDelay)) {
            return false;
        }
        if (this.sendToDLAOnNoRoute == null ? other.sendToDLAOnNoRoute != null : !this.sendToDLAOnNoRoute.equals(other.sendToDLAOnNoRoute)) {
            return false;
        }
        if (this.slowConsumerThreshold == null ? other.slowConsumerThreshold != null : !this.slowConsumerThreshold.equals(other.slowConsumerThreshold)) {
            return false;
        }
        if (this.slowConsumerCheckPeriod == null ? other.slowConsumerCheckPeriod != null : !this.slowConsumerCheckPeriod.equals(other.slowConsumerCheckPeriod)) {
            return false;
        }
        if (this.slowConsumerPolicy == null ? other.slowConsumerPolicy != null : !this.slowConsumerPolicy.equals((Object)other.slowConsumerPolicy)) {
            return false;
        }
        if (this.autoCreateJmsQueues == null ? other.autoCreateJmsQueues != null : !this.autoCreateJmsQueues.equals(other.autoCreateJmsQueues)) {
            return false;
        }
        if (this.autoDeleteJmsQueues == null ? other.autoDeleteJmsQueues != null : !this.autoDeleteJmsQueues.equals(other.autoDeleteJmsQueues)) {
            return false;
        }
        if (this.autoCreateJmsTopics == null ? other.autoCreateJmsTopics != null : !this.autoCreateJmsTopics.equals(other.autoCreateJmsTopics)) {
            return false;
        }
        if (this.autoDeleteJmsTopics == null ? other.autoDeleteJmsTopics != null : !this.autoDeleteJmsTopics.equals(other.autoDeleteJmsTopics)) {
            return false;
        }
        if (this.autoCreateQueues == null ? other.autoCreateQueues != null : !this.autoCreateQueues.equals(other.autoCreateQueues)) {
            return false;
        }
        if (this.autoDeleteQueues == null ? other.autoDeleteQueues != null : !this.autoDeleteQueues.equals(other.autoDeleteQueues)) {
            return false;
        }
        if (this.autoDeleteCreatedQueues == null ? other.autoDeleteCreatedQueues != null : !this.autoDeleteCreatedQueues.equals(other.autoDeleteCreatedQueues)) {
            return false;
        }
        if (this.autoDeleteQueuesDelay == null ? other.autoDeleteQueuesDelay != null : !this.autoDeleteQueuesDelay.equals(other.autoDeleteQueuesDelay)) {
            return false;
        }
        if (this.autoDeleteQueuesMessageCount == null ? other.autoDeleteQueuesMessageCount != null : !this.autoDeleteQueuesMessageCount.equals(other.autoDeleteQueuesMessageCount)) {
            return false;
        }
        if (this.configDeleteQueues == null ? other.configDeleteQueues != null : !this.configDeleteQueues.equals((Object)other.configDeleteQueues)) {
            return false;
        }
        if (this.autoCreateAddresses == null ? other.autoCreateAddresses != null : !this.autoCreateAddresses.equals(other.autoCreateAddresses)) {
            return false;
        }
        if (this.autoDeleteAddresses == null ? other.autoDeleteAddresses != null : !this.autoDeleteAddresses.equals(other.autoDeleteAddresses)) {
            return false;
        }
        if (this.autoDeleteAddressesDelay == null ? other.autoDeleteAddressesDelay != null : !this.autoDeleteAddressesDelay.equals(other.autoDeleteAddressesDelay)) {
            return false;
        }
        if (this.configDeleteAddresses == null ? other.configDeleteAddresses != null : !this.configDeleteAddresses.equals((Object)other.configDeleteAddresses)) {
            return false;
        }
        if (this.configDeleteDiverts == null ? other.configDeleteDiverts != null : !this.configDeleteDiverts.equals((Object)other.configDeleteDiverts)) {
            return false;
        }
        if (this.managementBrowsePageSize == null ? other.managementBrowsePageSize != null : !this.managementBrowsePageSize.equals(other.managementBrowsePageSize)) {
            return false;
        }
        if (this.managementMessageAttributeSizeLimit == null ? other.managementMessageAttributeSizeLimit != null : !this.managementMessageAttributeSizeLimit.equals(other.managementMessageAttributeSizeLimit)) {
            return false;
        }
        if (this.queuePrefetch == null ? other.queuePrefetch != null : !this.queuePrefetch.equals(other.queuePrefetch)) {
            return false;
        }
        if (this.maxSizeBytesRejectThreshold == null ? other.maxSizeBytesRejectThreshold != null : !this.maxSizeBytesRejectThreshold.equals(other.maxSizeBytesRejectThreshold)) {
            return false;
        }
        if (this.defaultMaxConsumers == null ? other.defaultMaxConsumers != null : !this.defaultMaxConsumers.equals(other.defaultMaxConsumers)) {
            return false;
        }
        if (this.defaultPurgeOnNoConsumers == null ? other.defaultPurgeOnNoConsumers != null : !this.defaultPurgeOnNoConsumers.equals(other.defaultPurgeOnNoConsumers)) {
            return false;
        }
        if (this.defaultQueueRoutingType == null ? other.defaultQueueRoutingType != null : !this.defaultQueueRoutingType.equals((Object)other.defaultQueueRoutingType)) {
            return false;
        }
        if (this.defaultAddressRoutingType == null ? other.defaultAddressRoutingType != null : !this.defaultAddressRoutingType.equals((Object)other.defaultAddressRoutingType)) {
            return false;
        }
        if (this.defaultConsumersBeforeDispatch == null ? other.defaultConsumersBeforeDispatch != null : !this.defaultConsumersBeforeDispatch.equals(other.defaultConsumersBeforeDispatch)) {
            return false;
        }
        if (this.defaultDelayBeforeDispatch == null ? other.defaultDelayBeforeDispatch != null : !this.defaultDelayBeforeDispatch.equals(other.defaultDelayBeforeDispatch)) {
            return false;
        }
        if (this.defaultConsumerWindowSize == null ? other.defaultConsumerWindowSize != null : !this.defaultConsumerWindowSize.equals(other.defaultConsumerWindowSize)) {
            return false;
        }
        if (this.defaultGroupRebalance == null ? other.defaultGroupRebalance != null : !this.defaultGroupRebalance.equals(other.defaultGroupRebalance)) {
            return false;
        }
        if (this.defaultGroupRebalancePauseDispatch == null ? other.defaultGroupRebalancePauseDispatch != null : !this.defaultGroupRebalancePauseDispatch.equals(other.defaultGroupRebalancePauseDispatch)) {
            return false;
        }
        if (this.defaultGroupBuckets == null ? other.defaultGroupBuckets != null : !this.defaultGroupBuckets.equals(other.defaultGroupBuckets)) {
            return false;
        }
        if (this.defaultGroupFirstKey == null ? other.defaultGroupFirstKey != null : !this.defaultGroupFirstKey.equals((Object)other.defaultGroupFirstKey)) {
            return false;
        }
        if (this.defaultRingSize == null ? other.defaultRingSize != null : !this.defaultRingSize.equals(other.defaultRingSize)) {
            return false;
        }
        if (this.retroactiveMessageCount == null ? other.retroactiveMessageCount != null : !this.retroactiveMessageCount.equals(other.retroactiveMessageCount)) {
            return false;
        }
        if (this.autoCreateDeadLetterResources == null ? other.autoCreateDeadLetterResources != null : !this.autoCreateDeadLetterResources.equals(other.autoCreateDeadLetterResources)) {
            return false;
        }
        if (this.deadLetterQueuePrefix == null ? other.deadLetterQueuePrefix != null : !this.deadLetterQueuePrefix.equals((Object)other.deadLetterQueuePrefix)) {
            return false;
        }
        if (this.deadLetterQueueSuffix == null ? other.deadLetterQueueSuffix != null : !this.deadLetterQueueSuffix.equals((Object)other.deadLetterQueueSuffix)) {
            return false;
        }
        if (this.autoCreateExpiryResources == null ? other.autoCreateExpiryResources != null : !this.autoCreateExpiryResources.equals(other.autoCreateExpiryResources)) {
            return false;
        }
        if (this.expiryQueuePrefix == null ? other.expiryQueuePrefix != null : !this.expiryQueuePrefix.equals((Object)other.expiryQueuePrefix)) {
            return false;
        }
        if (this.expiryQueueSuffix == null ? other.expiryQueueSuffix != null : !this.expiryQueueSuffix.equals((Object)other.expiryQueueSuffix)) {
            return false;
        }
        if (this.enableMetrics == null ? other.enableMetrics != null : !this.enableMetrics.equals(other.enableMetrics)) {
            return false;
        }
        if (this.slowConsumerThresholdMeasurementUnit != other.slowConsumerThresholdMeasurementUnit) {
            return false;
        }
        return !(this.enableIngressTimestamp == null ? other.enableIngressTimestamp != null : !this.enableIngressTimestamp.equals(other.enableIngressTimestamp));
    }

    public String toString() {
        return "AddressSettings [addressFullMessagePolicy=" + this.addressFullMessagePolicy + ", deadLetterAddress=" + this.deadLetterAddress + ", dropMessagesWhenFull=" + this.dropMessagesWhenFull + ", expiryAddress=" + this.expiryAddress + ", expiryDelay=" + this.expiryDelay + ", minExpiryDelay=" + this.minExpiryDelay + ", maxExpiryDelay=" + this.maxExpiryDelay + ", defaultLastValueQueue=" + this.defaultLastValueQueue + ", defaultLastValueKey=" + this.defaultLastValueKey + ", defaultNonDestructive=" + this.defaultNonDestructive + ", defaultExclusiveQueue=" + this.defaultExclusiveQueue + ", maxDeliveryAttempts=" + this.maxDeliveryAttempts + ", maxSizeBytes=" + this.maxSizeBytes + ", maxSizeBytesRejectThreshold=" + this.maxSizeBytesRejectThreshold + ", messageCounterHistoryDayLimit=" + this.messageCounterHistoryDayLimit + ", pageSizeBytes=" + this.pageSizeBytes + ", pageMaxCache=" + this.pageMaxCache + ", redeliveryDelay=" + this.redeliveryDelay + ", redeliveryMultiplier=" + this.redeliveryMultiplier + ", redeliveryCollisionAvoidanceFactor=" + this.redeliveryCollisionAvoidanceFactor + ", maxRedeliveryDelay=" + this.maxRedeliveryDelay + ", redistributionDelay=" + this.redistributionDelay + ", sendToDLAOnNoRoute=" + this.sendToDLAOnNoRoute + ", slowConsumerThreshold=" + this.slowConsumerThreshold + ", slowConsumerThresholdMeasurementUnit=" + (Object)((Object)this.slowConsumerThresholdMeasurementUnit) + ", slowConsumerCheckPeriod=" + this.slowConsumerCheckPeriod + ", slowConsumerPolicy=" + (Object)((Object)this.slowConsumerPolicy) + ", autoCreateJmsQueues=" + this.autoCreateJmsQueues + ", autoDeleteJmsQueues=" + this.autoDeleteJmsQueues + ", autoCreateJmsTopics=" + this.autoCreateJmsTopics + ", autoDeleteJmsTopics=" + this.autoDeleteJmsTopics + ", autoCreateQueues=" + this.autoCreateQueues + ", autoDeleteQueues=" + this.autoDeleteQueues + ", autoDeleteCreatedQueues=" + this.autoDeleteCreatedQueues + ", autoDeleteQueuesDelay=" + this.autoDeleteQueuesDelay + ", autoDeleteQueuesMessageCount=" + this.autoDeleteQueuesMessageCount + ", configDeleteQueues=" + (Object)((Object)this.configDeleteQueues) + ", autoCreateAddresses=" + this.autoCreateAddresses + ", autoDeleteAddresses=" + this.autoDeleteAddresses + ", autoDeleteAddressesDelay=" + this.autoDeleteAddressesDelay + ", configDeleteAddresses=" + (Object)((Object)this.configDeleteAddresses) + ", configDeleteDiverts=" + (Object)((Object)this.configDeleteDiverts) + ", managementBrowsePageSize=" + this.managementBrowsePageSize + ", managementMessageAttributeSizeLimit=" + this.managementMessageAttributeSizeLimit + ", defaultMaxConsumers=" + this.defaultMaxConsumers + ", defaultPurgeOnNoConsumers=" + this.defaultPurgeOnNoConsumers + ", defaultQueueRoutingType=" + this.defaultQueueRoutingType + ", defaultAddressRoutingType=" + this.defaultAddressRoutingType + ", defaultConsumersBeforeDispatch=" + this.defaultConsumersBeforeDispatch + ", defaultDelayBeforeDispatch=" + this.defaultDelayBeforeDispatch + ", defaultClientWindowSize=" + this.defaultConsumerWindowSize + ", defaultGroupRebalance=" + this.defaultGroupRebalance + ", defaultGroupRebalancePauseDispatch=" + this.defaultGroupRebalancePauseDispatch + ", defaultGroupBuckets=" + this.defaultGroupBuckets + ", defaultGroupFirstKey=" + this.defaultGroupFirstKey + ", defaultRingSize=" + this.defaultRingSize + ", retroactiveMessageCount=" + this.retroactiveMessageCount + ", autoCreateDeadLetterResources=" + this.autoCreateDeadLetterResources + ", deadLetterQueuePrefix=" + this.deadLetterQueuePrefix + ", deadLetterQueueSuffix=" + this.deadLetterQueueSuffix + ", autoCreateExpiryResources=" + this.autoCreateExpiryResources + ", expiryQueuePrefix=" + this.expiryQueuePrefix + ", expiryQueueSuffix=" + this.expiryQueueSuffix + ", enableMetrics=" + this.enableMetrics + ", enableIngressTime=" + this.enableIngressTimestamp + "]";
    }
}

