/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEvent;
import javax.sql.StatementEventListener;
import org.apache.derby.iapi.jdbc.BrokeredConnection;
import org.apache.derby.iapi.jdbc.BrokeredConnectionControl;
import org.apache.derby.iapi.jdbc.EmbeddedDataSourceInterface;
import org.apache.derby.iapi.jdbc.EngineConnection;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.impl.jdbc.EmbedCallableStatement;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.EmbedPreparedStatement;
import org.apache.derby.impl.jdbc.Util;

public class EmbedPooledConnection
implements PooledConnection,
BrokeredConnectionControl {
    private String connString;
    private ArrayList<ConnectionEventListener> eventListener;
    private final CopyOnWriteArrayList<StatementEventListener> statementEventListeners = new CopyOnWriteArrayList();
    private int eventIterators;
    EmbedConnection realConnection;
    int defaultIsolationLevel;
    private boolean defaultReadOnly;
    BrokeredConnection currentConnectionHandle;
    final EmbeddedDataSourceInterface dataSource;
    private final String username;
    private final String password;
    private final boolean requestPassword;
    protected boolean isActive;

    public boolean isActive() {
        return this.isActive;
    }

    public EmbedPooledConnection(EmbeddedDataSourceInterface embeddedDataSourceInterface, String string, String string2, boolean bl) throws SQLException {
        this.dataSource = embeddedDataSourceInterface;
        this.username = string;
        this.password = string2;
        this.requestPassword = bl;
        this.isActive = true;
        this.openRealConnection();
    }

    String getUsername() {
        if (this.username == null || this.username.equals("")) {
            return "APP";
        }
        return this.username;
    }

    String getPassword() {
        if (this.password == null) {
            return "";
        }
        return this.password;
    }

    @Override
    public synchronized Connection getConnection() throws SQLException {
        this.checkActive();
        if (this.realConnection == null) {
            this.openRealConnection();
        } else {
            this.resetRealConnection();
        }
        this.closeCurrentConnectionHandle();
        Connection connection = this.getNewCurrentConnectionHandle();
        return connection;
    }

    final void openRealConnection() throws SQLException {
        Connection connection = this.dataSource.getConnection(this.username, this.password, this.requestPassword);
        this.realConnection = (EmbedConnection)connection;
        this.defaultIsolationLevel = connection.getTransactionIsolation();
        this.defaultReadOnly = connection.isReadOnly();
        if (this.currentConnectionHandle != null) {
            this.realConnection.setApplicationConnection(this.currentConnectionHandle);
        }
    }

    final Connection getNewCurrentConnectionHandle() throws SQLException {
        BrokeredConnection brokeredConnection = this.currentConnectionHandle = this.realConnection.getLocalDriver().newBrokeredConnection(this);
        this.realConnection.setApplicationConnection(brokeredConnection);
        return brokeredConnection;
    }

    private void closeCurrentConnectionHandle() throws SQLException {
        if (this.currentConnectionHandle != null) {
            ArrayList<ConnectionEventListener> arrayList = this.eventListener;
            this.eventListener = null;
            try {
                this.currentConnectionHandle.close();
            }
            finally {
                this.eventListener = arrayList;
            }
            this.currentConnectionHandle = null;
        }
    }

    void resetRealConnection() throws SQLException {
        this.realConnection.rollback();
        this.realConnection.clearWarnings();
        if (this.realConnection.getTransactionIsolation() != this.defaultIsolationLevel) {
            this.realConnection.setTransactionIsolation(this.defaultIsolationLevel);
        }
        if (!this.realConnection.getAutoCommit()) {
            this.realConnection.setAutoCommit(true);
        }
        if (this.realConnection.isReadOnly() != this.defaultReadOnly) {
            this.realConnection.setReadOnly(this.defaultReadOnly);
        }
        if (this.realConnection.getHoldability() != 1) {
            this.realConnection.setHoldability(1);
        }
        this.realConnection.resetFromPool();
    }

    @Override
    public synchronized void close() throws SQLException {
        if (!this.isActive) {
            return;
        }
        this.closeCurrentConnectionHandle();
        try {
            if (this.realConnection != null && !this.realConnection.isClosed()) {
                this.realConnection.close();
            }
        }
        finally {
            this.realConnection = null;
            this.isActive = false;
            this.eventListener = null;
        }
    }

    @Override
    public final synchronized void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (!this.isActive) {
            return;
        }
        if (connectionEventListener == null) {
            return;
        }
        if (this.eventListener == null) {
            this.eventListener = new ArrayList();
        } else if (this.eventIterators > 0) {
            this.eventListener = new ArrayList<ConnectionEventListener>(this.eventListener);
        }
        this.eventListener.add(connectionEventListener);
    }

    @Override
    public final synchronized void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (connectionEventListener == null || this.eventListener == null) {
            return;
        }
        if (this.eventIterators > 0) {
            this.eventListener = new ArrayList<ConnectionEventListener>(this.eventListener);
        }
        this.eventListener.remove(connectionEventListener);
    }

    @Override
    public synchronized EngineConnection getRealConnection() throws SQLException {
        this.checkActive();
        return this.realConnection;
    }

    public synchronized LanguageConnectionContext getLanguageConnection() throws SQLException {
        this.checkActive();
        return this.realConnection.getLanguageConnection();
    }

    public synchronized void notifyError(SQLException sQLException) {
        if (sQLException.getErrorCode() < 40000) {
            return;
        }
        this.fireConnectionEventListeners(sQLException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireConnectionEventListeners(SQLException sQLException) {
        if (this.eventListener != null && !this.eventListener.isEmpty()) {
            ConnectionEvent connectionEvent = new ConnectionEvent(this, sQLException);
            ++this.eventIterators;
            try {
                for (ConnectionEventListener connectionEventListener : this.eventListener) {
                    if (sQLException == null) {
                        connectionEventListener.connectionClosed(connectionEvent);
                        continue;
                    }
                    connectionEventListener.connectionErrorOccurred(connectionEvent);
                }
            }
            finally {
                --this.eventIterators;
            }
        }
    }

    final void checkActive() throws SQLException {
        if (!this.isActive) {
            throw Util.noCurrentConnection();
        }
    }

    @Override
    public boolean isIsolationLevelSetUsingSQLorJDBC() throws SQLException {
        if (this.realConnection != null) {
            return EmbedPooledConnection.getLanguageConnectionContext(this.realConnection).isIsolationLevelSetUsingSQLorJDBC();
        }
        return false;
    }

    @Override
    public void resetIsolationLevelFlag() throws SQLException {
        EmbedPooledConnection.getLanguageConnectionContext(this.realConnection).resetIsolationLevelFlagUsedForSQLandJDBC();
    }

    @Override
    public boolean isInGlobalTransaction() {
        return false;
    }

    @Override
    public void notifyException(SQLException sQLException) {
        this.notifyError(sQLException);
    }

    @Override
    public void checkAutoCommit(boolean bl) throws SQLException {
    }

    @Override
    public int checkHoldCursors(int n, boolean bl) throws SQLException {
        return n;
    }

    @Override
    public void checkSavepoint() throws SQLException {
    }

    @Override
    public void checkRollback() throws SQLException {
    }

    @Override
    public void checkCommit() throws SQLException {
    }

    @Override
    public void checkClose() throws SQLException {
        if (this.realConnection != null) {
            this.realConnection.checkForTransactionInProgress();
        }
    }

    @Override
    public synchronized boolean closingConnection() throws SQLException {
        this.currentConnectionHandle = null;
        this.fireConnectionEventListeners(null);
        return false;
    }

    @Override
    public Statement wrapStatement(Statement statement) throws SQLException {
        return statement;
    }

    @Override
    public PreparedStatement wrapStatement(PreparedStatement preparedStatement, String string, Object object) throws SQLException {
        EmbedPreparedStatement embedPreparedStatement = (EmbedPreparedStatement)preparedStatement;
        embedPreparedStatement.setBrokeredConnectionControl(this);
        return embedPreparedStatement;
    }

    @Override
    public CallableStatement wrapStatement(CallableStatement callableStatement, String string) throws SQLException {
        EmbedCallableStatement embedCallableStatement = (EmbedCallableStatement)callableStatement;
        embedCallableStatement.setBrokeredConnectionControl(this);
        return embedCallableStatement;
    }

    public String toString() {
        if (this.connString == null) {
            String string = this.isActive ? this.realConnection.toString() : "<none>";
            this.connString = this.getClass().getName() + "@" + this.hashCode() + " Physical Connection = " + string;
        }
        return this.connString;
    }

    @Override
    public void onStatementClose(PreparedStatement preparedStatement) {
        if (!this.statementEventListeners.isEmpty()) {
            StatementEvent statementEvent = new StatementEvent(this, preparedStatement);
            for (StatementEventListener statementEventListener : this.statementEventListeners) {
                statementEventListener.statementClosed(statementEvent);
            }
        }
    }

    @Override
    public void onStatementErrorOccurred(PreparedStatement preparedStatement, SQLException sQLException) {
        if (!this.statementEventListeners.isEmpty()) {
            StatementEvent statementEvent = new StatementEvent(this, preparedStatement, sQLException);
            for (StatementEventListener statementEventListener : this.statementEventListeners) {
                statementEventListener.statementErrorOccurred(statementEvent);
            }
        }
    }

    @Override
    public void removeStatementEventListener(StatementEventListener statementEventListener) {
        if (statementEventListener != null) {
            this.statementEventListeners.remove(statementEventListener);
        }
    }

    @Override
    public void addStatementEventListener(StatementEventListener statementEventListener) {
        if (this.isActive && statementEventListener != null) {
            this.statementEventListeners.add(statementEventListener);
        }
    }

    private static LanguageConnectionContext getLanguageConnectionContext(final EmbedConnection embedConnection) {
        return AccessController.doPrivileged(new PrivilegedAction<LanguageConnectionContext>(){

            @Override
            public LanguageConnectionContext run() {
                return embedConnection.getLanguageConnection();
            }
        });
    }
}

