/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.license.service;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.license.License;
import com.xebialabs.license.LicenseCiCounter;
import com.xebialabs.license.LicenseViolationException;
import com.xebialabs.license.service.DefaultLicenseCiCounterFactory;
import com.xebialabs.license.service.LicenseCiCounterFactory;
import com.xebialabs.license.service.LicenseService;
import com.xebialabs.license.service.LicenseTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseLicenseService
implements LicenseService {
    private static final Logger log = LoggerFactory.getLogger(BaseLicenseService.class);
    protected LicenseCiCounter ciCounter;
    protected LicenseCiCounterFactory ciCounterFactory = new DefaultLicenseCiCounterFactory();

    public void initialize(LicenseCiCounterFactory ciCounterFactory, License license) {
        this.ciCounterFactory = ciCounterFactory;
        this.reLoadCiCounter(license);
    }

    public LicenseCiCounter getCounter() {
        if (this.ciCounter == null) {
            throw new IllegalStateException("ciCounter is null. Did you forget to initialize the license server?");
        }
        return this.ciCounter;
    }

    protected void reLoadCiCounter(License license) {
        log.debug("Loading license CI counter using current license.");
        this.ciCounter = this.ciCounterFactory.create(license);
        log.debug("License CI counter loaded and contains {} restricted CIs.", (Object)this.ciCounter.restrictedTypes().size());
    }

    public LicenseTransaction startTransaction() {
        return new LicenseTransaction();
    }

    public void rollbackTransaction(LicenseTransaction transaction) {
        for (Type type : transaction.getCiCountTypes()) {
            this.ciCounter.rollbackTransaction(type, transaction);
        }
    }

    public void validate() throws LicenseViolationException {
        this.ciCounter.validate();
    }

    public void validate(License license) throws LicenseViolationException {
        LicenseCiCounter tmpCiCounter = this.ciCounterFactory.create(license);
        tmpCiCounter.validate();
    }
}

