/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.spi.core.remoting.ssl;

import java.util.ServiceLoader;
import org.apache.activemq.artemis.spi.core.remoting.ssl.OpenSSLContextFactory;

public class OpenSSLContextFactoryProvider {
    private static final OpenSSLContextFactory FACTORY;

    public static OpenSSLContextFactory getOpenSSLContextFactory() {
        return FACTORY;
    }

    static {
        OpenSSLContextFactory factoryWithHighestPrio = null;
        for (OpenSSLContextFactory factory : ServiceLoader.load(OpenSSLContextFactory.class)) {
            if (factoryWithHighestPrio != null && factory.getPriority() <= factoryWithHighestPrio.getPriority()) continue;
            factoryWithHighestPrio = factory;
        }
        if (factoryWithHighestPrio == null) {
            throw new IllegalStateException("No OpenSSLContextFactory registered!");
        }
        FACTORY = factoryWithHighestPrio;
    }
}

