/*
 * Decompiled with CFR 0.152.
 */
package akka.util;

import akka.annotation.InternalApi;
import akka.util.DoubleLinkedList;
import akka.util.OptionVal;
import akka.util.OptionVal$;
import akka.util.OptionVal$Some$;
import akka.util.RecencyList$;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.Predef;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005xA\u0002\u00180\u0011\u0003\t4G\u0002\u00046_!\u0005\u0011G\u000e\u0005\u0006{\u0005!\ta\u0010\u0005\u0006\u0001\u0006!\t!\u0011\u0004\u0005_\u00061\u0001\u000f\u0003\u0005s\t\t\u0015\r\u0011\"\u0001t\u0011!1HA!A!\u0002\u0013!\b\"B\u001f\u0005\t\u00039\bbB>\u0005\u0001\u0004%\t\u0001 \u0005\n\u0003\u0003!\u0001\u0019!C\u0001\u0003\u0007Aq!a\u0004\u0005A\u0003&Q\u0010\u0003\u0005\u0002\u0012\u0011\u0001\r\u0011\"\u0001}\u0011%\t\u0019\u0002\u0002a\u0001\n\u0003\t)\u0002C\u0004\u0002\u001a\u0011\u0001\u000b\u0015B?\t\u0013\u0005mA\u00011A\u0005\u0002\u0005u\u0001\"CA\u0010\t\u0001\u0007I\u0011AA\u0011\u0011\u001d\t)\u0003\u0002Q!\n53q!S\u0001\u0011\u0002G\u0005!\nC\u0003L#\u0019\u0005A\nC\u0003Q#\u0019\u0005\u0011K\u0002\u0004\u0002P\u0006\u0011\u0011\u0011\u001b\u0005\u0007{Q!\t!!6\t\u000b-#B\u0011\t'\t\rA#B\u0011IAm\r\u0015)tFA\u0019E\u0011!1\u0005D!A!\u0002\u00139\u0005\"B\u001f\u0019\t\u0003Y\u0006bB5\u0019\u0005\u0004%IA\u001b\u0005\b\u0003OA\u0002\u0015!\u0003l\u0011%\tI\u0003\u0007b\u0001\n\u0013\tY\u0003\u0003\u0005\u0002>a\u0001\u000b\u0011BA\u0017\u0011\u001d\ty\u0004\u0007C\u0001\u0003\u0003Bq!!\u0013\u0019\t\u0003\tY\u0005C\u0004\u0002Pa!\t!!\u0015\t\u000f\u0005U\u0003\u0004\"\u0001\u0002X!9\u0011\u0011\r\r\u0005\u0002\u0005\r\u0004bBA?1\u0011\u0005\u00111\r\u0005\b\u0003\u007fBB\u0011AAA\u0011\u001d\ty\b\u0007C\u0001\u0003'Cq!a \u0019\t\u0003\tY\nC\u0004\u0002\u001eb!\t!a(\t\u000f\u0005u\u0005\u0004\"\u0001\u0002$\"9\u0011Q\u0014\r\u0005\u0002\u0005m\u0005bBAU1\u0011\u0005\u00111\u0016\u0005\b\u0003_CB\u0011AAY\u0011\u001d\t)\f\u0007C\u0005\u0003o\u000b1BU3dK:\u001c\u0017\u0010T5ti*\u0011\u0001'M\u0001\u0005kRLGNC\u00013\u0003\u0011\t7n[1\u0011\u0005Q\nQ\"A\u0018\u0003\u0017I+7-\u001a8ds2K7\u000f^\n\u0003\u0003]\u0002\"\u0001O\u001e\u000e\u0003eR\u0011AO\u0001\u0006g\u000e\fG.Y\u0005\u0003ye\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$hh\u0001\u0001\u0015\u0003M\nQ!Z7qif,2AQAg+\u0005\u0019\u0005\u0003\u0002\u001b\u0019\u0003\u0017,\"!R0\u0014\u0005a9\u0014!B2m_\u000e\\\u0007C\u0001%\u0012\u001d\t!\u0004AA\u0003DY>\u001c7n\u0005\u0002\u0012o\u0005Y1-\u001e:sK:$H+[7f)\u0005i\u0005C\u0001\u001dO\u0013\ty\u0015H\u0001\u0003M_:<\u0017aC3be2LWM\u001d+j[\u0016$\"!\u0014*\t\u000bM\u001b\u0002\u0019\u0001+\u0002\u0011\u0011,(/\u0019;j_:\u0004\"!V-\u000e\u0003YS!aU,\u000b\u0005aK\u0014AC2p]\u000e,(O]3oi&\u0011!L\u0016\u0002\u000f\r&t\u0017\u000e^3EkJ\fG/[8o)\ta\u0006\u000eE\u000251u\u0003\"AX0\r\u0001\u0011)\u0001\r\u0007b\u0001C\n\t\u0011)\u0005\u0002cKB\u0011\u0001hY\u0005\u0003If\u0012qAT8uQ&tw\r\u0005\u00029M&\u0011q-\u000f\u0002\u0004\u0003:L\b\"\u0002$\u001b\u0001\u00049\u0015a\u0002:fG\u0016t7-_\u000b\u0002WB\u0019A\u0007\u001c8\n\u00055|#\u0001\u0005#pk\ndW\rT5oW\u0016$G*[:u!\rAE!\u0018\u0002\u0005\u001d>$W-\u0006\u0002rkN\u0011AaN\u0001\u0006m\u0006dW/Z\u000b\u0002iB\u0011a,\u001e\u0003\u0006A\u0012\u0011\r!Y\u0001\u0007m\u0006dW/\u001a\u0011\u0015\u0005aT\bcA=\u0005i6\t\u0011\u0001C\u0003s\u000f\u0001\u0007A/\u0001\u0006mKN\u001c(+Z2f]R,\u0012! \t\u0004iyD\u0018BA@0\u0005%y\u0005\u000f^5p]Z\u000bG.\u0001\bmKN\u001c(+Z2f]R|F%Z9\u0015\t\u0005\u0015\u00111\u0002\t\u0004q\u0005\u001d\u0011bAA\u0005s\t!QK\\5u\u0011!\ti!CA\u0001\u0002\u0004i\u0018a\u0001=%c\u0005YA.Z:t%\u0016\u001cWM\u001c;!\u0003)iwN]3SK\u000e,g\u000e^\u0001\u000f[>\u0014XMU3dK:$x\fJ3r)\u0011\t)!a\u0006\t\u0011\u00055A\"!AA\u0002u\f1\"\\8sKJ+7-\u001a8uA\u0005IA/[7fgR\fW\u000e]\u000b\u0002\u001b\u0006iA/[7fgR\fW\u000e]0%KF$B!!\u0002\u0002$!A\u0011QB\b\u0002\u0002\u0003\u0007Q*\u0001\u0006uS6,7\u000f^1na\u0002\n\u0001B]3dK:\u001c\u0017\u0010I\u0001\u000bY>|7.\u001e9O_\u0012,WCAA\u0017!\u0019\ty#!\u000f^]6\u0011\u0011\u0011\u0007\u0006\u0005\u0003g\t)$A\u0004nkR\f'\r\\3\u000b\u0007\u0005]\u0012(\u0001\u0006d_2dWm\u0019;j_:LA!a\u000f\u00022\t\u0019Q*\u00199\u0002\u00171|wn[;q\u001d>$W\rI\u0001\u0005g&TX-\u0006\u0002\u0002DA\u0019\u0001(!\u0012\n\u0007\u0005\u001d\u0013HA\u0002J]R\fa!\u001e9eCR,Gc\u0001/\u0002N!)!\u000f\ta\u0001;\u00061!/Z7pm\u0016$2\u0001XA*\u0011\u0015\u0011\u0018\u00051\u0001^\u0003!\u0019wN\u001c;bS:\u001cH\u0003BA-\u0003?\u00022\u0001OA.\u0013\r\ti&\u000f\u0002\b\u0005>|G.Z1o\u0011\u0015\u0011(\u00051\u0001^\u0003EaW-Y:u)>lun\u001d;SK\u000e,g\u000e^\u000b\u0003\u0003K\u0002R!a\u001a\u0002xusA!!\u001b\u0002t9!\u00111NA9\u001b\t\tiGC\u0002\u0002py\na\u0001\u0010:p_Rt\u0014\"\u0001\u001e\n\u0007\u0005U\u0014(A\u0004qC\u000e\\\u0017mZ3\n\t\u0005e\u00141\u0010\u0002\t\u0013R,'/\u0019;pe*\u0019\u0011QO\u001d\u0002#5|7\u000f\u001e+p\u0019\u0016\f7\u000f\u001e*fG\u0016tG/A\tsK6|g/\u001a'fCN$(+Z2f]R$B!a!\u0002\u0010B)\u0011QQAF;6\u0011\u0011q\u0011\u0006\u0005\u0003\u0013\u000b)$A\u0005j[6,H/\u00192mK&!\u0011QRAD\u0005\r\u0019V-\u001d\u0005\b\u0003#+\u0003\u0019AA\"\u0003\u0005qGCBAB\u0003+\u000b9\nC\u0004\u0002\u0012\u001a\u0002\r!a\u0011\t\u000f\u0005ee\u00051\u0001\u0002D\u0005!1o[5q)\t\t\u0019)\u0001\tsK6|g/Z'pgR\u0014VmY3oiR!\u00111QAQ\u0011\u001d\t\t\n\u000ba\u0001\u0003\u0007\"b!a!\u0002&\u0006\u001d\u0006bBAIS\u0001\u0007\u00111\t\u0005\b\u00033K\u0003\u0019AA\"\u0003a\u0011X-\\8wK2+\u0017m\u001d;SK\u000e,g\u000e^(viNLG-\u001a\u000b\u0005\u0003\u0007\u000bi\u000bC\u0003TW\u0001\u0007A+\u0001\fsK6|g/Z'pgR\u0014VmY3oi^KG\u000f[5o)\u0011\t\u0019)a-\t\u000bMc\u0003\u0019\u0001+\u0002\u0015I,Wn\u001c<f\u001d>$W\rF\u0002^\u0003sCa!a/.\u0001\u0004q\u0017\u0001\u00028pI\u0016D3\u0001GA`!\u0011\t\t-a2\u000e\u0005\u0005\r'bAAcc\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005%\u00171\u0019\u0002\f\u0013:$XM\u001d8bY\u0006\u0003\u0018\u000eE\u0002_\u0003\u001b$Q\u0001Y\u0002C\u0002\u0005\u0014\u0011BT1o_\u000ecwnY6\u0014\tQ9\u00141\u001b\t\u0003sF!\"!a6\u0011\u0005e$BcA'\u0002\\\")1k\u0006a\u0001)\"\u001a\u0011!a0)\u0007\u0001\ty\f")
@InternalApi
public final class RecencyList<A> {
    private final Clock clock;
    private final DoubleLinkedList<Node<A>> recency;
    private final Map<A, Node<A>> lookupNode;

    public static <A> RecencyList<A> empty() {
        return RecencyList$.MODULE$.empty();
    }

    private DoubleLinkedList<Node<A>> recency() {
        return this.recency;
    }

    private Map<A, Node<A>> lookupNode() {
        return this.lookupNode;
    }

    public int size() {
        return this.lookupNode().size();
    }

    public RecencyList<A> update(A value) {
        Node node;
        if (this.lookupNode().contains(value)) {
            Node node2 = (Node)this.lookupNode().apply(value);
            node2.timestamp_$eq(this.clock.currentTime());
            node = this.recency().moveToBack(node2);
        } else {
            Node<A> node3 = new Node<A>(value);
            node3.timestamp_$eq(this.clock.currentTime());
            this.recency().append(node3);
            node = this.lookupNode().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(value), node3));
        }
        return this;
    }

    public RecencyList<A> remove(A value) {
        Object object = this.lookupNode().contains(value) ? this.removeNode((Node)this.lookupNode().apply(value)) : BoxedUnit.UNIT;
        return this;
    }

    public boolean contains(A value) {
        return this.lookupNode().contains(value);
    }

    public Iterator<A> leastToMostRecent() {
        return this.recency().forwardIterator().map((Function1 & Serializable)x$3 -> x$3.value());
    }

    public Iterator<A> mostToLeastRecent() {
        return this.recency().backwardIterator().map((Function1 & Serializable)x$4 -> x$4.value());
    }

    public Seq<A> removeLeastRecent(int n) {
        return n == 1 ? this.removeLeastRecent() : this.recency().forwardIterator().take(n).map((Function1 & Serializable)node -> this.removeNode((Node)node)).toList();
    }

    public Seq<A> removeLeastRecent(int n, int skip) {
        return this.recency().forwardIterator().slice(skip, skip + n).map((Function1 & Serializable)node -> this.removeNode((Node)node)).toList();
    }

    public Seq<A> removeLeastRecent() {
        Nil$ nil$;
        Node<A> node = this.recency().getFirst();
        Node<A> node2 = OptionVal$Some$.MODULE$.unapply(node);
        if (!OptionVal$.MODULE$.isEmpty$extension(node2)) {
            Node<A> first = OptionVal$.MODULE$.get$extension(node2);
            nil$ = (Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.removeNode(first)}));
        } else {
            nil$ = package$.MODULE$.Nil();
        }
        return nil$;
    }

    public Seq<A> removeMostRecent(int n) {
        return n == 1 ? this.removeMostRecent() : this.recency().backwardIterator().take(n).map((Function1 & Serializable)node -> this.removeNode((Node)node)).toList();
    }

    public Seq<A> removeMostRecent(int n, int skip) {
        return this.recency().backwardIterator().slice(skip, skip + n).map((Function1 & Serializable)node -> this.removeNode((Node)node)).toList();
    }

    public Seq<A> removeMostRecent() {
        Nil$ nil$;
        Node<A> node = this.recency().getLast();
        Node<A> node2 = OptionVal$Some$.MODULE$.unapply(node);
        if (!OptionVal$.MODULE$.isEmpty$extension(node2)) {
            Node<A> last = OptionVal$.MODULE$.get$extension(node2);
            nil$ = (Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.removeNode(last)}));
        } else {
            nil$ = package$.MODULE$.Nil();
        }
        return nil$;
    }

    public Seq<A> removeLeastRecentOutside(FiniteDuration duration) {
        long min = this.clock.earlierTime(duration);
        return this.recency().forwardIterator().takeWhile((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)RecencyList.$anonfun$removeLeastRecentOutside$1(min, x$5))).map((Function1 & Serializable)node -> this.removeNode((Node)node)).toList();
    }

    public Seq<A> removeMostRecentWithin(FiniteDuration duration) {
        long max = this.clock.earlierTime(duration);
        return this.recency().backwardIterator().takeWhile((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)RecencyList.$anonfun$removeMostRecentWithin$1(max, x$6))).map((Function1 & Serializable)node -> this.removeNode((Node)node)).toList();
    }

    /*
     * WARNING - void declaration
     */
    private A removeNode(Node<A> node) {
        void var2_2;
        A value = node.value();
        this.recency().remove(node);
        this.lookupNode().$minus$eq(value);
        return var2_2;
    }

    public static final /* synthetic */ boolean $anonfun$removeLeastRecentOutside$1(long min$1, Node x$5) {
        return x$5.timestamp() < min$1;
    }

    public static final /* synthetic */ boolean $anonfun$removeMostRecentWithin$1(long max$1, Node x$6) {
        return x$6.timestamp() > max$1;
    }

    public RecencyList(Clock clock) {
        this.clock = clock;
        this.recency = new DoubleLinkedList((Function1 & Serializable)x$1 -> new OptionVal<Node>(x$1.lessRecent()), (Function1 & Serializable)x$2 -> new OptionVal<Node>(x$2.moreRecent()), (Function2 & Serializable)(node, previous) -> {
            node.lessRecent_$eq((Node)((OptionVal)previous).x());
            return BoxedUnit.UNIT;
        }, (Function2 & Serializable)(node, next) -> {
            node.moreRecent_$eq((Node)((OptionVal)next).x());
            return BoxedUnit.UNIT;
        });
        this.lookupNode = (Map)Map$.MODULE$.empty();
    }

    public static interface Clock {
        public long currentTime();

        public long earlierTime(FiniteDuration var1);
    }

    public static final class NanoClock
    implements Clock {
        @Override
        public long currentTime() {
            return System.nanoTime();
        }

        @Override
        public long earlierTime(FiniteDuration duration) {
            return this.currentTime() - duration.toNanos();
        }
    }

    private static final class Node<A> {
        private final A value;
        private Node<A> lessRecent;
        private Node<A> moreRecent;
        private long timestamp;

        public A value() {
            return this.value;
        }

        public Node<A> lessRecent() {
            return this.lessRecent;
        }

        public void lessRecent_$eq(Node<A> x$1) {
            this.lessRecent = x$1;
        }

        public Node<A> moreRecent() {
            return this.moreRecent;
        }

        public void moreRecent_$eq(Node<A> x$1) {
            this.moreRecent = x$1;
        }

        public long timestamp() {
            return this.timestamp;
        }

        public void timestamp_$eq(long x$1) {
            this.timestamp = x$1;
        }

        public Node(A value) {
            this.value = value;
            OptionVal$.MODULE$.None();
            this.lessRecent = null;
            OptionVal$.MODULE$.None();
            this.moreRecent = null;
            this.timestamp = 0L;
        }
    }
}

