/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.app;

import com.nqzero.permit.Permit;
import java.io.IOException;
import java.lang.module.Configuration;
import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReference;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.rzo.yajsw.app.AbstractWrapperJVMMain;
import org.rzo.yajsw.app.WrapperJVMMain;

public class WrapperJVMMain9
extends AbstractWrapperJVMMain {
    public static void main(String[] args) throws IOException, ClassNotFoundException, NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        WrapperJVMMain9.preExecute((String[])args);
        WrapperJVMMain9.executeMain();
        WrapperJVMMain9.postExecute();
    }

    protected static void executeMain() throws ClassNotFoundException, NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        ModuleLayer layer;
        Optional<Module> om;
        if (WRAPPER_MANAGER.getModule() == null) {
            WrapperJVMMain.executeMain();
        }
        if (!(om = (layer = WrapperJVMMain9.getModuleLayer()).findModule(WRAPPER_MANAGER.getModule())).isPresent()) {
            System.out.println("module not found: " + WRAPPER_MANAGER.getModule());
            System.exit(999);
        }
        Module m = om.get();
        String mainClassName = WRAPPER_MANAGER.getMainClassName();
        if (mainClassName == null) {
            Optional<String> oc = om.get().getDescriptor().mainClass();
            if (!oc.isPresent()) {
                System.out.println("no main class for module: " + WRAPPER_MANAGER.getModule());
                System.exit(999);
            } else {
                mainClassName = oc.get();
            }
        }
        Class<?> cls = m.getClassLoader().loadClass(mainClassName);
        Method mainMethod = cls.getMethod("main", String[].class);
        Permit.setAccessible((AccessibleObject)mainMethod);
        Object[] args = WRAPPER_MANAGER.getMainMethodArgs();
        mainMethod.invoke(null, new Object[]{args});
    }

    private static ModuleLayer getModuleLayer() {
        List mpath = WRAPPER_MANAGER.getModulePath();
        Path[] paths = new Path[mpath.size()];
        for (int i = 0; i < mpath.size(); ++i) {
            paths[i] = Path.of((String)mpath.get(i), new String[0]);
            if (paths[i].toFile().exists()) continue;
            System.out.println("WARNING: module path does not exist: " + paths[i]);
        }
        ModuleFinder finder = ModuleFinder.of(paths);
        List<String> modules = finder.findAll().stream().map(ModuleReference::descriptor).map(ModuleDescriptor::name).collect(Collectors.toList());
        Configuration pluginsConfiguration = ModuleLayer.boot().configuration().resolve(finder, ModuleFinder.of(new Path[0]), modules);
        ModuleLayer layer = ModuleLayer.boot().defineModulesWithOneLoader(pluginsConfiguration, ClassLoader.getSystemClassLoader());
        return layer;
    }
}

