/*
 * Decompiled with CFR 0.152.
 */
package org.testng.xml;

import org.testng.TestNGException;
import org.testng.internal.ClassHelper;
import org.testng.internal.reflect.ReflectionRecipes;
import org.testng.xml.CommentDisabledXmlWeaver;
import org.testng.xml.DefaultXmlWeaver;
import org.testng.xml.IWeaveXml;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

final class XmlWeaver {
    private static IWeaveXml instance = null;
    private static final boolean testMode = Boolean.parseBoolean(System.getProperty("testng.testmode"));

    private XmlWeaver() {
    }

    private static IWeaveXml getInstance() {
        if (testMode) {
            return XmlWeaver.attemptDefaultImplementationInstantiation();
        }
        return XmlWeaver.instantiateIfRequired();
    }

    private static IWeaveXml instantiateIfRequired() {
        if (instance != null) {
            return instance;
        }
        instance = XmlWeaver.attemptDefaultImplementationInstantiation();
        if (instance != null) {
            return instance;
        }
        Class<?> clazz = ClassHelper.forName(XmlWeaver.getClassName());
        boolean bl = ReflectionRecipes.isOrImplementsInterface(IWeaveXml.class, clazz);
        if (!bl) {
            String string = "In order for " + XmlWeaver.getClassName() + " to be used by TestNG for generating suite/test xmls, " + XmlWeaver.getClassName() + " needs to implement " + IWeaveXml.class.getName();
            throw new TestNGException(string);
        }
        instance = (IWeaveXml)ClassHelper.newInstance(clazz);
        return instance;
    }

    private static String getClassName() {
        return System.getProperty("testng.xml.weaver", DefaultXmlWeaver.class.getName());
    }

    static String asXml(XmlSuite xmlSuite) {
        return XmlWeaver.getInstance().asXml(xmlSuite);
    }

    static String asXml(XmlTest xmlTest, String string) {
        return XmlWeaver.getInstance().asXml(xmlTest, string);
    }

    private static IWeaveXml attemptDefaultImplementationInstantiation() {
        String string = XmlWeaver.getClassName();
        if (string.equals(DefaultXmlWeaver.class.getName())) {
            return new DefaultXmlWeaver();
        }
        if (string.equals(CommentDisabledXmlWeaver.class.getName())) {
            return new CommentDisabledXmlWeaver();
        }
        return null;
    }
}

