/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.io;

import org.apache.activemq.artemis.core.io.IOCallback;
import org.jboss.logging.Logger;

public class RunnableCallback
implements IOCallback {
    private static final Logger logger = Logger.getLogger(RunnableCallback.class);
    Runnable okCallback;
    Runnable errorCallback;

    public RunnableCallback(Runnable ok, Runnable error) {
        if (ok == null) {
            throw new NullPointerException("ok = null");
        }
        if (ok == null) {
            throw new NullPointerException("error = null");
        }
        this.okCallback = ok;
        this.errorCallback = error;
    }

    public RunnableCallback(Runnable ok) {
        if (ok == null) {
            throw new NullPointerException("ok = null");
        }
        this.okCallback = ok;
        this.errorCallback = ok;
    }

    @Override
    public void done() {
        try {
            this.okCallback.run();
        }
        catch (Throwable e) {
            logger.warn((Object)e.getMessage(), e);
        }
    }

    @Override
    public void onError(int errorCode, String errorMessage) {
        try {
            this.errorCallback.run();
        }
        catch (Throwable e) {
            logger.warn((Object)e.getMessage(), e);
        }
    }
}

