/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.config;

import com.datical.liquibase.ext.checks.config.FileAccessor;
import com.datical.liquibase.ext.checks.config.FileAccessorDTO;
import com.datical.liquibase.ext.checks.config.FileEncoder;
import com.datical.liquibase.ext.checks.config.FileEncoder$FileEncoderDTO;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import liquibase.Scope;
import liquibase.exception.CommandExecutionException;
import liquibase.util.FileUtil;
import liquibase.util.StringUtil;

public class ChecksFileAccessor
implements FileAccessor {
    @Override
    public FileAccessorDTO loadFileContents(String string) {
        File file = new File(string);
        if (!file.exists()) {
            Scope.getCurrentScope().getLog(this.getClass()).info("No configuration file named '" + string + "' found.");
            throw new FileNotFoundException("Check settings configuration file not found.");
        }
        Scope.getCurrentScope().getLog(this.getClass()).info("Check settings configuration file located at '" + file.getAbsolutePath() + "'.");
        string = FileUtil.getContents(file);
        FileAccessorDTO fileAccessorDTO = new FileAccessorDTO();
        new FileAccessorDTO().versioned = FileEncoder.isVersioned(string);
        Object object = FileEncoder.decode(string);
        fileAccessorDTO.contents = ((FileEncoder$FileEncoderDTO)object).contents;
        fileAccessorDTO.encoded = ((FileEncoder$FileEncoderDTO)object).encoded;
        if (fileAccessorDTO.encoded) {
            object = "\nThis backup file will work with Liquibase 4.5.0 users who specify it using the --checks-settings-file argument.";
            file = new File(file.getAbsolutePath() + ".v4.5");
            fileAccessorDTO.warningMessage = ChecksFileAccessor.makeBackup(file, string, (String)object);
        }
        return fileAccessorDTO;
    }

    public static String makeBackup(File file, String string, String string2) {
        return ChecksFileAccessor.makeBackup(file, string, string2, true);
    }

    public static String makeBackup(File object, String string, String string2, boolean bl2) {
        String string3 = ((File)object).getAbsolutePath();
        try {
            FileUtil.write(string, new File(string3));
            object = "The file '" + ((File)object).getAbsolutePath() + "' has been updated so it can be used by your current version of Liquibase, and to simplify resolving merge conflicts in Source Control. No action is required from you. Your original file was backed up as '" + string3 + "'." + (string2 != null ? string2 : "");
            if (bl2) {
                Scope.getCurrentScope().getLog(ChecksFileAccessor.class).warning((String)object);
                Scope.getCurrentScope().getUI().sendMessage("WARNING: ".concat(String.valueOf(object)));
            }
            return object;
        }
        catch (IOException iOException) {
            String string4 = "Error creating backup file '" + string3 + "' " + iOException.getMessage();
            Scope.getCurrentScope().getLog(ChecksFileAccessor.class).warning(string4);
            Scope.getCurrentScope().getUI().sendMessage(string4);
            return null;
        }
    }

    @Override
    public void writeFileContents(String string, String string2) {
        File file = new File(string);
        if (!file.exists()) {
            Scope.getCurrentScope().getLog(this.getClass()).info("No configuration file named '" + string + "' found.");
            file = this.createNewFile(string);
            Scope.getCurrentScope().getLog(this.getClass()).info("Creating new file: " + file.getAbsolutePath());
        }
        Scope.getCurrentScope().getLog(this.getClass()).info("Check settings configuration file located at '" + file.getAbsolutePath() + "'.");
        FileUtil.write("Quality Checks Version: 1.0\nIMPORTANT: DO NOT MODIFY THIS FILE DIRECTLY. UNRECOVERABLE and UNSUPPORTED ERRORS ARE LIKELY IF YOU EDIT THIS FILE DIRECTLY.\nThis file is created and modified by running commands in the Liquibase CLI.\nFor help using quality checks, visit the documentation at https://docs.liquibase.com/quality-checks\n\n-----------------------------------------------------------------------------------------------\n".concat(String.valueOf(string2)), file, false);
    }

    private File createNewFile(String string) {
        File file = new File(string);
        if (!StringUtil.isEmpty(file.getParent())) {
            file.getParentFile().mkdirs();
        }
        try {
            if (file.createNewFile()) {
                Scope.getCurrentScope().getLog(this.getClass()).fine("Existing check settings configuration file not found, it is being created at '" + file.getAbsolutePath() + "'.");
            }
        }
        catch (IOException iOException) {
            throw new CommandExecutionException("Unable to create the file '" + string + "'. Make sure the location is accessible and that files can be created there.", iOException);
        }
        return file;
    }
}

