/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.util;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.rzo.yajsw.util.DaemonThreadFactory;

public class Cycler {
    Executor _executor;
    long _period;
    long _delay;
    Runnable _runnable;
    boolean _started = false;
    boolean _terminated = true;
    Runnable _worker;
    Thread _cyclerThread = null;

    public Cycler(long period, long delay, Executor executor, Runnable runnable) {
        if (runnable == null || executor == null) {
            throw new NullPointerException();
        }
        if (period == 0L) {
            period = Long.MAX_VALUE;
        }
        this._period = this.checkDuration(period, 100L);
        this._delay = this.checkDuration(delay, 0L);
        this._executor = executor;
        this._runnable = runnable;
        this._worker = new Runnable(){

            @Override
            public void run() {
                Cycler.this._cyclerThread = Thread.currentThread();
                Cycler.this._terminated = false;
                if (Cycler.this._started) {
                    try {
                        Thread.sleep(Cycler.this._delay);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                while (Cycler.this._started) {
                    if (Cycler.this._started) {
                        try {
                            Cycler.this._runnable.run();
                        }
                        catch (Throwable ex) {
                            ex.printStackTrace();
                        }
                    }
                    if (!Cycler.this._started) continue;
                    try {
                        Thread.sleep(Cycler.this._period);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                Cycler.this._terminated = true;
                Cycler.this._cyclerThread = null;
            }
        };
    }

    public synchronized void start() {
        if (this._started) {
            return;
        }
        this._started = true;
        if (this._terminated) {
            this._executor.execute(this._worker);
        }
    }

    public synchronized void stop() {
        this._started = false;
        if (this._cyclerThread != null) {
            this._cyclerThread.interrupt();
        }
    }

    private long checkDuration(long duration, long minValue) {
        long result = duration;
        if (duration % 100L != 0L) {
            result = duration / 100L * 100L;
        }
        if (result <= minValue) {
            result = minValue;
        }
        return result;
    }

    public static void main(String[] args) throws InterruptedException {
        Cycler c = new Cycler(1000L, 0L, Executors.newCachedThreadPool(new DaemonThreadFactory("controller")), new Runnable(){

            @Override
            public void run() {
                System.out.println(System.currentTimeMillis() + " running");
            }
        });
        while (true) {
            c.start();
            Thread.sleep(1500L);
            c.stop();
            System.out.println(System.currentTimeMillis() + " stopped");
        }
    }
}

