/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.read;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commons.util.IntSet;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextFactory;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.util.ByteString;

public class SizeCommand
extends BaseRpcCommand
implements FlagAffectedCommand,
TopologyAffectedCommand {
    public static final byte COMMAND_ID = 61;
    private int topologyId = -1;
    private long flags = 0L;
    private IntSet segments;

    public SizeCommand(ByteString cacheName, IntSet segments, long flags) {
        super(cacheName);
        this.setFlagsBitSet(flags);
        this.segments = segments;
    }

    public SizeCommand(ByteString name) {
        super(name);
    }

    private SizeCommand() {
        super(null);
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitSizeCommand(ctx, this);
    }

    @Override
    public CompletionStage<?> invokeAsync(ComponentRegistry registry) throws Throwable {
        InvocationContextFactory icf = registry.getInvocationContextFactory().running();
        InvocationContext ctx = icf.createRemoteInvocationContextForCommand(this, this.getOrigin());
        AsyncInterceptorChain invoker = registry.getInterceptorChain().running();
        return invoker.invokeAsync(ctx, this);
    }

    @Override
    public VisitableCommand.LoadType loadType() {
        return VisitableCommand.LoadType.DONT_LOAD;
    }

    @Override
    public byte getCommandId() {
        return 61;
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public int getTopologyId() {
        return this.topologyId;
    }

    @Override
    public void setTopologyId(int topologyId) {
        this.topologyId = topologyId;
    }

    @Override
    public long getFlagsBitSet() {
        return this.flags;
    }

    @Override
    public void setFlagsBitSet(long bitSet) {
        this.flags = bitSet;
    }

    public IntSet getSegments() {
        return this.segments;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeLong(this.flags);
        output.writeObject(this.segments);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.setFlagsBitSet(input.readLong());
        this.segments = (IntSet)input.readObject();
    }

    @Override
    public String toString() {
        return "SizeCommand{topologyId=" + this.topologyId + ", flags=" + this.flags + ", segments=" + this.segments + "}";
    }
}

