/*
 * Decompiled with CFR 0.152.
 */
package akka.cluster;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import akka.actor.ActorSelection$;
import akka.actor.Address;
import akka.actor.Cancellable;
import akka.actor.NoSerializationVerificationNeeded;
import akka.actor.SupervisorStrategy;
import akka.annotation.InternalApi;
import akka.cluster.Cluster;
import akka.cluster.Cluster$;
import akka.cluster.ClusterEvent;
import akka.cluster.ClusterHeartbeatReceiver$;
import akka.cluster.ClusterHeartbeatSender;
import akka.cluster.ClusterHeartbeatSender$HeartbeatTick$;
import akka.cluster.ClusterLogClass$;
import akka.cluster.ClusterSettings;
import akka.cluster.CrossDcHeartbeatingState;
import akka.cluster.CrossDcHeartbeatingState$;
import akka.cluster.Member;
import akka.cluster.Member$;
import akka.cluster.UniqueAddress;
import akka.event.ActorWithLogClass;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.remote.FailureDetectorRegistry;
import java.io.Serializable;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.collection.immutable.SortedSet;
import scala.collection.immutable.SortedSet$;
import scala.concurrent.ExecutionContext;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\rEe!B6m\u00011\u0004\b\"B?\u0001\t\u0003y\b\u0002C7\u0001\u0005\u0004%\t!!\u0002\t\u0011\u00055\u0001\u0001)A\u0005\u0003\u000fA\u0011\"a\u0004\u0001\u0005\u0004%\t!!\u0005\t\u0011\u0005e\u0001\u0001)A\u0005\u0003'A\u0011\"a\u0007\u0001\u0005\u0004%I!!\b\t\u0011\u0005%\u0002\u0001)A\u0005\u0003?A\u0011\"a\u000b\u0001\u0001\u0004%\t!!\u0005\t\u0013\u00055\u0002\u00011A\u0005\u0002\u0005=\u0002\u0002CA\u001e\u0001\u0001\u0006K!a\u0005\t\u0013\u0005u\u0002A1A\u0005\u0002\u0005}\u0002\u0002CA'\u0001\u0001\u0006I!!\u0011\t\u0013\u0005=\u0003A1A\u0005\u0002\u0005E\u0003\u0002CA2\u0001\u0001\u0006I!a\u0015\t\u0013\u0005\u0015\u0004A1A\u0005\u0002\u0005\u001d\u0004\u0002CA>\u0001\u0001\u0006I!!\u001b\t\u0013\u0005u\u0004\u00011A\u0005\u0002\u0005}\u0004\"CAD\u0001\u0001\u0007I\u0011AAE\u0011!\ti\t\u0001Q!\n\u0005\u0005\u0005bBAH\u0001\u0011\u0005\u0011\u0011\u0013\u0005\n\u0003C\u0003\u0001\u0019!C\u0001\u0003GC\u0011\"a+\u0001\u0001\u0004%\t!!,\t\u0011\u0005E\u0006\u0001)Q\u0005\u0003KC\u0011\"a-\u0001\u0005\u0004%\t!!.\t\u0011\u0005u\u0006\u0001)A\u0005\u0003oCq!a0\u0001\t\u0003\n\t\rC\u0004\u0002D\u0002!\t%!1\t\u000f\u0005\u0015\u0007\u0001\"\u0001\u0002H\"9\u00111\u001b\u0001\u0005\u0002\u0005U\u0007bBAs\u0001\u0011\u0005\u0011Q\u001b\u0005\b\u0003O\u0004A\u0011AAk\u0011\u001d\tI\u000f\u0001C\u0001\u0003+Dq!a;\u0001\t\u0003\ti\u000fC\u0004\u0003\u0010\u0001!\tA!\u0005\t\u000f\t]\u0001\u0001\"\u0001\u0003\u001a!9!Q\u0004\u0001\u0005\u0002\u0005\u0005\u0007b\u0002B\u0010\u0001\u0011\u0005!\u0011\u0005\u0005\b\u0005[\u0001A\u0011\u0001B\u0018\u0011\u001d\u0011\u0019\u0004\u0001C\u0005\u0005kAqAa\u000e\u0001\t\u0013\t\tm\u0002\u0005\u0003H1D\tA\u001cB%\r\u001dYG\u000e#\u0001o\u0005\u0017Ba! \u0016\u0005\u0002\t5c!\u0003B(UA\u0005\u0019\u0013\u0005B)\r\u0019\u0011IF\u000b\"\u0003\\!1Q0\fC\u0001\u0005kB\u0011Ba\u001f.\u0003\u0003%\tA!\u001e\t\u0013\tuT&!A\u0005B\t}\u0004\"\u0003BI[\u0005\u0005I\u0011\u0001BJ\u0011%\u0011Y*LA\u0001\n\u0003\u0011i\nC\u0005\u0003(6\n\t\u0011\"\u0011\u0003*\"I!qW\u0017\u0002\u0002\u0013\u0005!\u0011\u0018\u0005\n\u0005{k\u0013\u0011!C!\u0005\u007fC\u0011Ba1.\u0003\u0003%\tE!2\t\u0013\t\u001dW&!A\u0005B\t%\u0007\"\u0003Bf[\u0005\u0005I\u0011\tBg\u000f%\u0011\tNKA\u0001\u0012\u0003\u0011\u0019NB\u0005\u0003Z)\n\t\u0011#\u0001\u0003V\"1QP\u000fC\u0001\u0005[D\u0011Ba2;\u0003\u0003%)E!3\t\u0013\t=((!A\u0005\u0002\nU\u0004\"\u0003Byu\u0005\u0005I\u0011\u0011Bz\u0011%\u0011IPOA\u0001\n\u0013\u0011YPB\u0005\u0004\u0004)\u0002\n1%\t\u0004\u0006\u0019I1\u0011\u0002\u0016\u0011\u0002G\u000521\u0002\u0004\u0007\u0007#Q#ia\u0005\t\u0015\r]!I!f\u0001\n\u0003\t\u0019\u000b\u0003\u0006\u0004\u001a\t\u0013\t\u0012)A\u0005\u0003KCa! \"\u0005\u0002\rm\u0001\"\u0003B>\u0005\u0006\u0005I\u0011AB\u0011\u0011%\u0019)CQI\u0001\n\u0003\u00199\u0003C\u0005\u0003~\t\u000b\t\u0011\"\u0011\u0003\u0000!I!\u0011\u0013\"\u0002\u0002\u0013\u0005!1\u0013\u0005\n\u00057\u0013\u0015\u0011!C\u0001\u0007wA\u0011Ba*C\u0003\u0003%\tE!+\t\u0013\t]&)!A\u0005\u0002\r}\u0002\"\u0003B_\u0005\u0006\u0005I\u0011IB\"\u0011%\u0011\u0019MQA\u0001\n\u0003\u0012)\rC\u0005\u0003H\n\u000b\t\u0011\"\u0011\u0003J\"I!1\u001a\"\u0002\u0002\u0013\u00053qI\u0004\n\u0007GR\u0013\u0011!E\u0001\u0007K2\u0011b!\u0005+\u0003\u0003E\taa\u001a\t\ru\u0014F\u0011AB8\u0011%\u00119MUA\u0001\n\u000b\u0012I\rC\u0005\u0003pJ\u000b\t\u0011\"!\u0004r!I!\u0011\u001f*\u0002\u0002\u0013\u00055Q\u000f\u0005\n\u0005s\u0014\u0016\u0011!C\u0005\u0005w4aaa\u0013+\u0005\u000e5\u0003BB?Y\t\u0003\u0019y\u0005C\u0005\u0003|a\u000b\t\u0011\"\u0001\u0004P!I!Q\u0010-\u0002\u0002\u0013\u0005#q\u0010\u0005\n\u0005#C\u0016\u0011!C\u0001\u0005'C\u0011Ba'Y\u0003\u0003%\taa\u0015\t\u0013\t\u001d\u0006,!A\u0005B\t%\u0006\"\u0003B\\1\u0006\u0005I\u0011AB,\u0011%\u0011i\fWA\u0001\n\u0003\u001aY\u0006C\u0005\u0003Db\u000b\t\u0011\"\u0011\u0003F\"I!q\u0019-\u0002\u0002\u0013\u0005#\u0011\u001a\u0005\n\u0005\u0017D\u0016\u0011!C!\u0007?:\u0011ba +\u0003\u0003E\ta!!\u0007\u0013\r-#&!A\t\u0002\r\r\u0005BB?f\t\u0003\u00199\tC\u0005\u0003H\u0016\f\t\u0011\"\u0012\u0003J\"I!q^3\u0002\u0002\u0013\u00055q\n\u0005\n\u0005c,\u0017\u0011!CA\u0007\u0013C\u0011B!?f\u0003\u0003%IAa?\u0003-\r\u0013xn]:EG\"+\u0017M\u001d;cK\u0006$8+\u001a8eKJT!!\u001c8\u0002\u000f\rdWo\u001d;fe*\tq.\u0001\u0003bW.\f7c\u0001\u0001roB\u0011!/^\u0007\u0002g*\tA/A\u0003tG\u0006d\u0017-\u0003\u0002wg\n1\u0011I\\=SK\u001a\u0004\"\u0001_>\u000e\u0003eT!A\u001f8\u0002\u000b\u0005\u001cGo\u001c:\n\u0005qL(!B!di>\u0014\u0018A\u0002\u001fj]&$hh\u0001\u0001\u0015\u0005\u0005\u0005\u0001cAA\u0002\u00015\tA.\u0006\u0002\u0002\bA!\u00111AA\u0005\u0013\r\tY\u0001\u001c\u0002\b\u00072,8\u000f^3s\u0003!\u0019G.^:uKJ\u0004\u0013\u0001\u0005<fe\n|7/\u001a%fCJ$(-Z1u+\t\t\u0019\u0002E\u0002s\u0003+I1!a\u0006t\u0005\u001d\u0011un\u001c7fC:\f\u0011C^3sE>\u001cX\rS3beR\u0014W-\u0019;!\u00035\u0019G.^:uKJdunZ4feV\u0011\u0011q\u0004\t\u0005\u0003C\t)CD\u0002\u0002$\ti\u0011\u0001A\u0005\u0005\u0003O\tIAA\u0007DYV\u001cH/\u001a:M_\u001e<WM]\u0001\u000fG2,8\u000f^3s\u0019><w-\u001a:!\u0003I\t7\r^5wK2LXj\u001c8ji>\u0014\u0018N\\4\u0002-\u0005\u001cG/\u001b<fYfluN\\5u_JLgnZ0%KF$B!!\r\u00028A\u0019!/a\r\n\u0007\u0005U2O\u0001\u0003V]&$\b\"CA\u001d\u0013\u0005\u0005\t\u0019AA\n\u0003\rAH%M\u0001\u0014C\u000e$\u0018N^3ms6{g.\u001b;pe&tw\rI\u0001\u0018SN,\u0005\u0010^3s]\u0006d7\t\\;ti\u0016\u0014X*Z7cKJ,\"!!\u0011\u0011\u000fI\f\u0019%a\u0012\u0002\u0014%\u0019\u0011QI:\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\u0003BA\u0002\u0003\u0013J1!a\u0013m\u0005\u0019iU-\u001c2fe\u0006A\u0012n]#yi\u0016\u0014h.\u00197DYV\u001cH/\u001a:NK6\u0014WM\u001d\u0011\u0002\u001f\r\u0014xn]:EGN+G\u000f^5oON,\"!a\u0015\u0011\t\u0005U\u00131\f\b\u0005\u0003C\t9&\u0003\u0003\u0002Z\u0005%\u0011\u0001C:fiRLgnZ:\n\t\u0005u\u0013q\f\u0002\u001f\u0007J|7o\u001d#d\r\u0006LG.\u001e:f\t\u0016$Xm\u0019;peN+G\u000f^5oONL1!!\u0019m\u0005=\u0019E.^:uKJ\u001cV\r\u001e;j]\u001e\u001c\u0018\u0001E2s_N\u001cHiY*fiRLgnZ:!\u0003Y\u0019'o\\:t\t\u000e4\u0015-\u001b7ve\u0016$U\r^3di>\u0014XCAA5!\u0019\tY'!\u001d\u0002v5\u0011\u0011Q\u000e\u0006\u0004\u0003_r\u0017A\u0002:f[>$X-\u0003\u0003\u0002t\u00055$a\u0006$bS2,(/\u001a#fi\u0016\u001cGo\u001c:SK\u001eL7\u000f\u001e:z!\rA\u0018qO\u0005\u0004\u0003sJ(aB!eIJ,7o]\u0001\u0018GJ|7o\u001d#d\r\u0006LG.\u001e:f\t\u0016$Xm\u0019;pe\u0002\n!b]3rk\u0016t7-\u001a(s+\t\t\t\tE\u0002s\u0003\u0007K1!!\"t\u0005\u0011auN\\4\u0002\u001dM,\u0017/^3oG\u0016t%o\u0018\u0013fcR!\u0011\u0011GAF\u0011%\tIDEA\u0001\u0002\u0004\t\t)A\u0006tKF,XM\\2f\u001dJ\u0004\u0013!\u00048fqRDU-\u0019:u\u0005\u0016\fG\u000f\u0006\u0002\u0002\u0014B!\u0011QSAN\u001d\u0011\t\u0019!a&\n\u0007\u0005eE.\u0001\fDYV\u001cH/\u001a:IK\u0006\u0014HOY3biN+g\u000eZ3s\u0013\u0011\ti*a(\u0003\u0013!+\u0017M\u001d;cK\u0006$(bAAMY\u0006\u0001B-\u0019;b\u0007\u0016tG/\u001a:t'R\fG/Z\u000b\u0003\u0003K\u0003B!a\u0001\u0002(&\u0019\u0011\u0011\u00167\u00031\r\u0013xn]:EG\"+\u0017M\u001d;cK\u0006$\u0018N\\4Ti\u0006$X-\u0001\u000beCR\f7)\u001a8uKJ\u001c8\u000b^1uK~#S-\u001d\u000b\u0005\u0003c\ty\u000bC\u0005\u0002:Y\t\t\u00111\u0001\u0002&\u0006\tB-\u0019;b\u0007\u0016tG/\u001a:t'R\fG/\u001a\u0011\u0002\u001b!,\u0017M\u001d;cK\u0006$H+Y:l+\t\t9\fE\u0002y\u0003sK1!a/z\u0005-\u0019\u0015M\\2fY2\f'\r\\3\u0002\u001d!,\u0017M\u001d;cK\u0006$H+Y:lA\u0005A\u0001O]3Ti\u0006\u0014H\u000f\u0006\u0002\u00022\u0005A\u0001o\\:u'R|\u0007/A\tiK\u0006\u0014HOY3biJ+7-Z5wKJ$B!!3\u0002PB\u0019\u00010a3\n\u0007\u00055\u0017P\u0001\bBGR|'oU3mK\u000e$\u0018n\u001c8\t\u000f\u0005EG\u00041\u0001\u0002v\u00059\u0011\r\u001a3sKN\u001c\u0018a\u0002:fG\u0016Lg/Z\u000b\u0003\u0003/\u0004B!!7\u0002`:\u0019\u00010a7\n\u0007\u0005u\u00170A\u0003BGR|'/\u0003\u0003\u0002b\u0006\r(a\u0002*fG\u0016Lg/\u001a\u0006\u0004\u0003;L\u0018a\u00023pe6\fg\u000e^\u0001\u0007C\u000e$\u0018N^3\u0002\u001b%tGO]8ta\u0016\u001cG/\u001b8h\u0003\u0011Ig.\u001b;\u0015\t\u0005E\u0012q\u001e\u0005\b\u0003c\f\u0003\u0019AAz\u0003!\u0019h.\u00199tQ>$\b\u0003BA{\u0005\u0013qA!a>\u0003\u00069!\u0011\u0011 B\u0002\u001d\u0011\tYP!\u0001\u000e\u0005\u0005u(bAA\u0000}\u00061AH]8pizJ\u0011a\\\u0005\u0003[:L1Aa\u0002m\u00031\u0019E.^:uKJ,e/\u001a8u\u0013\u0011\u0011YA!\u0004\u0003'\r+(O]3oi\u000ecWo\u001d;feN#\u0018\r^3\u000b\u0007\t\u001dA.A\u0005bI\u0012lU-\u001c2feR!\u0011\u0011\u0007B\n\u0011\u001d\u0011)B\ta\u0001\u0003\u000f\n\u0011!\\\u0001\re\u0016lwN^3NK6\u0014WM\u001d\u000b\u0005\u0003c\u0011Y\u0002C\u0004\u0003\u0016\r\u0002\r!a\u0012\u0002\u0013!,\u0017M\u001d;cK\u0006$\u0018\u0001\u00045fCJ$(-Z1u%N\u0004H\u0003BA\u0019\u0005GAqA!\n&\u0001\u0004\u00119#\u0001\u0003ge>l\u0007\u0003BA\u0002\u0005SI1Aa\u000bm\u00055)f.[9vK\u0006#GM]3tg\u0006)BO]5hO\u0016\u0014h)\u001b:ti\"+\u0017M\u001d;cK\u0006$H\u0003BA\u0019\u0005cAqA!\n'\u0001\u0004\u00119#\u0001\u0013tK24\u0017j\u001d*fgB|gn]5cY\u00164uN]\"s_N\u001cHi\u0019%fCJ$(-Z1u)\t\t\u0019\"A\u0013cK\u000e|W.Z!di&4X-\u00134SKN\u0004xN\\:jE2,gi\u001c:IK\u0006\u0014HOY3bi\"\u001a\u0001Aa\u000f\u0011\t\tu\"1I\u0007\u0003\u0005\u007fQ1A!\u0011o\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005\u000b\u0012yDA\u0006J]R,'O\\1m\u0003BL\u0017AF\"s_N\u001cHi\u0019%fCJ$(-Z1u'\u0016tG-\u001a:\u0011\u0007\u0005\r!f\u0005\u0002+cR\u0011!\u0011\n\u0002\u0012\u0013:\u001c\b/Z2uS>t7i\\7nC:$7\u0003\u0002\u0017r\u0005'\u00022\u0001\u001fB+\u0013\r\u00119&\u001f\u0002\"\u001d>\u001cVM]5bY&T\u0018\r^5p]Z+'/\u001b4jG\u0006$\u0018n\u001c8OK\u0016$W\r\u001a\u0002\r%\u0016\u0004xN\u001d;Ti\u0006$Xo]\n\u0007[E\u0014iFa\u0019\u0011\u0007I\u0014y&C\u0002\u0003bM\u0014q\u0001\u0015:pIV\u001cG\u000f\u0005\u0003\u0003f\t=d\u0002\u0002B4\u0005WrA!a?\u0003j%\tA/C\u0002\u0003nM\fq\u0001]1dW\u0006<W-\u0003\u0003\u0003r\tM$\u0001D*fe&\fG.\u001b>bE2,'b\u0001B7gR\u0011!q\u000f\t\u0004\u0005sjS\"\u0001\u0016\u0002\t\r|\u0007/_\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\t\u0005\u0005\u0003\u0002BB\u0005\u001bk!A!\"\u000b\t\t\u001d%\u0011R\u0001\u0005Y\u0006twM\u0003\u0002\u0003\f\u0006!!.\u0019<b\u0013\u0011\u0011yI!\"\u0003\rM#(/\u001b8h\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\u0011)\nE\u0002s\u0005/K1A!'t\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u0011yJ!*\u0011\u0007I\u0014\t+C\u0002\u0003$N\u00141!\u00118z\u0011%\tIDMA\u0001\u0002\u0004\u0011)*A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011Y\u000b\u0005\u0004\u0003.\nM&qT\u0007\u0003\u0005_S1A!-t\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005k\u0013yK\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA\n\u0005wC\u0011\"!\u000f5\u0003\u0003\u0005\rAa(\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0005\u0003\u0013\t\rC\u0005\u0002:U\n\t\u00111\u0001\u0003\u0016\u0006A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0003\u0016\u0006AAo\\*ue&tw\r\u0006\u0002\u0003\u0002\u00061Q-];bYN$B!a\u0005\u0003P\"I\u0011\u0011\b\u001d\u0002\u0002\u0003\u0007!qT\u0001\r%\u0016\u0004xN\u001d;Ti\u0006$Xo\u001d\t\u0004\u0005sR4#\u0002\u001e\u0003X\n\r\bC\u0002Bm\u0005?\u00149(\u0004\u0002\u0003\\*\u0019!Q\\:\u0002\u000fI,h\u000e^5nK&!!\u0011\u001dBn\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g\u000e\r\t\u0005\u0005K\u0014Y/\u0004\u0002\u0003h*!!\u0011\u001eBE\u0003\tIw.\u0003\u0003\u0003r\t\u001dHC\u0001Bj\u0003\u0015\t\u0007\u000f\u001d7z\u0003\u001d)h.\u00199qYf$B!a\u0005\u0003v\"I!q\u001f \u0002\u0002\u0003\u0007!qO\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GC\u0001B\u007f!\u0011\u0011\u0019Ia@\n\t\r\u0005!Q\u0011\u0002\u0007\u001f\nTWm\u0019;\u0003\u0019M#\u0018\r^;t%\u0016\u0004xN\u001d;\u0014\t\u0001\u000b(1K\u0015\u0003\u0001\u0006\u0013Q#T8oSR|'/\u001b8h'R\fG/\u001a*fa>\u0014Ho\u0005\u0003Bc\u000e5\u0001c\u0001B=\u0001&\u001a\u0011I\u0011-\u0003!5{g.\u001b;pe&tw-Q2uSZ,7\u0003\u0003\"r\u0007+\u0011iFa\u0019\u0011\u0007\te\u0014)A\u0003ti\u0006$X-\u0001\u0004ti\u0006$X\r\t\u000b\u0005\u0007;\u0019y\u0002E\u0002\u0003z\tCqaa\u0006F\u0001\u0004\t)\u000b\u0006\u0003\u0004\u001e\r\r\u0002\"CB\f\rB\u0005\t\u0019AAS\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"a!\u000b+\t\u0005\u001561F\u0016\u0003\u0007[\u0001Baa\f\u000485\u00111\u0011\u0007\u0006\u0005\u0007g\u0019)$A\u0005v]\u000eDWmY6fI*\u0019!\u0011I:\n\t\re2\u0011\u0007\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,G\u0003\u0002BP\u0007{A\u0011\"!\u000fK\u0003\u0003\u0005\rA!&\u0015\t\u0005M1\u0011\t\u0005\n\u0003sa\u0015\u0011!a\u0001\u0005?#BA!!\u0004F!I\u0011\u0011H'\u0002\u0002\u0003\u0007!Q\u0013\u000b\u0005\u0003'\u0019I\u0005C\u0005\u0002:A\u000b\t\u00111\u0001\u0003 \n\tRj\u001c8ji>\u0014\u0018N\\4E_Jl\u0017M\u001c;\u0014\u0011a\u000b8Q\u0003B/\u0005G\"\"a!\u0015\u0011\u0007\te\u0004\f\u0006\u0003\u0003 \u000eU\u0003\"CA\u001d;\u0006\u0005\t\u0019\u0001BK)\u0011\t\u0019b!\u0017\t\u0013\u0005er,!AA\u0002\t}E\u0003\u0002BA\u0007;B\u0011\"!\u000fa\u0003\u0003\u0005\rA!&\u0015\t\u0005M1\u0011\r\u0005\n\u0003s\u0019\u0017\u0011!a\u0001\u0005?\u000b\u0001#T8oSR|'/\u001b8h\u0003\u000e$\u0018N^3\u0011\u0007\te$kE\u0003S\u0007S\u0012\u0019\u000f\u0005\u0005\u0003Z\u000e-\u0014QUB\u000f\u0013\u0011\u0019iGa7\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0017\u0007\u0006\u0002\u0004fQ!1QDB:\u0011\u001d\u00199\"\u0016a\u0001\u0003K#Baa\u001e\u0004~A)!o!\u001f\u0002&&\u001911P:\u0003\r=\u0003H/[8o\u0011%\u00119PVA\u0001\u0002\u0004\u0019i\"A\tN_:LGo\u001c:j]\u001e$uN]7b]R\u00042A!\u001ff'\u0015)7Q\u0011Br!\u0019\u0011INa8\u0004RQ\u00111\u0011\u0011\u000b\u0005\u0003'\u0019Y\tC\u0005\u0003x&\f\t\u00111\u0001\u0004R!\u001a!Fa\u000f)\u0007%\u0012Y\u0004")
@InternalApi
public class CrossDcHeartbeatSender
implements Actor {
    private final Cluster cluster;
    private final boolean verboseHeartbeat;
    private final Cluster.ClusterLogger clusterLogger;
    private boolean activelyMonitoring;
    private final Function1<Member, Object> isExternalClusterMember;
    private final ClusterSettings.CrossDcFailureDetectorSettings crossDcSettings;
    private final FailureDetectorRegistry<Address> crossDcFailureDetector;
    private long sequenceNr;
    private CrossDcHeartbeatingState dataCentersState;
    private final Cancellable heartbeatTask;
    private ActorContext context;
    private ActorRef self;

    public final ActorRef sender() {
        return Actor.sender$((Actor)this);
    }

    @InternalApi
    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
        Actor.aroundReceive$((Actor)this, receive2, (Object)msg);
    }

    @InternalApi
    public void aroundPreStart() {
        Actor.aroundPreStart$((Actor)this);
    }

    @InternalApi
    public void aroundPostStop() {
        Actor.aroundPostStop$((Actor)this);
    }

    @InternalApi
    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Actor.aroundPreRestart$((Actor)this, (Throwable)reason, message);
    }

    @InternalApi
    public void aroundPostRestart(Throwable reason) {
        Actor.aroundPostRestart$((Actor)this, (Throwable)reason);
    }

    public SupervisorStrategy supervisorStrategy() {
        return Actor.supervisorStrategy$((Actor)this);
    }

    public void preRestart(Throwable reason, Option<Object> message) throws Exception {
        Actor.preRestart$((Actor)this, (Throwable)reason, message);
    }

    public void postRestart(Throwable reason) throws Exception {
        Actor.postRestart$((Actor)this, (Throwable)reason);
    }

    public void unhandled(Object message) {
        Actor.unhandled$((Actor)this, (Object)message);
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    public Cluster cluster() {
        return this.cluster;
    }

    public boolean verboseHeartbeat() {
        return this.verboseHeartbeat;
    }

    private Cluster.ClusterLogger clusterLogger() {
        return this.clusterLogger;
    }

    public boolean activelyMonitoring() {
        return this.activelyMonitoring;
    }

    public void activelyMonitoring_$eq(boolean x$1) {
        this.activelyMonitoring = x$1;
    }

    public Function1<Member, Object> isExternalClusterMember() {
        return this.isExternalClusterMember;
    }

    public ClusterSettings.CrossDcFailureDetectorSettings crossDcSettings() {
        return this.crossDcSettings;
    }

    public FailureDetectorRegistry<Address> crossDcFailureDetector() {
        return this.crossDcFailureDetector;
    }

    public long sequenceNr() {
        return this.sequenceNr;
    }

    public void sequenceNr_$eq(long x$1) {
        this.sequenceNr = x$1;
    }

    public ClusterHeartbeatSender.Heartbeat nextHeartBeat() {
        this.sequenceNr_$eq(this.sequenceNr() + 1L);
        return new ClusterHeartbeatSender.Heartbeat(this.cluster().selfAddress(), this.sequenceNr(), System.nanoTime());
    }

    public CrossDcHeartbeatingState dataCentersState() {
        return this.dataCentersState;
    }

    public void dataCentersState_$eq(CrossDcHeartbeatingState x$1) {
        this.dataCentersState = x$1;
    }

    public Cancellable heartbeatTask() {
        return this.heartbeatTask;
    }

    public void preStart() {
        block0: {
            this.cluster().subscribe(this.self(), (Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{ClusterEvent.MemberEvent.class}));
            if (!this.verboseHeartbeat()) break block0;
            this.clusterLogger().logDebug("Initialized cross-dc heartbeat sender as DORMANT in DC: [{}]", this.cluster().selfDataCenter());
        }
    }

    public void postStop() {
        this.dataCentersState().activeReceivers().foreach((Function1 & Serializable)a -> {
            CrossDcHeartbeatSender.$anonfun$postStop$1(this, a);
            return BoxedUnit.UNIT;
        });
        this.heartbeatTask().cancel();
        this.cluster().unsubscribe(this.self());
    }

    public ActorSelection heartbeatReceiver(Address address) {
        return this.context().actorSelection(ClusterHeartbeatReceiver$.MODULE$.path(address));
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return this.dormant().orElse(this.introspecting());
    }

    public PartialFunction<Object, BoxedUnit> dormant() {
        return new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ CrossDcHeartbeatSender $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof ClusterEvent.CurrentClusterState) {
                    ClusterEvent.CurrentClusterState currentClusterState = (ClusterEvent.CurrentClusterState)A1;
                    this.$outer.init(currentClusterState);
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ClusterEvent.MemberRemoved) {
                    ClusterEvent.MemberRemoved memberRemoved = (ClusterEvent.MemberRemoved)A1;
                    Member m = memberRemoved.member();
                    this.$outer.removeMember(m);
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ClusterEvent.MemberEvent) {
                    ClusterEvent.MemberEvent memberEvent = (ClusterEvent.MemberEvent)A1;
                    this.$outer.addMember(memberEvent.member());
                    object = BoxedUnit.UNIT;
                } else {
                    object = ClusterHeartbeatSender$HeartbeatTick$.MODULE$.equals(A1) ? BoxedUnit.UNIT : function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof ClusterEvent.CurrentClusterState ? true : (object instanceof ClusterEvent.MemberRemoved ? true : (object instanceof ClusterEvent.MemberEvent ? true : ClusterHeartbeatSender$HeartbeatTick$.MODULE$.equals(object)));
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public PartialFunction<Object, BoxedUnit> active() {
        return new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ CrossDcHeartbeatSender $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (ClusterHeartbeatSender$HeartbeatTick$.MODULE$.equals(A1)) {
                    this.$outer.heartbeat();
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ClusterHeartbeatSender.HeartbeatRsp) {
                    ClusterHeartbeatSender.HeartbeatRsp heartbeatRsp = (ClusterHeartbeatSender.HeartbeatRsp)A1;
                    UniqueAddress from = heartbeatRsp.from();
                    this.$outer.heartbeatRsp(from);
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ClusterEvent.MemberRemoved) {
                    ClusterEvent.MemberRemoved memberRemoved = (ClusterEvent.MemberRemoved)A1;
                    Member m = memberRemoved.member();
                    this.$outer.removeMember(m);
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ClusterEvent.MemberEvent) {
                    ClusterEvent.MemberEvent memberEvent = (ClusterEvent.MemberEvent)A1;
                    this.$outer.addMember(memberEvent.member());
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ClusterHeartbeatSender.ExpectedFirstHeartbeat) {
                    ClusterHeartbeatSender.ExpectedFirstHeartbeat expectedFirstHeartbeat = (ClusterHeartbeatSender.ExpectedFirstHeartbeat)A1;
                    UniqueAddress from = expectedFirstHeartbeat.from();
                    this.$outer.triggerFirstHeartbeat(from);
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = ClusterHeartbeatSender$HeartbeatTick$.MODULE$.equals(object) ? true : (object instanceof ClusterHeartbeatSender.HeartbeatRsp ? true : (object instanceof ClusterEvent.MemberRemoved ? true : (object instanceof ClusterEvent.MemberEvent ? true : object instanceof ClusterHeartbeatSender.ExpectedFirstHeartbeat)));
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public PartialFunction<Object, BoxedUnit> introspecting() {
        return new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ CrossDcHeartbeatSender $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof ReportStatus) {
                    this.$outer.sender().$bang((Object)(this.$outer.activelyMonitoring() ? new MonitoringActive(this.$outer.dataCentersState()) : new MonitoringDormant()), this.$outer.self());
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof ReportStatus;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public void init(ClusterEvent.CurrentClusterState snapshot) {
        SortedSet<Member> nodes2 = snapshot.members();
        int nrOfMonitoredNodes = this.crossDcSettings().NrOfMonitoringActors();
        this.dataCentersState_$eq(CrossDcHeartbeatingState$.MODULE$.init(this.cluster().selfDataCenter(), this.crossDcFailureDetector(), nrOfMonitoredNodes, nodes2));
        this.becomeActiveIfResponsibleForHeartbeat();
    }

    public void addMember(Member m) {
        block2: {
            if (!CrossDcHeartbeatingState$.MODULE$.atLeastInUpState(m)) break block2;
            this.dataCentersState_$eq(this.dataCentersState().addMember(m));
            if (this.verboseHeartbeat()) {
                String string = m.dataCenter();
                String string2 = this.cluster().selfDataCenter();
                if (string == null ? string2 != null : !string.equals(string2)) {
                    this.clusterLogger().logDebug("Register member {} for cross DC heartbeat (will only heartbeat if oldest)", m);
                }
            }
            this.becomeActiveIfResponsibleForHeartbeat();
        }
    }

    public void removeMember(Member m) {
        UniqueAddress uniqueAddress = m.uniqueAddress();
        UniqueAddress uniqueAddress2 = this.cluster().selfUniqueAddress();
        if (!(uniqueAddress != null ? !((Object)uniqueAddress).equals(uniqueAddress2) : uniqueAddress2 != null)) {
            this.context().stop(this.self());
        } else {
            this.dataCentersState_$eq(this.dataCentersState().removeMember(m));
            this.becomeActiveIfResponsibleForHeartbeat();
        }
    }

    public void heartbeat() {
        ClusterHeartbeatSender.Heartbeat nextHB = this.nextHeartBeat();
        this.dataCentersState().activeReceivers().foreach((Function1 & Serializable)to -> {
            CrossDcHeartbeatSender.$anonfun$heartbeat$1(this, nextHB, to);
            return BoxedUnit.UNIT;
        });
    }

    public void heartbeatRsp(UniqueAddress from) {
        if (this.verboseHeartbeat()) {
            this.clusterLogger().logDebug("(Cross) Heartbeat response from [{}]", from.address());
        }
        this.dataCentersState_$eq(this.dataCentersState().heartbeatRsp(from));
    }

    public void triggerFirstHeartbeat(UniqueAddress from) {
        block1: {
            if (!this.dataCentersState().activeReceivers().contains((Object)from) || this.crossDcFailureDetector().isMonitoring((Object)from.address())) break block1;
            if (this.verboseHeartbeat()) {
                this.clusterLogger().logDebug("Trigger extra expected (cross) heartbeat from [{}]", from.address());
            }
            this.crossDcFailureDetector().heartbeat((Object)from.address());
        }
    }

    private boolean selfIsResponsibleForCrossDcHeartbeat() {
        int activeDcs = this.dataCentersState().dataCenters().size();
        return activeDcs > 1 ? this.dataCentersState().shouldActivelyMonitorNodes(this.cluster().selfDataCenter(), this.cluster().selfUniqueAddress()) : false;
    }

    private void becomeActiveIfResponsibleForHeartbeat() {
        block1: {
            block0: {
                if (this.activelyMonitoring() || !this.selfIsResponsibleForCrossDcHeartbeat()) break block0;
                this.clusterLogger().logInfo("Cross DC heartbeat becoming ACTIVE on this node (for DC: {}), monitoring other DCs oldest nodes", (Object)this.cluster().selfDataCenter());
                this.activelyMonitoring_$eq(true);
                this.context().become(this.active().orElse(this.introspecting()));
                break block1;
            }
            if (this.activelyMonitoring() || !this.verboseHeartbeat()) break block1;
            this.clusterLogger().logInfo("Remaining DORMANT; others in {} handle heartbeating other DCs", (Object)this.cluster().selfDataCenter());
        }
    }

    public static final /* synthetic */ boolean $anonfun$isExternalClusterMember$1(CrossDcHeartbeatSender $this, Member member) {
        String string = member.dataCenter();
        String string2 = $this.cluster().selfDataCenter();
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ void $anonfun$postStop$1(CrossDcHeartbeatSender $this, UniqueAddress a) {
        $this.crossDcFailureDetector().remove((Object)a.address());
    }

    public static final /* synthetic */ void $anonfun$heartbeat$1(CrossDcHeartbeatSender $this, ClusterHeartbeatSender.Heartbeat nextHB$1, UniqueAddress to) {
        BoxedUnit boxedUnit;
        if ($this.crossDcFailureDetector().isMonitoring((Object)to.address())) {
            if ($this.verboseHeartbeat()) {
                $this.clusterLogger().logDebug("(Cross) Heartbeat to [{}]", to.address());
            }
            boxedUnit = BoxedUnit.UNIT;
        } else {
            if ($this.verboseHeartbeat()) {
                $this.clusterLogger().logDebug("First (Cross) Heartbeat to [{}]", to.address());
            }
            boxedUnit = $this.cluster().scheduler().scheduleOnce($this.crossDcSettings().HeartbeatExpectedResponseAfter(), $this.self(), (Object)new ClusterHeartbeatSender.ExpectedFirstHeartbeat(to), (ExecutionContext)$this.context().dispatcher(), $this.self());
        }
        ActorSelection$.MODULE$.toScala($this.heartbeatReceiver(to.address())).$bang((Object)nextHB$1, $this.self());
    }

    public CrossDcHeartbeatSender() {
        Actor.$init$((Actor)this);
        this.cluster = (Cluster)Cluster$.MODULE$.apply(this.context().system());
        this.verboseHeartbeat = this.cluster().settings().Debug().VerboseHeartbeatLogging();
        this.clusterLogger = new Cluster.ClusterLogger(this.cluster(), Logging$.MODULE$.withMarker(this.context().system(), (Object)new ActorWithLogClass((Actor)this, ClusterLogClass$.MODULE$.ClusterHeartbeat()), LogSource$.MODULE$.fromActorWithLoggerClass()));
        this.activelyMonitoring = false;
        this.isExternalClusterMember = (Function1 & Serializable)member -> BoxesRunTime.boxToBoolean((boolean)CrossDcHeartbeatSender.$anonfun$isExternalClusterMember$1(this, member));
        this.crossDcSettings = this.cluster().settings().MultiDataCenter().CrossDcFailureDetectorSettings();
        this.crossDcFailureDetector = this.cluster().crossDcFailureDetector();
        this.sequenceNr = 0L;
        this.dataCentersState = CrossDcHeartbeatingState$.MODULE$.init(this.cluster().selfDataCenter(), this.crossDcFailureDetector(), this.crossDcSettings().NrOfMonitoringActors(), (SortedSet<Member>)((SortedSet)SortedSet$.MODULE$.empty(Member$.MODULE$.ordering())));
        this.heartbeatTask = this.cluster().scheduler().scheduleWithFixedDelay(this.cluster().settings().PeriodicTasksInitialDelay().max(this.crossDcSettings().HeartbeatInterval()), this.crossDcSettings().HeartbeatInterval(), this.self(), (Object)ClusterHeartbeatSender$HeartbeatTick$.MODULE$, (ExecutionContext)this.context().dispatcher(), this.self());
        Statics.releaseFence();
    }

    public static interface InspectionCommand
    extends NoSerializationVerificationNeeded {
    }

    public static final class MonitoringActive
    implements MonitoringStateReport,
    Product,
    Serializable {
        private final CrossDcHeartbeatingState state;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public CrossDcHeartbeatingState state() {
            return this.state;
        }

        public MonitoringActive copy(CrossDcHeartbeatingState state) {
            return new MonitoringActive(state);
        }

        public CrossDcHeartbeatingState copy$default$1() {
            return this.state();
        }

        public String productPrefix() {
            return "MonitoringActive";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.state();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MonitoringActive;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "state";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MonitoringActive)) return false;
            boolean bl = true;
            if (!bl) return false;
            MonitoringActive monitoringActive = (MonitoringActive)x$1;
            CrossDcHeartbeatingState crossDcHeartbeatingState = this.state();
            CrossDcHeartbeatingState crossDcHeartbeatingState2 = monitoringActive.state();
            if (crossDcHeartbeatingState != null) {
                if (!((Object)crossDcHeartbeatingState).equals(crossDcHeartbeatingState2)) return false;
                return true;
            }
            if (crossDcHeartbeatingState2 == null) return true;
            return false;
        }

        public MonitoringActive(CrossDcHeartbeatingState state) {
            this.state = state;
            Product.$init$((Product)this);
        }
    }

    public static final class MonitoringDormant
    implements MonitoringStateReport,
    Product,
    Serializable {
        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public MonitoringDormant copy() {
            return new MonitoringDormant();
        }

        public String productPrefix() {
            return "MonitoringDormant";
        }

        public int productArity() {
            return 0;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            Object object = Statics.ioobe((int)x$1);
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MonitoringDormant;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            String string = (String)Statics.ioobe((int)x$1);
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            Object object = x$1;
            boolean bl = object instanceof MonitoringDormant;
            return bl;
        }

        public MonitoringDormant() {
            Product.$init$((Product)this);
        }
    }

    public static interface MonitoringStateReport
    extends StatusReport {
    }

    public static final class ReportStatus
    implements Product,
    Serializable {
        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public ReportStatus copy() {
            return new ReportStatus();
        }

        public String productPrefix() {
            return "ReportStatus";
        }

        public int productArity() {
            return 0;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            Object object = Statics.ioobe((int)x$1);
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ReportStatus;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            String string = (String)Statics.ioobe((int)x$1);
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            Object object = x$1;
            boolean bl = object instanceof ReportStatus;
            return bl;
        }

        public ReportStatus() {
            Product.$init$((Product)this);
        }
    }

    public static interface StatusReport
    extends NoSerializationVerificationNeeded {
    }
}

