/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQInvalidBufferException;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.logs.ActiveMQUtilBundle;
import org.apache.activemq.artemis.utils.UTF8Util;

public class BufferHelper {
    public static int sizeOfNullableSimpleString(String str) {
        if (str == null) {
            return 1;
        }
        return 1 + BufferHelper.sizeOfSimpleString(str);
    }

    public static int sizeOfSimpleString(String str) {
        return 4 + str.length() * 2;
    }

    public static void writeAsNullableSimpleString(ActiveMQBuffer buffer, String str) {
        buffer.writeNullableSimpleString(SimpleString.toSimpleString((String)str));
    }

    public static String readNullableSimpleStringAsString(ActiveMQBuffer buffer) {
        SimpleString str = buffer.readNullableSimpleString();
        return str != null ? str.toString() : null;
    }

    public static void writeAsSimpleString(ActiveMQBuffer buffer, String str) {
        buffer.writeSimpleString(new SimpleString(str));
    }

    public static void writeNullableBoolean(ActiveMQBuffer buffer, Boolean value) {
        buffer.writeBoolean(value != null);
        if (value != null) {
            buffer.writeBoolean(value.booleanValue());
        }
    }

    public static int sizeOfNullableBoolean(Boolean value) {
        return 1 + (value != null ? 1 : 0);
    }

    public static Boolean readNullableBoolean(ActiveMQBuffer buffer) {
        boolean isNotNull = buffer.readBoolean();
        if (isNotNull) {
            return buffer.readBoolean();
        }
        return null;
    }

    public static void writeNullableLong(ActiveMQBuffer buffer, Long value) {
        buffer.writeBoolean(value != null);
        if (value != null) {
            buffer.writeLong(value.longValue());
        }
    }

    public static void writeNullableDouble(ActiveMQBuffer buffer, Double value) {
        buffer.writeBoolean(value != null);
        if (value != null) {
            buffer.writeDouble(value.doubleValue());
        }
    }

    public static int sizeOfNullableLong(Long value) {
        return 1 + (value != null ? 8 : 0);
    }

    public static int sizeOfNullableDouble(Double value) {
        return 1 + (value != null ? 8 : 0);
    }

    public static Long readNullableLong(ActiveMQBuffer buffer) {
        boolean isNotNull = buffer.readBoolean();
        if (isNotNull) {
            return buffer.readLong();
        }
        return null;
    }

    public static void writeNullableInteger(ActiveMQBuffer buffer, Integer value) {
        buffer.writeBoolean(value != null);
        if (value != null) {
            buffer.writeInt(value.intValue());
        }
    }

    public static int sizeOfNullableInteger(Integer value) {
        return 1 + (value != null ? 4 : 0);
    }

    public static Integer readNullableInteger(ActiveMQBuffer buffer) {
        boolean isNotNull = buffer.readBoolean();
        if (isNotNull) {
            return buffer.readInt();
        }
        return null;
    }

    public static Double readNullableDouble(ActiveMQBuffer buffer) {
        boolean isNotNull = buffer.readBoolean();
        if (isNotNull) {
            return buffer.readDouble();
        }
        return null;
    }

    public static int sizeOfNullableString(String s) {
        if (s == null) {
            return 1;
        }
        return 1 + BufferHelper.sizeOfString(s);
    }

    public static int sizeOfString(String s) {
        int len = s.length();
        if (len < 9) {
            return 4 + len * 2;
        }
        if (len < 4095) {
            int expectedEncodedUTF8Len = UTF8Util.calculateUTFSize((String)s);
            if (expectedEncodedUTF8Len > 65535) {
                throw ActiveMQUtilBundle.BUNDLE.stringTooLong(Integer.valueOf(len));
            }
            return 6 + expectedEncodedUTF8Len;
        }
        return 4 + BufferHelper.sizeOfSimpleString(s);
    }

    public static byte[] safeReadBytes(ActiveMQBuffer in) {
        int claimedSize = in.readInt();
        if (claimedSize < 0) {
            throw new ActiveMQInvalidBufferException("Payload size cannot be negative");
        }
        int readableBytes = in.readableBytes();
        if (claimedSize > readableBytes) {
            throw new ActiveMQInvalidBufferException("Attempted to read: " + claimedSize + " which exceeds overall readable buffer size of: " + readableBytes);
        }
        byte[] byteBuffer = new byte[claimedSize];
        in.readBytes(byteBuffer);
        return byteBuffer;
    }
}

