/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.ssh;

import java.util.HashSet;
import java.util.List;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.springframework.cloud.config.server.environment.JGitEnvironmentProperties;
import org.springframework.cloud.config.server.environment.MultipleJGitEnvironmentProperties;
import org.springframework.cloud.config.server.ssh.HostKeyAndAlgoBothExist;
import org.springframework.cloud.config.server.ssh.SshPropertyValidator;
import org.springframework.util.StringUtils;

public class HostKeyAndAlgoBothExistValidator
implements ConstraintValidator<HostKeyAndAlgoBothExist, MultipleJGitEnvironmentProperties> {
    private static final String GIT_PROPERTY_PREFIX = "spring.cloud.config.server.git.";
    private final SshPropertyValidator sshPropertyValidator = new SshPropertyValidator();

    public void initialize(HostKeyAndAlgoBothExist constrainAnnotation) {
    }

    public boolean isValid(MultipleJGitEnvironmentProperties sshUriProperties, ConstraintValidatorContext context) {
        HashSet<Boolean> validationResults = new HashSet<Boolean>();
        List<JGitEnvironmentProperties> extractedProperties = this.sshPropertyValidator.extractRepoProperties(sshUriProperties);
        for (JGitEnvironmentProperties extractedProperty : extractedProperties) {
            if (!sshUriProperties.isIgnoreLocalSshSettings() || !SshPropertyValidator.isSshUri(extractedProperty.getUri())) continue;
            validationResults.add(this.isAlgorithmSpecifiedWhenHostKeySet(extractedProperty, context) && this.isHostKeySpecifiedWhenAlgorithmSet(extractedProperty, context));
        }
        return !validationResults.contains(false);
    }

    private boolean isHostKeySpecifiedWhenAlgorithmSet(JGitEnvironmentProperties sshUriProperties, ConstraintValidatorContext context) {
        if (StringUtils.hasText((String)sshUriProperties.getHostKeyAlgorithm()) && !StringUtils.hasText((String)sshUriProperties.getHostKey())) {
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate(String.format("Property '%shostKey' must be set when '%shostKeyAlgorithm' is specified", GIT_PROPERTY_PREFIX, GIT_PROPERTY_PREFIX)).addConstraintViolation();
            return false;
        }
        return true;
    }

    private boolean isAlgorithmSpecifiedWhenHostKeySet(JGitEnvironmentProperties sshUriProperties, ConstraintValidatorContext context) {
        if (StringUtils.hasText((String)sshUriProperties.getHostKey()) && !StringUtils.hasText((String)sshUriProperties.getHostKeyAlgorithm())) {
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate(String.format("Property '%shostKeyAlgorithm' must be set when '%shostKey' is specified", GIT_PROPERTY_PREFIX, GIT_PROPERTY_PREFIX)).addConstraintViolation();
            return false;
        }
        return true;
    }
}

