/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.ntlm.functions;

import com.hierynomus.ntlm.NtlmException;
import com.hierynomus.protocol.commons.Charsets;
import com.hierynomus.security.Cipher;
import com.hierynomus.security.Mac;
import com.hierynomus.security.MessageDigest;
import com.hierynomus.security.SecurityException;
import com.hierynomus.security.SecurityProvider;
import java.nio.charset.Charset;

public class NtlmFunctions {
    public static final Charset UNICODE = Charsets.UTF_16LE;

    private NtlmFunctions() {
    }

    public static byte[] unicode(String string) {
        return string == null ? new byte[]{} : string.getBytes(UNICODE);
    }

    public static String unicode(byte[] bytes) {
        return bytes != null ? new String(bytes, UNICODE) : "";
    }

    public static byte[] oem(String s) {
        return s != null ? s.getBytes(Charset.forName("Cp850")) : new byte[]{};
    }

    public static String oem(byte[] bytes) {
        return bytes != null ? new String(bytes, Charset.forName("Cp850")) : "";
    }

    static byte[] md4(SecurityProvider securityProvider, byte[] m) {
        try {
            MessageDigest md4 = securityProvider.getDigest("MD4");
            md4.update(m);
            return md4.digest();
        }
        catch (SecurityException e) {
            throw new NtlmException(e);
        }
    }

    public static byte[] hmac_md5(SecurityProvider securityProvider, byte[] key, byte[] ... message) {
        try {
            Mac hmacMD5 = securityProvider.getMac("HMACT64");
            hmacMD5.init(key);
            for (byte[] aMessage : message) {
                hmacMD5.update(aMessage);
            }
            return hmacMD5.doFinal();
        }
        catch (SecurityException e) {
            throw new NtlmException(e);
        }
    }

    public static byte[] md5(SecurityProvider securityProvider, byte[] ... message) {
        try {
            MessageDigest md5 = securityProvider.getDigest("MD5");
            for (byte[] aMessage : message) {
                md5.update(aMessage);
            }
            return md5.digest();
        }
        catch (SecurityException e) {
            throw new NtlmException(e);
        }
    }

    public static byte[] rc4k(SecurityProvider securityProvider, byte[] k, byte[] d) throws NtlmException {
        byte[] out = new byte[d.length];
        try {
            Cipher cipher = securityProvider.getCipher("RC4");
            cipher.init(Cipher.CryptMode.ENCRYPT, k);
            int bytes = cipher.update(d, 0, d.length, out, 0);
            cipher.doFinal(out, bytes);
        }
        catch (SecurityException e) {
            throw new NtlmException(e);
        }
        return out;
    }

    private static byte[] setupKey(byte[] key56) {
        byte[] key = new byte[]{(byte)(key56[0] >> 1 & 0xFF), (byte)(((key56[0] & 1) << 6 | (key56[1] & 0xFF) >> 2 & 0xFF) & 0xFF), (byte)(((key56[1] & 3) << 5 | (key56[2] & 0xFF) >> 3 & 0xFF) & 0xFF), (byte)(((key56[2] & 7) << 4 | (key56[3] & 0xFF) >> 4 & 0xFF) & 0xFF), (byte)(((key56[3] & 0xF) << 3 | (key56[4] & 0xFF) >> 5 & 0xFF) & 0xFF), (byte)(((key56[4] & 0x1F) << 2 | (key56[5] & 0xFF) >> 6 & 0xFF) & 0xFF), (byte)(((key56[5] & 0x3F) << 1 | (key56[6] & 0xFF) >> 7 & 0xFF) & 0xFF), (byte)(key56[6] & 0x7F)};
        for (int i = 0; i < key.length; ++i) {
            key[i] = (byte)(key[i] << 1);
        }
        return key;
    }

    static Cipher getDESCipher(SecurityProvider securityProvider, byte[] key) {
        try {
            Cipher cipher = securityProvider.getCipher("DES/ECB/NoPadding");
            cipher.init(Cipher.CryptMode.ENCRYPT, NtlmFunctions.setupKey(key));
            return cipher;
        }
        catch (SecurityException e) {
            throw new NtlmException(e);
        }
    }
}

