/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.deploy.permissions.api.rest.v2.impl;

import ai.digital.deploy.permissions.api.rest.dto.EditRolePermissionsRequest;
import ai.digital.deploy.permissions.api.rest.dto.GetReferencedPermissionsForPrincipalDto;
import ai.digital.deploy.permissions.api.rest.dto.GetReferencedPermissionsForRoleIdDto;
import ai.digital.deploy.permissions.api.rest.dto.GetReferencedPermissionsForRoleIdsDto;
import ai.digital.deploy.permissions.api.rest.dto.GetReferencedPermissionsForRoleNameDto;
import ai.digital.deploy.permissions.api.rest.dto.RoleWithReferencedPermissionsDto;
import ai.digital.deploy.permissions.api.rest.dto.converters.RoleConverter$;
import ai.digital.deploy.permissions.api.rest.dto.converters.RoleWithReferencedPermissionsConverter$;
import ai.digital.deploy.permissions.exception.RoleNameNotFoundException;
import ai.digital.deploy.permissions.model.Role;
import ai.digital.deploy.permissions.rest.dto.validation.IsUuid;
import ai.digital.deploy.permissions.service.ReferencedPermissionService;
import ai.digital.deploy.permissions.service.RoleNameNotFoundServiceException;
import java.io.Serializable;
import java.util.UUID;
import javax.validation.Valid;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@Validated
@RestController
@RequestMapping(value={"/v2/permissions/reference"})
@ScalaSignature(bytes="\u0006\u0005\u0005}f\u0001\u0002\u0006\f\u0001qA\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\u0006U\u0001!\ta\u000b\u0005\u0006_\u0001!\t\u0001\r\u0005\u0006q\u0002!\t!\u001f\u0005\u0007q\u0002!\t!!\f\t\u000f\u0005\r\u0003\u0001\"\u0001\u0002F!9\u0011\u0011\f\u0001\u0005\u0002\u0005m\u0003bBA9\u0001\u0011\u0005\u00111\u000f\u0005\b\u0003\u001f\u0003A\u0011AAI\u0005\u001d*\u0005\u0010^3oI\u0016$'+\u001a4fe\u0016t7-\u001a3QKJl\u0017n]:j_:\u001c8i\u001c8ue>dG.\u001a:\u000b\u00051i\u0011\u0001B5na2T!AD\b\u0002\u0005Y\u0014$B\u0001\t\u0012\u0003\u0011\u0011Xm\u001d;\u000b\u0005I\u0019\u0012aA1qS*\u0011A#F\u0001\fa\u0016\u0014X.[:tS>t7O\u0003\u0002\u0017/\u00051A-\u001a9m_fT!\u0001G\r\u0002\u000f\u0011Lw-\u001b;bY*\t!$\u0001\u0002bS\u000e\u00011C\u0001\u0001\u001e!\tq\u0012%D\u0001 \u0015\u0005\u0001\u0013!B:dC2\f\u0017B\u0001\u0012 \u0005\u0019\te.\u001f*fM\u0006Y\"/\u001a4fe\u0016t7-\u001a3QKJl\u0017n]:j_:\u001cVM\u001d<jG\u0016\u0004\"!\n\u0015\u000e\u0003\u0019R!aJ\n\u0002\u000fM,'O^5dK&\u0011\u0011F\n\u0002\u001c%\u00164WM]3oG\u0016$\u0007+\u001a:nSN\u001c\u0018n\u001c8TKJ4\u0018nY3\u0002\rqJg.\u001b;?)\tac\u0006\u0005\u0002.\u00015\t1\u0002C\u0003$\u0005\u0001\u0007A%A\bfI&$\b+\u001a:nSN\u001c\u0018n\u001c8t)\u0011\tt\u0007X0\u0011\u0005I*T\"A\u001a\u000b\u0005Qz\u0011a\u00013u_&\u0011ag\r\u0002!%>dWmV5uQJ+g-\u001a:f]\u000e,G\rU3s[&\u001c8/[8og\u0012#x\u000eC\u00039\u0007\u0001\u0007\u0011(A\u0006sK\u001a,'/\u001a8dK&#\u0007C\u0001\u001eB\u001d\tYt\b\u0005\u0002=?5\tQH\u0003\u0002?7\u00051AH]8pizJ!\u0001Q\u0010\u0002\rA\u0013X\rZ3g\u0013\t\u00115I\u0001\u0004TiJLgn\u001a\u0006\u0003\u0001~A#aN#\u0011\u0005\u0019\u000bV\"A$\u000b\u0005!K\u0015AC1o]>$\u0018\r^5p]*\u0011!jS\u0001\u0005E&tGM\u0003\u0002M\u001b\u0006\u0019q/\u001a2\u000b\u00059{\u0015aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003A\u000b1a\u001c:h\u0013\t\u0011vI\u0001\u0007QCRDg+\u0019:jC\ndW\r\u000b\u00028)B\u0011QKW\u0007\u0002-*\u0011q\u000bW\u0001\u000bm\u0006d\u0017\u000eZ1uS>t'B\u0001\u001bZ\u0015\t\u00012#\u0003\u0002\\-\n1\u0011j]+vS\u0012DQ!X\u0002A\u0002e\n\u0001B]8mK:\u000bW.\u001a\u0015\u00039\u0016CQ\u0001Y\u0002A\u0002\u0005\f!$\u001a3jiJ{G.\u001a)fe6L7o]5p]N\u0014V-];fgR\u0004\"A\r2\n\u0005\r\u001c$AG#eSR\u0014v\u000e\\3QKJl\u0017n]:j_:\u001c(+Z9vKN$\bFA0f!\t1e-\u0003\u0002h\u000f\nY!+Z9vKN$(i\u001c3zQ\ty\u0016\u000e\u0005\u0002k]6\t1N\u0003\u0002XY*\tQ.A\u0003kCZ\f\u00070\u0003\u0002pW\n)a+\u00197jI\"\"1!\u001d;v!\t1%/\u0003\u0002t\u000f\na\u0001+\u0019;dQ6\u000b\u0007\u000f]5oO\u0006)a/\u00197vK2\na/I\u0001x\u0003ey3P]3gKJ,gnY3JIv|3P]8mK:\u000bW.Z?\u0002)\u001d,GOU3gKJ,gnY3t\r>\u0014(k\u001c7f)\rQ\u00181\u0002\t\u0006w\u0006\u0005\u0011QA\u0007\u0002y*\u0011QP`\u0001\u0005kRLGNC\u0001\u0000\u0003\u0011Q\u0017M^1\n\u0007\u0005\rAPA\u0002TKR\u00042a_A\u0004\u0013\r\tI\u0001 \u0002\u0005+VKE\t\u0003\u00045\t\u0001\u0007\u0011Q\u0002\t\u0004e\u0005=\u0011bAA\tg\t!s)\u001a;SK\u001a,'/\u001a8dK\u0012\u0004VM]7jgNLwN\\:G_J\u0014v\u000e\\3JI\u0012#x\u000eK\u0002\u0002\f%D#\u0002BA\fi\u0006u\u00111EA\u0013!\r1\u0015\u0011D\u0005\u0004\u000379%AC$fi6\u000b\u0007\u000f]5oO2\u0012\u0011qD\u0011\u0003\u0003C\tQa\f:fMN\fa\u0001]1sC6\u001cH\u0006BA\u0014\u0003W\t#!!\u000b\u0002\rI|G.Z%eC\u0005!Bc\u0001>\u00020!1A'\u0002a\u0001\u0003c\u00012AMA\u001a\u0013\r\t)d\r\u0002&\u000f\u0016$(+\u001a4fe\u0016t7-\u001a3QKJl\u0017n]:j_:\u001chi\u001c:S_2,\u0017\nZ:Ei>D3!a\fjQ))\u0011q\u0003;\u0002<\u0005\r\u0012Q\b\u0017\u0003\u0003?aC!a\u0010\u0002,\u0005\u0012\u0011\u0011I\u0001\be>dW-\u00133t\u0003a9W\r\u001e*fM\u0016\u0014XM\\2fg\u001a{'OU8mK:\u000bW.\u001a\u000b\u0004u\u0006\u001d\u0003B\u0002\u001b\u0007\u0001\u0004\tI\u0005E\u00023\u0003\u0017J1!!\u00144\u0005\u0019:U\r\u001e*fM\u0016\u0014XM\\2fIB+'/\\5tg&|gn\u001d$peJ{G.\u001a(b[\u0016$Eo\u001c\u0015\u0004\u0003\u000fJ\u0007F\u0003\u0004\u0002\u0018Q\f\u0019&a\t\u0002V1\u0012\u0011q\u0004\u0017\u0005\u0003/\nY#I\u0001^\u0003e9W\r\u001e*fM\u0016\u0014XM\\2fg\u001a{'\u000f\u0015:j]\u000eL\u0007/\u00197\u0015\u0007i\fi\u0006\u0003\u00045\u000f\u0001\u0007\u0011q\f\t\u0004e\u0005\u0005\u0014bAA2g\t9s)\u001a;SK\u001a,'/\u001a8dK\u0012\u0004VM]7jgNLwN\\:G_J\u0004&/\u001b8dSB\fG\u000e\u0012;pQ\r\ti&\u001b\u0015\u000b\u000f\u0005]A/!\u001b\u0002$\u0005-DFAA\u0010Y\u0011\ti'a\u000b\"\u0005\u0005=\u0014!\u00049sS:\u001c\u0017\u000e]1m\u001d\u0006lW-\u0001\neK2,G/\u001a$peJ+g-\u001a:f]\u000e,G\u0003BA;\u0003w\u00022AHA<\u0013\r\tIh\b\u0002\u0005+:LG\u000fC\u00039\u0011\u0001\u0007\u0011\bK\u0002\u0002|\u0015C3!a\u001fUQ\u0019A\u00111\u0011;\u0002\nB\u0019a)!\"\n\u0007\u0005\u001duIA\u0007EK2,G/Z'baBLgn\u001a\u0017\u0003\u0003\u0017\u000b#!!$\u0002\u001d=Z(/\u001a4fe\u0016t7-Z%e{\u0006IA-\u001a7fi\u0016\fE\u000e\u001c\u000b\u0003\u0003kBc!CABi\u0006UEFAALC\t\tI*\u0001\u00030C2d\u0007F\u0002\u0001\u0002\u001eR\f\u0019\u000bE\u0002G\u0003?K1!!)H\u00059\u0011V-];fgRl\u0015\r\u001d9j]\u001ed#!!*\"\u0005\u0005\u001d\u0016!G\u0018we=\u0002XM]7jgNLwN\\:0e\u00164WM]3oG\u0016D3\u0001AAV!\r1\u0015QV\u0005\u0004\u0003_;%A\u0004*fgR\u001cuN\u001c;s_2dWM\u001d\u0015\u0004\u0001\u0005M\u0006\u0003BA[\u0003wk!!a.\u000b\u0007!\u000bIL\u0003\u0002X\u001b&!\u0011QXA\\\u0005%1\u0016\r\\5eCR,G\r")
public class ExtendedReferencedPermissionsController {
    private final ReferencedPermissionService referencedPermissionService;

    @PatchMapping(value={"/{referenceId}/{roleName}"})
    public RoleWithReferencedPermissionsDto editPermissions(@IsUuid @PathVariable String referenceId, @PathVariable String roleName, @Valid @RequestBody EditRolePermissionsRequest editRolePermissionsRequest) {
        Right right;
        Tuple2 tuple2;
        UUID uuid = UUID.fromString(referenceId);
        Either either = this.referencedPermissionService.edit(uuid, roleName, CollectionConverters$.MODULE$.ListHasAsScala(editRolePermissionsRequest.addedPermissions()).asScala().toList(), CollectionConverters$.MODULE$.ListHasAsScala(editRolePermissionsRequest.removedPermissions()).asScala().toList());
        if (either instanceof Left) {
            Left left = (Left)either;
            RoleNameNotFoundServiceException exception = (RoleNameNotFoundServiceException)left.value();
            throw new RoleNameNotFoundException(exception.name());
        }
        if (either instanceof Right && (tuple2 = (Tuple2)(right = (Right)either).value()) != null) {
            Role role = (Role)tuple2._1();
            List permissions = (List)tuple2._2();
            return new RoleWithReferencedPermissionsDto(RoleConverter$.MODULE$.roleToDto(role), uuid, RoleWithReferencedPermissionsConverter$.MODULE$.permissionToDto(permissions));
        }
        throw new MatchError((Object)either);
    }

    @GetMapping(value={"/refs"}, params={"roleId", "permissions"})
    public java.util.Set<UUID> getReferencesForRole(@Valid GetReferencedPermissionsForRoleIdDto dto) {
        return CollectionConverters$.MODULE$.SetHasAsJava((Set)this.referencedPermissionService.getReferencesForRole(UUID.fromString(dto.roleId()), CollectionConverters$.MODULE$.ListHasAsScala(dto.permissions()).asScala().toList())).asJava();
    }

    @GetMapping(value={"/refs"}, params={"roleIds", "permissions"})
    public java.util.Set<UUID> getReferencesForRole(@Valid GetReferencedPermissionsForRoleIdsDto dto) {
        return CollectionConverters$.MODULE$.SetHasAsJava((Set)this.referencedPermissionService.getReferencesForRoles(((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(dto.roleIds()).asScala().map((Function1 & Serializable)x$1 -> UUID.fromString(x$1))).toList(), CollectionConverters$.MODULE$.ListHasAsScala(dto.permissions()).asScala().toList())).asJava();
    }

    @GetMapping(value={"/refs"}, params={"roleName", "permissions"})
    public java.util.Set<UUID> getReferencesForRoleName(@Valid GetReferencedPermissionsForRoleNameDto dto) {
        return CollectionConverters$.MODULE$.SetHasAsJava((Set)this.referencedPermissionService.getReferencesForRoleName(dto.roleName(), CollectionConverters$.MODULE$.ListHasAsScala(dto.permissions()).asScala().toList())).asJava();
    }

    @GetMapping(value={"/refs"}, params={"principalName", "permissions"})
    public java.util.Set<UUID> getReferencesForPrincipal(@Valid GetReferencedPermissionsForPrincipalDto dto) {
        return CollectionConverters$.MODULE$.SetHasAsJava((Set)this.referencedPermissionService.getReferencesForPrincipalName(dto.principalName(), CollectionConverters$.MODULE$.ListHasAsScala(dto.permissions()).asScala().toList())).asJava();
    }

    @DeleteMapping(value={"/{referenceId}"})
    public void deleteForReference(@IsUuid @PathVariable String referenceId) {
        this.referencedPermissionService.removeForReference(UUID.fromString(referenceId));
    }

    @DeleteMapping(value={"/all"})
    public void deleteAll() {
        this.referencedPermissionService.removeAll();
    }

    public ExtendedReferencedPermissionsController(ReferencedPermissionService referencedPermissionService) {
        this.referencedPermissionService = referencedPermissionService;
    }
}

