/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.asn1;

import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;

public class BERInputStream
extends InputStream {
    private ByteBuffer buffer;

    public BERInputStream(ByteBuffer byteBuffer) {
        this.buffer = byteBuffer;
        byteBuffer.mark();
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public void setBuffer(ByteBuffer byteBuffer) {
        this.buffer = byteBuffer;
    }

    public int read() throws IOException {
        try {
            return this.buffer.get() & 0xFF;
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new IOException("Unexpected end of input stream at position " + this.getPosition());
        }
    }

    public int available() throws IOException {
        return this.buffer.remaining();
    }

    public void close() throws IOException {
    }

    public synchronized void mark(int n) {
        this.buffer.mark();
    }

    public boolean markSupported() {
        return true;
    }

    public int read(byte[] byArray) throws IOException {
        if (this.buffer.remaining() <= 0) {
            return -1;
        }
        int n = Math.min(this.buffer.remaining(), byArray.length);
        this.buffer.get(byArray, 0, n);
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.buffer.remaining() <= 0) {
            return -1;
        }
        int n3 = Math.min(this.buffer.remaining(), byArray.length);
        this.buffer.get(byArray, n, n2);
        return n3;
    }

    public synchronized void reset() throws IOException {
        this.buffer.reset();
    }

    public long skip(long l) throws IOException {
        long l2 = Math.min((long)this.buffer.remaining(), l);
        this.buffer.position((int)((long)this.buffer.position() + l2));
        return l2;
    }

    public long getPosition() {
        return this.buffer.position();
    }

    public boolean isMarked() {
        return true;
    }

    public int getAvailableBytes() {
        return this.buffer.limit();
    }
}

