/*
 * Decompiled with CFR 0.152.
 */
package akka.remote.artery.aeron;

import akka.Done;
import akka.Done$;
import akka.actor.Address;
import akka.actor.Cancellable;
import akka.actor.ExtendedActorSystem;
import akka.dispatch.MessageDispatcher;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.remote.RemoteActorRefProvider;
import akka.remote.RemoteTransportException;
import akka.remote.artery.ArteryTransport;
import akka.remote.artery.ArteryTransport$;
import akka.remote.artery.ArteryTransport$ShuttingDown$;
import akka.remote.artery.Decoder;
import akka.remote.artery.DuplicateFlush;
import akka.remote.artery.DuplicateHandshakeReq;
import akka.remote.artery.EnvelopeBuffer;
import akka.remote.artery.EnvelopeBufferPool;
import akka.remote.artery.FixedSizePartitionHub;
import akka.remote.artery.InboundControlJunction;
import akka.remote.artery.InboundEnvelope;
import akka.remote.artery.OutboundContext;
import akka.remote.artery.aeron.AeronErrorLog;
import akka.remote.artery.aeron.AeronSink;
import akka.remote.artery.aeron.AeronSource;
import akka.remote.artery.aeron.ArteryAeronUdpTransport$;
import akka.remote.artery.aeron.TaskRunner;
import akka.remote.artery.aeron.TaskRunner$;
import akka.remote.artery.compress.NoInboundCompressions$;
import akka.stream.Graph;
import akka.stream.KillSwitches$;
import akka.stream.SharedKillSwitch;
import akka.stream.scaladsl.Flow$;
import akka.stream.scaladsl.Keep$;
import akka.stream.scaladsl.Sink;
import akka.stream.scaladsl.Sink$;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import io.aeron.Aeron;
import io.aeron.AvailableImageHandler;
import io.aeron.CommonContext;
import io.aeron.Image;
import io.aeron.UnavailableImageHandler;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.ThreadingMode;
import io.aeron.exceptions.ConductorServiceTimeoutException;
import io.aeron.exceptions.DriverTimeoutException;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.nio.channels.DatagramChannel;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.IoUtil;
import org.agrona.concurrent.BackoffIdleStrategy;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.status.CountersReader;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.BuildFrom$;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnce;
import scala.collection.MapOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.concurrent.Await$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u00055h!\u0002\u0011\"\u0001\u0015J\u0003\"\u0003\u0018\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u00197\u0011%Q\u0004A!A!\u0002\u0013Yt\bC\u0003B\u0001\u0011\u0005!)\u0002\u0003H\u0001\u0001B\u0005BB(\u0001A\u0003%\u0001\u000bC\u0005#\u0001\u0001\u0007\t\u0011)Q\u0005W\"I1\u000f\u0001a\u0001\u0002\u0003\u0006K\u0001\u001e\u0005\nq\u0002\u0001\r\u0011!Q!\nQD\u0011B\u001f\u0001A\u0002\u0003\u0005\u000b\u0015B>\t\u0011}\u0004!\u0019!C\u0005\u0003\u0003A\u0001\"!\u0003\u0001A\u0003%\u00111\u0001\u0005\b\u0003\u0017\u0001A\u0011BA\u0007\u0011\u001d\ty\u0003\u0001C)\u0003cAq!!\u000f\u0001\t\u0013\t\t\u0004C\u0004\u0002<\u0001!I!!\u0010\t\u000f\u0005}\u0002\u0001\"\u0003\u00022!9\u0011\u0011\t\u0001\u0005\n\u0005E\u0002bBA\"\u0001\u0011%\u0011\u0011\u0007\u0005\b\u0003\u000b\u0002A\u0011BA\u0019\u0011\u001d\t9\u0005\u0001C\u0005\u0003cAq!!\u0013\u0001\t#\nY\u0005C\u0004\u0002\u0014\u0002!I!!&\t\u000f\u0005\u001d\u0006\u0001\"\u0003\u0002*\"9\u00111\u0016\u0001\u0005R\u00055\u0006bBA[\u0001\u0011E\u0013q\u0017\u0005\b\u0003\u0003\u0004A\u0011BAb\u0011\u001d\t9\r\u0001C\u0005\u0003\u0013Dq!!4\u0001\t\u0013\ty\rC\u0004\u0002T\u0002!I!!6\t\u000f\u0005\u0005\b\u0001\"\u0015\u0002d\"9\u0011Q\u001d\u0001\u0005\u0002\u0005\u001d(aF!si\u0016\u0014\u00180Q3s_:,F\r\u001d+sC:\u001c\bo\u001c:u\u0015\t\u00113%A\u0003bKJ|gN\u0003\u0002%K\u00051\u0011M\u001d;fefT!AJ\u0014\u0002\rI,Wn\u001c;f\u0015\u0005A\u0013\u0001B1lW\u0006\u001c\"\u0001\u0001\u0016\u0011\u0005-bS\"A\u0012\n\u00055\u001a#aD!si\u0016\u0014\u0018\u0010\u0016:b]N\u0004xN\u001d;\u0002\u000f}\u001b\u0018p\u001d;f[\u000e\u0001\u0001CA\u00195\u001b\u0005\u0011$BA\u001a(\u0003\u0015\t7\r^8s\u0013\t)$GA\nFqR,g\u000eZ3e\u0003\u000e$xN]*zgR,W.\u0003\u00028q\u000511/_:uK6L!!O\u0013\u0003\u001fI+Wn\u001c;f)J\fgn\u001d9peR\f\u0011b\u00189s_ZLG-\u001a:\u0011\u0005qjT\"A\u0013\n\u0005y*#A\u0006*f[>$X-Q2u_J\u0014VM\u001a)s_ZLG-\u001a:\n\u0005\u0001C\u0014\u0001\u00039s_ZLG-\u001a:\u0002\rqJg.\u001b;?)\r\u0019UI\u0012\t\u0003\t\u0002i\u0011!\t\u0005\u0006]\r\u0001\r\u0001\r\u0005\u0006u\r\u0001\ra\u000f\u0002\n\u0019&4WmQ=dY\u0016\u0004\"!\u0013'\u000f\u0005\u0011S\u0015BA&\"\u0003-\tUM]8o'>,(oY3\n\u00055s%AD!fe>tG*\u001b4fGf\u001cG.\u001a\u0006\u0003\u0017\u0006\n1\"\\3eS\u0006$%/\u001b<feB\u0019\u0011K\u0017/\u000e\u0003IS!a\u0015+\u0002\r\u0005$x.\\5d\u0015\t)f+\u0001\u0006d_:\u001cWO\u001d:f]RT!a\u0016-\u0002\tU$\u0018\u000e\u001c\u0006\u00023\u0006!!.\u0019<b\u0013\tY&KA\bBi>l\u0017n\u0019*fM\u0016\u0014XM\\2f!\ri\u0006MY\u0007\u0002=*\tq,A\u0003tG\u0006d\u0017-\u0003\u0002b=\n1q\n\u001d;j_:\u0004\"aY5\u000e\u0003\u0011T!!\u001a4\u0002\r\u0011\u0014\u0018N^3s\u0015\t\u0011sMC\u0001i\u0003\tIw.\u0003\u0002kI\nYQ*\u001a3jC\u0012\u0013\u0018N^3s!\taW.D\u0001g\u0013\tqgMA\u0003BKJ|g\u000e\u000b\u0002\u0007aB\u0011Q,]\u0005\u0003ez\u0013\u0001B^8mCRLG.Z\u0001\u0011C\u0016\u0014xN\\\"pk:$XM\u001d+bg.\u0004\"!M;\n\u0005Y\u0014$aC\"b]\u000e,G\u000e\\1cY\u0016D#a\u00029\u0002#\u0005,'o\u001c8FeJ|'\u000fT8h)\u0006\u001c8\u000e\u000b\u0002\ta\u0006i\u0011-\u001a:p]\u0016\u0013(o\u001c:M_\u001e\u0004\"\u0001\u0012?\n\u0005u\f#!D!fe>tWI\u001d:pe2{w\r\u000b\u0002\na\u0006QA/Y:l%Vtg.\u001a:\u0016\u0005\u0005\r\u0001c\u0001#\u0002\u0006%\u0019\u0011qA\u0011\u0003\u0015Q\u000b7o\u001b*v]:,'/A\u0006uCN\\'+\u001e8oKJ\u0004\u0013aD8vi\n|WO\u001c3DQ\u0006tg.\u001a7\u0015\t\u0005=\u0011Q\u0005\t\u0005\u0003#\tyB\u0004\u0003\u0002\u0014\u0005m\u0001cAA\u000b=6\u0011\u0011q\u0003\u0006\u0004\u00033y\u0013A\u0002\u001fs_>$h(C\u0002\u0002\u001ey\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\u0011\u0003G\u0011aa\u0015;sS:<'bAA\u000f=\"9\u0011q\u0005\u0007A\u0002\u0005%\u0012!A1\u0011\u0007E\nY#C\u0002\u0002.I\u0012q!\u00113ee\u0016\u001c8/\u0001\bti\u0006\u0014H\u000f\u0016:b]N\u0004xN\u001d;\u0015\u0005\u0005M\u0002cA/\u00026%\u0019\u0011q\u00070\u0003\tUs\u0017\u000e^\u0001\u0011gR\f'\u000f^'fI&\fGI]5wKJ\f\u0001\"Y3s_:$\u0015N]\u000b\u0003\u0003\u001f\tqb\u001d;pa6+G-[1Ee&4XM]\u0001\u000bgR\f'\u000f^!fe>t\u0017a\u00062m_\u000e\\WK\u001c;jY\u000eC\u0017M\u001c8fY\u0006\u001bG/\u001b<f\u0003I\u0019H/\u0019:u\u0003\u0016\u0014xN\\#se>\u0014Hj\\4\u0002)M$\u0018M\u001d;BKJ|gnQ8v]R,'\u000fT8h\u0003UyW\u000f\u001e2pk:$GK]1ogB|'\u000f^*j].$\u0002\"!\u0014\u0002v\u0005}\u0014\u0011\u0012\t\t\u0003\u001f\nI&!\u0018\u0002d5\u0011\u0011\u0011\u000b\u0006\u0005\u0003'\n)&\u0001\u0005tG\u0006d\u0017\rZ:m\u0015\r\t9fJ\u0001\u0007gR\u0014X-Y7\n\t\u0005m\u0013\u0011\u000b\u0002\u0005'&t7\u000eE\u0002,\u0003?J1!!\u0019$\u00059)eN^3m_B,')\u001e4gKJ\u0004b!!\u001a\u0002j\u00055TBAA4\u0015\t)f,\u0003\u0003\u0002l\u0005\u001d$A\u0002$viV\u0014X\r\u0005\u0003\u0002p\u0005ET\"A\u0014\n\u0007\u0005MtE\u0001\u0003E_:,\u0007bBA<+\u0001\u0007\u0011\u0011P\u0001\u0010_V$(m\\;oI\u000e{g\u000e^3yiB\u00191&a\u001f\n\u0007\u0005u4EA\bPkR\u0014w.\u001e8e\u0007>tG/\u001a=u\u0011\u001d\t\t)\u0006a\u0001\u0003\u0007\u000b\u0001b\u001d;sK\u0006l\u0017\n\u001a\t\u0004;\u0006\u0015\u0015bAAD=\n\u0019\u0011J\u001c;\t\u000f\u0005-U\u00031\u0001\u0002\u000e\u0006Q!-\u001e4gKJ\u0004vn\u001c7\u0011\u0007-\ny)C\u0002\u0002\u0012\u000e\u0012!#\u00128wK2|\u0007/\u001a\"vM\u001a,'\u000fU8pY\u0006Y\u0011-\u001a:p]N{WO]2f)!\t9*!(\u0002 \u0006\r\u0006cBA(\u00033\u000bi\u0006S\u0005\u0005\u00037\u000b\tF\u0001\u0004T_V\u00148-\u001a\u0005\b\u0003\u00033\u0002\u0019AAB\u0011\u001d\t\tK\u0006a\u0001\u0003\u001b\u000bA\u0001]8pY\"9\u0011Q\u0015\fA\u0002\u0005=\u0011AD5oE>,h\u000eZ\"iC:tW\r\\\u0001\u001cC\u0016\u0014xN\\*pkJ\u001cWm\u00159j]:LgnZ*ue\u0006$XmZ=\u0016\u0005\u0005\r\u0015A\u00052j]\u0012LeNY8v]\u0012\u001cFO]3b[N$\"!a,\u0011\u000fu\u000b\t,a!\u0002\u0004&\u0019\u00111\u00170\u0003\rQ+\b\u000f\\33\u0003E\u0011XO\\%oE>,h\u000eZ*ue\u0016\fWn\u001d\u000b\u0007\u0003g\tI,!0\t\u000f\u0005m\u0016\u00041\u0001\u0002\u0004\u0006!\u0001o\u001c:u\u0011\u001d\ty,\u0007a\u0001\u0003\u0007\u000b\u0001BY5oIB{'\u000f^\u0001\u0018eVt\u0017J\u001c2pk:$7i\u001c8ue>d7\u000b\u001e:fC6$B!a\r\u0002F\"9\u0011Q\u0015\u000eA\u0002\u0005=\u0011\u0001\t:v]&s'm\\;oI>\u0013H-\u001b8beflUm]:bO\u0016\u001c8\u000b\u001e:fC6$B!a\r\u0002L\"9\u0011QU\u000eA\u0002\u0005=\u0011!\b:v]&s'm\\;oI2\u000b'oZ3NKN\u001c\u0018mZ3t'R\u0014X-Y7\u0015\t\u0005M\u0012\u0011\u001b\u0005\b\u0003Kc\u0002\u0019AA\b\u0003U)\b\u000fZ1uKN#(/Z1n\u001b\u0006$h+\u00197vKN$\u0002\"a\r\u0002X\u0006e\u0017Q\u001c\u0005\b\u0003\u0003k\u0002\u0019AAB\u0011\u0019\tY.\ba\u0001\u0011\u0006!\u0012-\u001a:p]N{WO]2f\u0019&4WmY=dY\u0016Dq!a8\u001e\u0001\u0004\t\u0019'A\u0005d_6\u0004H.\u001a;fI\u0006\t2\u000f[;uI><h\u000e\u0016:b]N\u0004xN\u001d;\u0015\u0005\u0005\r\u0014AD1vi>\u001cV\r\\3diB{'\u000f\u001e\u000b\u0005\u0003\u0007\u000bI\u000fC\u0004\u0002l~\u0001\r!a\u0004\u0002\u0011!|7\u000f\u001e8b[\u0016\u0004")
public class ArteryAeronUdpTransport
extends ArteryTransport {
    private final AtomicReference<Option<MediaDriver>> mediaDriver = new AtomicReference<None$>(None$.MODULE$);
    public volatile Aeron akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeron;
    public volatile Cancellable akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeronCounterTask;
    public volatile Cancellable akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeronErrorLogTask;
    private volatile AeronErrorLog aeronErrorLog;
    private final TaskRunner akka$remote$artery$aeron$ArteryAeronUdpTransport$$taskRunner = new TaskRunner(this.system(), this.settings().Advanced().Aeron().IdleCpuLevel());

    public TaskRunner akka$remote$artery$aeron$ArteryAeronUdpTransport$$taskRunner() {
        return this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$taskRunner;
    }

    private String outboundChannel(Address a) {
        return new StringBuilder(20).append("aeron:udp?endpoint=").append(a.host().get()).append(":").append(a.port().get()).toString();
    }

    @Override
    public void startTransport() {
        this.startMediaDriver();
        this.startAeron();
        this.startAeronErrorLog();
        this.flightRecorder().transportAeronErrorLogStarted();
        if (this.settings().Advanced().Aeron().LogAeronCounters()) {
            this.startAeronCounterLog();
        }
        this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$taskRunner().start();
        this.flightRecorder().transportTaskRunnerStarted();
    }

    private void startMediaDriver() {
        if (this.settings().Advanced().Aeron().EmbeddedMediaDriver()) {
            MediaDriver.Context context;
            MediaDriver.Context driverContext = new MediaDriver.Context();
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.settings().Advanced().Aeron().AeronDirectoryName()))) {
                context = driverContext.aeronDirectoryName(this.settings().Advanced().Aeron().AeronDirectoryName());
            } else {
                String uniquePart = UUID.randomUUID().toString();
                String randomName = new StringBuilder(1).append(CommonContext.getAeronDirectoryName()).append(File.separator).append(this.system().name()).append("-").append(uniquePart).toString();
                context = driverContext.aeronDirectoryName(randomName);
            }
            driverContext.clientLivenessTimeoutNs(this.settings().Advanced().Aeron().ClientLivenessTimeout().toNanos());
            driverContext.publicationUnblockTimeoutNs(this.settings().Advanced().Aeron().PublicationUnblockTimeout().toNanos());
            driverContext.imageLivenessTimeoutNs(this.settings().Advanced().Aeron().ImageLivenessTimeout().toNanos());
            driverContext.driverTimeoutMs(this.settings().Advanced().Aeron().DriverTimeout().toMillis());
            int idleCpuLevel = this.settings().Advanced().Aeron().IdleCpuLevel();
            MediaDriver.Context context2 = idleCpuLevel == 10 ? driverContext.threadingMode(ThreadingMode.DEDICATED).conductorIdleStrategy((IdleStrategy)new BackoffIdleStrategy(1L, 1L, 1L, 1L)).receiverIdleStrategy(TaskRunner$.MODULE$.createIdleStrategy(idleCpuLevel)).senderIdleStrategy(TaskRunner$.MODULE$.createIdleStrategy(idleCpuLevel)).conductorThreadFactory(this.system().threadFactory()).receiverThreadFactory(this.system().threadFactory()).senderThreadFactory(this.system().threadFactory()) : (idleCpuLevel == 1 ? driverContext.threadingMode(ThreadingMode.SHARED).sharedIdleStrategy(TaskRunner$.MODULE$.createIdleStrategy(idleCpuLevel)).sharedThreadFactory(this.system().threadFactory()) : (idleCpuLevel <= 7 ? driverContext.threadingMode(ThreadingMode.SHARED_NETWORK).sharedNetworkIdleStrategy(TaskRunner$.MODULE$.createIdleStrategy(idleCpuLevel)).sharedNetworkThreadFactory(this.system().threadFactory()).conductorThreadFactory(this.system().threadFactory()) : driverContext.threadingMode(ThreadingMode.DEDICATED).receiverIdleStrategy(TaskRunner$.MODULE$.createIdleStrategy(idleCpuLevel)).senderIdleStrategy(TaskRunner$.MODULE$.createIdleStrategy(idleCpuLevel)).receiverThreadFactory(this.system().threadFactory()).senderThreadFactory(this.system().threadFactory()).conductorThreadFactory(this.system().threadFactory())));
            MediaDriver driver = MediaDriver.launchEmbedded((MediaDriver.Context)driverContext);
            this.log().info("Started embedded media driver in directory [{}]", (Object)driver.aeronDirectoryName());
            this.flightRecorder().transportMediaDriverStarted(driver.aeronDirectoryName());
            if (!this.mediaDriver.compareAndSet((Option<MediaDriver>)None$.MODULE$, (Option<MediaDriver>)new Some((Object)driver))) {
                throw new IllegalStateException("media driver started more than once");
            }
        }
    }

    private String aeronDir() {
        String string;
        Option<MediaDriver> option = this.mediaDriver.get();
        if (option instanceof Some) {
            Some some = (Some)option;
            MediaDriver driver = (MediaDriver)some.value();
            string = driver.aeronDirectoryName();
        } else if (None$.MODULE$.equals(option)) {
            string = this.settings().Advanced().Aeron().AeronDirectoryName();
        } else {
            throw new MatchError(option);
        }
        return string;
    }

    private void stopMediaDriver() {
        Option<MediaDriver> maybeDriver = this.mediaDriver.getAndSet((Option<MediaDriver>)None$.MODULE$);
        maybeDriver.foreach((Function1 & Serializable)driver -> {
            ArteryAeronUdpTransport.$anonfun$stopMediaDriver$1(this, driver);
            return BoxedUnit.UNIT;
        });
    }

    private void startAeron() {
        Aeron.Context ctx = new Aeron.Context();
        ctx.driverTimeoutMs(this.settings().Advanced().Aeron().DriverTimeout().toMillis());
        ctx.threadFactory(this.system().threadFactory());
        ctx.availableImageHandler(new AvailableImageHandler(this){
            private final /* synthetic */ ArteryAeronUdpTransport $outer;

            public void onAvailableImage(Image img) {
                block0: {
                    if (!this.$outer.log().isDebugEnabled()) break block0;
                    this.$outer.log().debug(new StringBuilder(31).append("onAvailableImage from ").append(img.sourceIdentity()).append(" session ").append(img.sessionId()).toString());
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        ctx.unavailableImageHandler(new UnavailableImageHandler(this){
            private final /* synthetic */ ArteryAeronUdpTransport $outer;

            public void onUnavailableImage(Image img) {
                if (this.$outer.log().isDebugEnabled()) {
                    this.$outer.log().debug(new StringBuilder(33).append("onUnavailableImage from ").append(img.sourceIdentity()).append(" session ").append(img.sessionId()).toString());
                }
                ((MapOps)this.$outer.streamMatValues().get()).valuesIterator().foreach((Function1 & Serializable)x0$1 -> {
                    $anon$2.$anonfun$onUnavailableImage$1(img, x0$1);
                    return BoxedUnit.UNIT;
                });
            }

            public static final /* synthetic */ void $anonfun$onUnavailableImage$1(Image img$1, ArteryTransport.InboundStreamMatValues x0$1) {
                ArteryTransport.InboundStreamMatValues inboundStreamMatValues = x0$1;
                if (inboundStreamMatValues == null) {
                    throw new MatchError((Object)inboundStreamMatValues);
                }
                AeronSource.AeronLifecycle resourceLife = (AeronSource.AeronLifecycle)inboundStreamMatValues.lifeCycle();
                resourceLife.onUnavailableImage(img$1.sessionId());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onUnavailableImage$1$adapted(io.aeron.Image akka.remote.artery.ArteryTransport$InboundStreamMatValues )}, serializedLambda);
            }
        });
        ctx.errorHandler(new ErrorHandler(this){
            private final AtomicBoolean fatalErrorOccured;
            private final /* synthetic */ ArteryAeronUdpTransport $outer;

            private AtomicBoolean fatalErrorOccured() {
                return this.fatalErrorOccured;
            }

            public void onError(Throwable cause) {
                Throwable throwable = cause;
                if (throwable instanceof ConductorServiceTimeoutException) {
                    ConductorServiceTimeoutException conductorServiceTimeoutException = (ConductorServiceTimeoutException)throwable;
                    this.handleFatalError((Throwable)conductorServiceTimeoutException);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (throwable instanceof DriverTimeoutException) {
                    DriverTimeoutException driverTimeoutException = (DriverTimeoutException)throwable;
                    this.handleFatalError(driverTimeoutException);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (throwable instanceof ArteryTransport.AeronTerminated) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.$outer.log().error(cause, new StringBuilder(13).append("Aeron error, ").append(cause).toString());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }

            private void handleFatalError(Throwable cause) {
                if (this.fatalErrorOccured().compareAndSet(false, true)) {
                    if (!this.$outer.isShutdown()) {
                        this.$outer.log().error(cause, "Fatal Aeron error {}. Have to terminate ActorSystem because it lost contact with the {} Aeron media driver. Possible configuration properties to mitigate the problem are 'client-liveness-timeout' or 'driver-timeout'. {}", (Object)Logging$.MODULE$.simpleName((Object)cause), (Object)(this.$outer.settings().Advanced().Aeron().EmbeddedMediaDriver() ? "embedded" : "external"), (Object)cause);
                        this.$outer.akka$remote$artery$aeron$ArteryAeronUdpTransport$$taskRunner().stop();
                        this.$outer.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeronErrorLogTask.cancel();
                        Object object = this.$outer.settings().Advanced().Aeron().LogAeronCounters() ? BoxesRunTime.boxToBoolean((boolean)this.$outer.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeronCounterTask.cancel()) : BoxedUnit.UNIT;
                        this.$outer.system().terminate();
                        throw new ArteryTransport.AeronTerminated(cause);
                    }
                } else {
                    throw new ArteryTransport.AeronTerminated(cause);
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.fatalErrorOccured = new AtomicBoolean();
            }
        });
        ctx.aeronDirectoryName(this.aeronDir());
        this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeron = Aeron.connect((Aeron.Context)ctx);
    }

    private void blockUntilChannelActive() {
        AeronSource.AeronLifecycle aeronLifecyle = (AeronSource.AeronLifecycle)((ArteryTransport.InboundStreamMatValues)((MapOps)this.streamMatValues().get()).apply((Object)BoxesRunTime.boxToInteger((int)ArteryTransport$.MODULE$.ControlStreamId()))).lifeCycle();
        int waitInterval = 200;
        long retries = package$.MODULE$.max(1L, this.settings().Bind().BindTimeout().toMillis() / (long)waitInterval);
        this.retry$1(retries, aeronLifecyle, waitInterval);
    }

    private void startAeronErrorLog() {
        this.aeronErrorLog = new AeronErrorLog(new File(this.aeronDir(), "cnc.dat"), (LoggingAdapter)this.log());
        AtomicLong lastTimestamp = new AtomicLong(0L);
        MessageDispatcher ec = this.system().dispatchers().internalDispatcher();
        this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeronErrorLogTask = this.system().scheduler().scheduleWithFixedDelay(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(3)).seconds(), new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(5)).seconds(), () -> {
            block0: {
                if (this.isShutdown()) break block0;
                long newLastTimestamp = $this.aeronErrorLog.logErrors((LoggingAdapter)this.log(), lastTimestamp.get());
                lastTimestamp.set(newLastTimestamp + 1L);
            }
        }, (ExecutionContext)ec);
    }

    private void startAeronCounterLog() {
        MessageDispatcher ec = this.system().dispatchers().internalDispatcher();
        this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeronCounterTask = this.system().scheduler().scheduleWithFixedDelay(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(5)).seconds(), new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(5)).seconds(), () -> {
            block0: {
                if (this.isShutdown() || !this.log().isDebugEnabled()) break block0;
                $this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeron.countersReader().forEach(new CountersReader.MetaData(this){
                    private final /* synthetic */ ArteryAeronUdpTransport $outer;

                    public void accept(int counterId, int typeId, DirectBuffer keyBuffer, String label) {
                        long value = this.$outer.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeron.countersReader().getCounterValue(counterId);
                        this.$outer.log().debug("Aeron Counter {}: {} {}]", (Object)BoxesRunTime.boxToInteger((int)counterId), (Object)BoxesRunTime.boxToLong((long)value), (Object)label);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
        }, (ExecutionContext)ec);
    }

    @Override
    public Sink<EnvelopeBuffer, Future<Done>> outboundTransportSink(OutboundContext outboundContext, int streamId, EnvelopeBufferPool bufferPool) {
        FiniteDuration giveUpAfter = streamId == ArteryTransport$.MODULE$.ControlStreamId() ? this.settings().Advanced().GiveUpSystemMessageAfter() : this.settings().Advanced().Aeron().GiveUpMessageAfter();
        return Sink$.MODULE$.fromGraph((Graph)new AeronSink(this.outboundChannel(outboundContext.remoteAddress()), streamId, this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeron, this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$taskRunner(), bufferPool, (Duration)giveUpAfter, this.flightRecorder()));
    }

    private Source<EnvelopeBuffer, AeronSource.AeronLifecycle> aeronSource(int streamId, EnvelopeBufferPool pool, String inboundChannel) {
        return Source$.MODULE$.fromGraph((Graph)new AeronSource(inboundChannel, streamId, this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeron, this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$taskRunner(), pool, this.flightRecorder(), this.aeronSourceSpinningStrategy()));
    }

    private int aeronSourceSpinningStrategy() {
        return this.settings().Advanced().InboundLanes() > 1 || this.settings().Advanced().Aeron().IdleCpuLevel() < 5 ? 0 : 50 * this.settings().Advanced().Aeron().IdleCpuLevel() - 240;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Tuple2<Object, Object> bindInboundStreams() {
        int n;
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(this.settings().Canonical().Port(), this.settings().Bind().Port());
        if (sp2 != null) {
            int n2 = sp2._1$mcI$sp();
            int n3 = sp2._2$mcI$sp();
            if (0 == n2 && 0 == n3) {
                int p = this.autoSelectPort(this.settings().Bind().Hostname());
                return new Tuple2.mcII.sp(p, p);
            }
        }
        if (sp2 != null && 0 == (n = sp2._1$mcI$sp())) {
            return new Tuple2.mcII.sp(this.settings().Bind().Port(), this.settings().Bind().Port());
        }
        if (sp2 == null) return new Tuple2.mcII.sp(this.settings().Canonical().Port(), this.settings().Bind().Port());
        int n4 = sp2._2$mcI$sp();
        if (0 != n4) return new Tuple2.mcII.sp(this.settings().Canonical().Port(), this.settings().Bind().Port());
        return new Tuple2.mcII.sp(this.settings().Canonical().Port(), this.autoSelectPort(this.settings().Bind().Hostname()));
    }

    @Override
    public void runInboundStreams(int port, int bindPort) {
        String inboundChannel = new StringBuilder(20).append("aeron:udp?endpoint=").append(this.settings().Bind().Hostname()).append(":").append(bindPort).toString();
        this.runInboundControlStream(inboundChannel);
        this.runInboundOrdinaryMessagesStream(inboundChannel);
        if (this.largeMessageChannelEnabled()) {
            this.runInboundLargeMessagesStream(inboundChannel);
        }
        this.blockUntilChannelActive();
    }

    private void runInboundControlStream(String inboundChannel) {
        if (this.isShutdown()) {
            throw ArteryTransport$ShuttingDown$.MODULE$;
        }
        Tuple3 tuple3 = (Tuple3)this.aeronSource(ArteryTransport$.MODULE$.ControlStreamId(), this.envelopeBufferPool(), inboundChannel).via(this.inboundFlow(this.settings(), NoInboundCompressions$.MODULE$)).toMat(this.inboundControlSink(), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2;
            AeronSource.AeronLifecycle a;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = new Tuple2(x0$1, x1$1);
                    if (tuple22 == null) break block2;
                    a = (AeronSource.AeronLifecycle)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            InboundControlJunction.ControlMessageSubject c = (InboundControlJunction.ControlMessageSubject)tuple2._1();
            Future d = (Future)tuple2._2();
            Tuple3 tuple3 = new Tuple3((Object)a, (Object)c, (Object)d);
            return tuple3;
        }).run(this.controlMaterializer());
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        AeronSource.AeronLifecycle resourceLife = (AeronSource.AeronLifecycle)tuple3._1();
        InboundControlJunction.ControlMessageSubject ctrl = (InboundControlJunction.ControlMessageSubject)tuple3._2();
        Future completed = (Future)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)resourceLife, (Object)ctrl, (Object)completed);
        Tuple3 tuple33 = tuple32;
        AeronSource.AeronLifecycle resourceLife2 = (AeronSource.AeronLifecycle)tuple33._1();
        InboundControlJunction.ControlMessageSubject ctrl2 = (InboundControlJunction.ControlMessageSubject)tuple33._2();
        Future completed2 = (Future)tuple33._3();
        this.attachControlMessageObserver(ctrl2);
        this.updateStreamMatValues(ArteryTransport$.MODULE$.ControlStreamId(), resourceLife2, (Future<Done>)completed2);
        this.attachInboundStreamRestart("Inbound control stream", (Future<Done>)completed2, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.runInboundControlStream(inboundChannel));
    }

    private void runInboundOrdinaryMessagesStream(String inboundChannel) {
        Tuple3 tuple3;
        Tuple3 tuple32;
        if (this.isShutdown()) {
            throw ArteryTransport$ShuttingDown$.MODULE$;
        }
        if (this.inboundLanes() == 1) {
            tuple32 = (Tuple3)this.aeronSource(ArteryTransport$.MODULE$.OrdinaryStreamId(), this.envelopeBufferPool(), inboundChannel).viaMat(this.inboundFlow(this.settings(), this._inboundCompressions()), Keep$.MODULE$.both()).toMat(this.inboundSink(this.envelopeBufferPool()), (Function2 & Serializable)(x0$1, x1$1) -> {
                Future c;
                Tuple2 tuple2;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = new Tuple2(x0$1, x1$1);
                        if (tuple22 == null) break block2;
                        tuple2 = (Tuple2)tuple22._1();
                        c = (Future)tuple22._2();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                AeronSource.AeronLifecycle a = (AeronSource.AeronLifecycle)tuple2._1();
                Decoder.InboundCompressionAccess b = (Decoder.InboundCompressionAccess)tuple2._2();
                Tuple3 tuple3 = new Tuple3((Object)a, (Object)b, (Object)c);
                return tuple3;
            }).run(this.materializer());
        } else {
            SharedKillSwitch laneKillSwitch = KillSwitches$.MODULE$.shared("laneKillSwitch");
            Source laneSource = this.aeronSource(ArteryTransport$.MODULE$.OrdinaryStreamId(), this.envelopeBufferPool(), inboundChannel).via(laneKillSwitch.flow()).viaMat(this.inboundFlow(this.settings(), this._inboundCompressions()), Keep$.MODULE$.both()).via((Graph)Flow$.MODULE$.fromGraph((Graph)new DuplicateHandshakeReq(this.inboundLanes(), this, this.system(), this.envelopeBufferPool()))).via((Graph)Flow$.MODULE$.fromGraph((Graph)new DuplicateFlush(this.inboundLanes(), this.system(), this.envelopeBufferPool())));
            Tuple3 tuple33 = (Tuple3)laneSource.toMat((Graph)Sink$.MODULE$.fromGraph(new FixedSizePartitionHub<InboundEnvelope>(this.inboundLanePartitioner(), this.inboundLanes(), this.settings().Advanced().InboundHubBufferSize())), (Function2 & Serializable)(x0$2, x1$2) -> {
                Source c;
                Tuple2 tuple2;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = new Tuple2(x0$2, x1$2);
                        if (tuple22 == null) break block2;
                        tuple2 = (Tuple2)tuple22._1();
                        c = (Source)tuple22._2();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                AeronSource.AeronLifecycle a = (AeronSource.AeronLifecycle)tuple2._1();
                Decoder.InboundCompressionAccess b = (Decoder.InboundCompressionAccess)tuple2._2();
                Tuple3 tuple3 = new Tuple3((Object)a, (Object)b, (Object)c);
                return tuple3;
            }).run(this.materializer());
            if (tuple33 == null) {
                throw new MatchError((Object)tuple33);
            }
            AeronSource.AeronLifecycle resourceLife = (AeronSource.AeronLifecycle)tuple33._1();
            Decoder.InboundCompressionAccess compressionAccess = (Decoder.InboundCompressionAccess)tuple33._2();
            Source laneHub = (Source)tuple33._3();
            Tuple3 tuple34 = new Tuple3((Object)resourceLife, (Object)compressionAccess, (Object)laneHub);
            Tuple3 tuple35 = tuple34;
            AeronSource.AeronLifecycle resourceLife2 = (AeronSource.AeronLifecycle)tuple35._1();
            Decoder.InboundCompressionAccess compressionAccess2 = (Decoder.InboundCompressionAccess)tuple35._2();
            Source laneHub2 = (Source)tuple35._3();
            Sink<InboundEnvelope, Future<Done>> lane = this.inboundSink(this.envelopeBufferPool());
            Vector completedValues = (Vector)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.inboundLanes()).iterator().map((Function1 & Serializable)x$7 -> ArteryAeronUdpTransport.$anonfun$runInboundOrdinaryMessagesStream$3(this, laneHub2, lane, BoxesRunTime.unboxToInt((Object)x$7))).to(IterableFactory$.MODULE$.toFactory((IterableFactory)Vector$.MODULE$));
            MessageDispatcher ec = this.system().dispatchers().internalDispatcher();
            Future$.MODULE$.firstCompletedOf((IterableOnce)completedValues, (ExecutionContext)ec).failed().foreach((Function1 & Serializable)reason -> {
                laneKillSwitch.abort(reason);
                return BoxedUnit.UNIT;
            }, (ExecutionContext)ec);
            Future allCompleted = Future$.MODULE$.sequence((IterableOnce)completedValues, BuildFrom$.MODULE$.buildFromIterableOps(), (ExecutionContext)ec).map((Function1 & Serializable)x$8 -> Done$.MODULE$, (ExecutionContext)ec);
            tuple32 = tuple3 = new Tuple3((Object)resourceLife2, (Object)compressionAccess2, (Object)allCompleted);
        }
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        AeronSource.AeronLifecycle resourceLife = (AeronSource.AeronLifecycle)tuple3._1();
        Decoder.InboundCompressionAccess inboundCompressionAccess = (Decoder.InboundCompressionAccess)tuple3._2();
        Future completed = (Future)tuple3._3();
        Tuple3 tuple36 = new Tuple3((Object)resourceLife, (Object)inboundCompressionAccess, (Object)completed);
        Tuple3 tuple37 = tuple36;
        AeronSource.AeronLifecycle resourceLife3 = (AeronSource.AeronLifecycle)tuple37._1();
        Decoder.InboundCompressionAccess inboundCompressionAccess2 = (Decoder.InboundCompressionAccess)tuple37._2();
        Future completed2 = (Future)tuple37._3();
        this.setInboundCompressionAccess(inboundCompressionAccess2);
        this.updateStreamMatValues(ArteryTransport$.MODULE$.OrdinaryStreamId(), resourceLife3, (Future<Done>)completed2);
        this.attachInboundStreamRestart("Inbound message stream", (Future<Done>)completed2, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.runInboundOrdinaryMessagesStream(inboundChannel));
    }

    private void runInboundLargeMessagesStream(String inboundChannel) {
        if (this.isShutdown()) {
            throw ArteryTransport$ShuttingDown$.MODULE$;
        }
        Tuple2 tuple2 = (Tuple2)this.aeronSource(ArteryTransport$.MODULE$.LargeStreamId(), this.largeEnvelopeBufferPool(), inboundChannel).via(this.inboundLargeFlow(this.settings())).toMat(this.inboundSink(this.largeEnvelopeBufferPool()), Keep$.MODULE$.both()).run(this.materializer());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        AeronSource.AeronLifecycle resourceLife = (AeronSource.AeronLifecycle)tuple2._1();
        Future completed = (Future)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)resourceLife, (Object)completed);
        Tuple2 tuple23 = tuple22;
        AeronSource.AeronLifecycle resourceLife2 = (AeronSource.AeronLifecycle)tuple23._1();
        Future completed2 = (Future)tuple23._2();
        this.updateStreamMatValues(ArteryTransport$.MODULE$.LargeStreamId(), resourceLife2, (Future<Done>)completed2);
        this.attachInboundStreamRestart("Inbound large message stream", (Future<Done>)completed2, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.runInboundLargeMessagesStream(inboundChannel));
    }

    private void updateStreamMatValues(int streamId, AeronSource.AeronLifecycle aeronSourceLifecycle, Future<Done> completed) {
        ExecutionContextExecutor ec = this.materializer().executionContext();
        this.updateStreamMatValues(streamId, new ArteryTransport.InboundStreamMatValues<Object>(aeronSourceLifecycle, (Future<Done>)completed.recover((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Done$ done$ = Done$.MODULE$;
                return (B1)done$;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }
        }, (ExecutionContext)ec)));
    }

    @Override
    public Future<Done> shutdownTransport() {
        return this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$taskRunner().stop().map((Function1 & Serializable)x$11 -> {
            block3: {
                this.flightRecorder().transportStopped();
                if ($this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeronErrorLogTask != null) {
                    $this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeronErrorLogTask.cancel();
                    this.flightRecorder().transportAeronErrorLogTaskStopped();
                }
                if ($this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeron != null) {
                    $this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeron.close();
                }
                if ($this.aeronErrorLog != null) {
                    $this.aeronErrorLog.close();
                }
                if (!$this.mediaDriver.get().isDefined()) break block3;
                this.stopMediaDriver();
            }
            return Done$.MODULE$;
        }, (ExecutionContext)this.system().dispatchers().internalDispatcher());
    }

    /*
     * WARNING - void declaration
     */
    public int autoSelectPort(String hostname) {
        void var3_3;
        DatagramSocket socket = DatagramChannel.open().socket();
        socket.bind(new InetSocketAddress(hostname, 0));
        int port = socket.getLocalPort();
        socket.close();
        return (int)var3_3;
    }

    public static final /* synthetic */ void $anonfun$stopMediaDriver$1(ArteryAeronUdpTransport $this, MediaDriver driver) {
        $this.log().info("Stopping embedded media driver in directory [{}]", (Object)driver.aeronDirectoryName());
        try {
            driver.close();
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable e = (Throwable)option.get();
                $this.log().warning("Couldn't close Aeron embedded media driver due to [{}]", (Object)e);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
        try {
            if ($this.settings().Advanced().Aeron().DeleteAeronDirectory()) {
                IoUtil.delete((File)new File(driver.aeronDirectoryName()), (boolean)false);
                $this.flightRecorder().transportMediaFileDeleted();
            }
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable3 = throwable;
            if (throwable3 != null && !(option = NonFatal$.MODULE$.unapply(throwable3)).isEmpty()) {
                Throwable e = (Throwable)option.get();
                $this.log().warning("Couldn't delete Aeron embedded media driver files in [{}] due to [{}]", (Object)driver.aeronDirectoryName(), (Object)e);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    private final void retry$1(long retries, AeronSource.AeronLifecycle aeronLifecyle$1, int waitInterval$1) {
        block2: {
            while (true) {
                long status;
                if ((status = BoxesRunTime.unboxToLong((Object)Await$.MODULE$.result(aeronLifecyle$1.channelEndpointStatus(), (Duration)this.settings().Bind().BindTimeout()))) == 1L) break block2;
                if (status == -1L) {
                    this.aeronErrorLog.logErrors((LoggingAdapter)this.log(), 0L);
                    this.stopMediaDriver();
                    throw new RemoteTransportException("Inbound Aeron channel is in errored state. See Aeron logs for details.");
                }
                if (status != 0L || retries <= 0L) break;
                Thread.sleep(waitInterval$1);
                --retries;
            }
            this.aeronErrorLog.logErrors((LoggingAdapter)this.log(), 0L);
            this.stopMediaDriver();
            throw new RemoteTransportException("Timed out waiting for Aeron transport to bind. See Aeoron logs.");
        }
        this.log().debug("Inbound channel is now active");
    }

    public static final /* synthetic */ Future $anonfun$runInboundOrdinaryMessagesStream$3(ArteryAeronUdpTransport $this, Source laneHub$1, Sink lane$1, int x$7) {
        return (Future)laneHub$1.toMat((Graph)lane$1, Keep$.MODULE$.right()).run($this.materializer());
    }

    public ArteryAeronUdpTransport(ExtendedActorSystem _system, RemoteActorRefProvider _provider) {
        super(_system, _provider);
    }
}

